/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.iterator;

import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIter;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.Utils;
import org.openjena.atlas.io.IndentedWriter;

public abstract class QueryIter2
extends QueryIter {
    private QueryIterator leftInput;
    private QueryIterator rightInput;

    public QueryIter2(QueryIterator left, QueryIterator right, ExecutionContext execCxt) {
        super(execCxt);
        this.leftInput = left;
        this.rightInput = right;
    }

    protected QueryIterator getLeft() {
        return this.leftInput;
    }

    protected QueryIterator getRight() {
        return this.rightInput;
    }

    protected final void closeIterator() {
        this.closeSubIterator();
        QueryIter2.performClose(this.leftInput);
        QueryIter2.performClose(this.rightInput);
        this.leftInput = null;
        this.rightInput = null;
    }

    protected final void requestCancel() {
        QueryIter2.performRequestCancel(this.leftInput);
        QueryIter2.performRequestCancel(this.rightInput);
    }

    protected abstract void requestSubCancel();

    protected abstract void closeSubIterator();

    public void output(IndentedWriter out, SerializationContext sCxt) {
        out.println(Utils.className(this));
        out.incIndent();
        out.print("(");
        out.incIndent();
        this.getLeft().output(out, sCxt);
        out.decIndent();
        out.println(")");
        out.print("(");
        out.incIndent();
        this.getRight().output(out, sCxt);
        out.decIndent();
        out.println(")");
        out.decIndent();
    }
}

