/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.ref;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.Table;
import com.hp.hpl.jena.sparql.algebra.TableFactory;
import com.hp.hpl.jena.sparql.algebra.op.OpDatasetNames;
import com.hp.hpl.jena.sparql.algebra.op.OpGraph;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.algebra.table.TableEmpty;
import com.hp.hpl.jena.sparql.algebra.table.TableUnit;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingFactory;
import com.hp.hpl.jena.sparql.engine.binding.BindingRoot;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterConcat;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterRoot;
import com.hp.hpl.jena.sparql.engine.main.StageBuilder;
import com.hp.hpl.jena.sparql.engine.ref.Evaluator;
import com.hp.hpl.jena.sparql.engine.ref.EvaluatorDispatch;
import com.hp.hpl.jena.sparql.engine.ref.EvaluatorFactory;
import java.util.ArrayList;
import java.util.Iterator;

public class Eval {
    public static Table eval(Evaluator evaluator, Op op) {
        EvaluatorDispatch ev = new EvaluatorDispatch(evaluator);
        op.visit(ev);
        Table table = ev.getResult();
        return table;
    }

    static Table evalDS(OpDatasetNames opDSN, Evaluator evaluator) {
        Node graphNode = opDSN.getGraphNode();
        if (graphNode.isURI()) {
            if (evaluator.getExecContext().getDataset().containsGraph(graphNode)) {
                return new TableUnit();
            }
            return new TableEmpty();
        }
        if (!Var.isVar(graphNode)) {
            throw new ARQInternalErrorException("OpDatasetNames: Not a URI or variable: " + graphNode);
        }
        DatasetGraph dsg = evaluator.getExecContext().getDataset();
        Iterator<Node> iter = dsg.listGraphNodes();
        ArrayList<Binding> list = new ArrayList<Binding>((int)dsg.size());
        while (iter.hasNext()) {
            Node gn = iter.next();
            Binding b = BindingFactory.binding(Var.alloc(graphNode), gn);
            list.add(b);
        }
        QueryIterPlainWrapper qIter = new QueryIterPlainWrapper(list.iterator(), evaluator.getExecContext());
        return TableFactory.create(qIter);
    }

    static Table evalGraph(OpGraph opGraph, Evaluator evaluator) {
        ExecutionContext execCxt = evaluator.getExecContext();
        if (!Var.isVar(opGraph.getNode())) {
            Graph graph = execCxt.getDataset().getGraph(opGraph.getNode());
            if (graph == null) {
                return new TableEmpty();
            }
            ExecutionContext execCxt2 = new ExecutionContext(execCxt, graph);
            Evaluator e2 = EvaluatorFactory.create(execCxt2);
            return Eval.eval(e2, opGraph.getSubOp());
        }
        Var gVar = Var.alloc(opGraph.getNode());
        Table current = null;
        Iterator<Node> iter = execCxt.getDataset().listGraphNodes();
        while (iter.hasNext()) {
            Node gn = iter.next();
            Graph graph = execCxt.getDataset().getGraph(gn);
            ExecutionContext execCxt2 = new ExecutionContext(execCxt, graph);
            Evaluator e2 = EvaluatorFactory.create(execCxt2);
            Table tableVarURI = TableFactory.create(gVar, gn);
            Table patternTable = Eval.eval(e2, opGraph.getSubOp());
            Table stepResult = evaluator.join(patternTable, tableVarURI);
            if (current == null) {
                current = stepResult;
                continue;
            }
            current = evaluator.union(current, stepResult);
        }
        if (current == null) {
            return new TableEmpty();
        }
        return current;
    }

    static Table evalQuadPattern(OpQuadPattern opQuad, Evaluator evaluator) {
        if (opQuad.isEmpty()) {
            return TableFactory.createUnit();
        }
        ExecutionContext cxt = evaluator.getExecContext();
        DatasetGraph ds = cxt.getDataset();
        BasicPattern pattern = opQuad.getBasicPattern();
        if (!opQuad.getGraphNode().isVariable()) {
            if (!opQuad.getGraphNode().isURI()) {
                throw new ARQInternalErrorException("Not a URI or variable: " + opQuad.getGraphNode());
            }
            Graph g = null;
            g = opQuad.isDefaultGraph() ? ds.getDefaultGraph() : ds.getGraph(opQuad.getGraphNode());
            if (g == null) {
                return new TableEmpty();
            }
            ExecutionContext cxt2 = new ExecutionContext(cxt, g);
            QueryIterator qIter = StageBuilder.execute(pattern, QueryIterRoot.create(cxt2), cxt2);
            return TableFactory.create(qIter);
        }
        Var gVar = Var.alloc(opQuad.getGraphNode());
        QueryIterConcat concat2 = new QueryIterConcat(cxt);
        Iterator<Node> graphNodes = cxt.getDataset().listGraphNodes();
        while (graphNodes.hasNext()) {
            Node gn = graphNodes.next();
            Graph g = cxt.getDataset().getGraph(gn);
            Binding b = BindingFactory.binding(BindingRoot.create(), gVar, gn);
            ExecutionContext cxt2 = new ExecutionContext(cxt, g);
            Table t1 = TableFactory.create(gVar, gn);
            QueryIterator qIter = StageBuilder.execute(pattern, QueryIterRoot.create(cxt2), cxt2);
            Table t2 = TableFactory.create(qIter);
            Table t3 = evaluator.join(t1, t2);
            concat2.add(t3.iterator(cxt2));
        }
        return TableFactory.create(concat2);
    }
}

