/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.util;

import com.hp.hpl.jena.sparql.ARQException;

public class Timer {
    protected long timeFinish = -1L;
    protected boolean inTimer = false;
    protected long timeStart = 0L;

    public void startTimer() {
        if (this.inTimer) {
            throw new ARQException("Already in timer");
        }
        this.timeStart = System.currentTimeMillis();
        this.timeFinish = -1L;
        this.inTimer = true;
    }

    public long endTimer() {
        if (!this.inTimer) {
            throw new ARQException("Not in timer");
        }
        this.timeFinish = System.currentTimeMillis();
        this.inTimer = false;
        return this.getTimeInterval();
    }

    public long readTimer() {
        if (!this.inTimer) {
            throw new ARQException("Not in timer");
        }
        return System.currentTimeMillis() - this.timeStart;
    }

    public long getTimeInterval() {
        if (this.inTimer) {
            throw new ARQException("Still timing");
        }
        if (this.timeFinish == -1L) {
            throw new ARQException("No valid interval");
        }
        return this.timeFinish - this.timeStart;
    }

    public static String timeStr(long timeInterval) {
        return String.format("%.3f", (double)timeInterval / 1000.0);
    }

    protected String timeStr(long timePoint, long startTimePoint) {
        return Timer.timeStr(timePoint - startTimePoint);
    }
}

