/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.exporter.trace.datadog;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.opencensus.common.Duration;
import io.opencensus.exporter.trace.datadog.AutoValue_DatadogTraceConfiguration;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class DatadogTraceConfiguration {
    @VisibleForTesting
    static final Duration DEFAULT_DEADLINE = Duration.create((long)10L, (int)0);
    @VisibleForTesting
    static final Duration ZERO = Duration.fromMillis((long)0L);

    DatadogTraceConfiguration() {
    }

    public abstract String getAgentEndpoint();

    public abstract String getService();

    public abstract String getType();

    public abstract Duration getDeadline();

    public static Builder builder() {
        return new AutoValue_DatadogTraceConfiguration.Builder().setDeadline(DEFAULT_DEADLINE);
    }

    public static abstract class Builder {
        Builder() {
        }

        public abstract Builder setAgentEndpoint(String var1);

        public abstract Builder setService(String var1);

        public abstract Builder setType(String var1);

        public abstract Builder setDeadline(Duration var1);

        abstract Duration getDeadline();

        abstract DatadogTraceConfiguration autoBuild();

        public DatadogTraceConfiguration build() {
            Preconditions.checkArgument((this.getDeadline().compareTo(ZERO) > 0 ? 1 : 0) != 0, (Object)"Deadline must be positive.");
            return this.autoBuild();
        }
    }
}

