/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.csv.export.computation;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.bulk.BulkCodecs;
import org.nuxeo.ecm.core.bulk.action.computation.AbstractBulkComputation;
import org.nuxeo.ecm.core.bulk.message.BulkCommand;
import org.nuxeo.ecm.core.bulk.message.BulkStatus;
import org.nuxeo.ecm.core.bulk.message.DataBucket;
import org.nuxeo.ecm.core.io.marshallers.csv.AbstractCSVWriter;
import org.nuxeo.ecm.core.io.marshallers.csv.OutputStreamWithCSVWriter;
import org.nuxeo.ecm.core.io.registry.MarshallerRegistry;
import org.nuxeo.ecm.core.io.registry.Writer;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.lib.stream.computation.ComputationContext;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.runtime.api.Framework;

public class CSVProjectionComputation
extends AbstractBulkComputation {
    private static final Logger log = LogManager.getLogger(CSVProjectionComputation.class);
    public static final String PARAM_SCHEMAS = "schemas";
    public static final String PARAM_XPATHS = "xpaths";
    public static final String PARAM_LANG = "lang";
    protected OutputStreamWithCSVWriter out;
    protected RenderingContext renderingCtx;

    public CSVProjectionComputation() {
        super("bulk/csvExport");
    }

    public void startBucket(String bucketKey) {
        this.out = new OutputStreamWithCSVWriter();
        BulkCommand command = this.getCurrentCommand();
        this.renderingCtx = RenderingContext.CtxBuilder.get();
        this.renderingCtx.setParameterValues(PARAM_SCHEMAS, new Object[]{this.getList((Serializable)command.getParams().get(PARAM_SCHEMAS))});
        this.renderingCtx.setParameterValues(PARAM_XPATHS, new Object[]{this.getList((Serializable)command.getParams().get(PARAM_XPATHS))});
        this.renderingCtx.setParameterValues(PARAM_LANG, new Object[]{this.getString((Serializable)command.getParams().get(PARAM_LANG))});
    }

    protected void compute(CoreSession session, List<String> ids, Map<String, Serializable> properties) {
        DocumentModelList docs = this.loadDocuments(session, ids);
        MarshallerRegistry registry = (MarshallerRegistry)Framework.getService(MarshallerRegistry.class);
        Writer writer = registry.getWriter(this.renderingCtx, DocumentModelList.class, AbstractCSVWriter.TEXT_CSV_TYPE);
        try {
            writer.write((Object)docs, DocumentModelList.class, null, AbstractCSVWriter.TEXT_CSV_TYPE, (OutputStream)this.out);
        }
        catch (IOException e) {
            log.error("Unable to write documents", (Throwable)e);
        }
    }

    public void endBucket(ComputationContext context, BulkStatus delta) {
        String commandId = delta.getId();
        String csv = this.out.toString();
        String recordSeparator = CSVFormat.DEFAULT.getRecordSeparator();
        String header = this.getHeader(csv, recordSeparator);
        String data = this.getData(csv, recordSeparator);
        DataBucket dataBucket = new DataBucket(commandId, delta.getProcessed(), data.getBytes(StandardCharsets.UTF_8), header.getBytes(StandardCharsets.UTF_8), new byte[0]);
        Record record = Record.of((String)commandId, (byte[])BulkCodecs.getDataBucketCodec().encode((Object)dataBucket));
        context.produceRecord("o1", record);
        this.out = null;
    }

    protected String getHeader(String csv, String recordSeparator) {
        return csv.substring(0, csv.indexOf(recordSeparator) + recordSeparator.length());
    }

    protected String getData(String csv, String recordSeparator) {
        return csv.substring(csv.indexOf(recordSeparator) + recordSeparator.length());
    }

    protected List<String> getList(Serializable value) {
        if (value == null) {
            return Collections.emptyList();
        }
        if (value instanceof List) {
            List objects = (List)((Object)value);
            ArrayList<String> values = new ArrayList<String>(objects.size());
            for (Object object : objects) {
                if (object == null) continue;
                values.add(object.toString());
            }
            Collections.sort(values);
            return values;
        }
        log.debug("Illegal parameter '{}'", (Object)value);
        return Collections.emptyList();
    }

    protected String getString(Serializable value) {
        if (value instanceof String) {
            return (String)((Object)value);
        }
        return null;
    }
}

