/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.cudf.solver;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.equinox.p2.cudf.metadata.InstallableUnit;
import org.eclipse.equinox.p2.cudf.query.QueryableArray;
import org.eclipse.equinox.p2.cudf.solver.Pair;
import org.eclipse.equinox.p2.cudf.solver.Projector;
import org.eclipse.equinox.p2.cudf.solver.TwoTierMap;
import org.sat4j.core.Vec;
import org.sat4j.pb.tools.LexicoHelper;
import org.sat4j.pb.tools.WeightedObject;
import org.sat4j.specs.ContradictionException;

public abstract class OptimizationFunction {
    protected TwoTierMap slice;
    protected Map<?, ?> noopVariables;
    protected QueryableArray picker;
    protected LexicoHelper<Object, String> dependencyHelper;
    protected List<Projector.AbstractVariable> removalVariables = new ArrayList<Projector.AbstractVariable>();
    protected List<Projector.AbstractVariable> changeVariables = new ArrayList<Projector.AbstractVariable>();
    protected List<Projector.AbstractVariable> versionChangeVariables = new ArrayList<Projector.AbstractVariable>();
    protected List<Projector.AbstractVariable> nouptodateVariables = new ArrayList<Projector.AbstractVariable>();
    protected List<Projector.AbstractVariable> newVariables = new ArrayList<Projector.AbstractVariable>();
    protected List<Projector.AbstractVariable> unmetVariables = new ArrayList<Projector.AbstractVariable>();
    protected List<Projector.AbstractVariable> optionalityVariables;
    protected List<Pair> optionalityPairs;

    public abstract List<WeightedObject<Object>> createOptimizationFunction(InstallableUnit var1);

    public abstract String printSolutionValue();

    protected void removed(Collection<WeightedObject<Object>> weightedObjects, BigInteger weight, InstallableUnit metaIu) {
        Set s = this.slice.entrySet();
        for (Map.Entry entry : s) {
            if (entry.getKey() == metaIu.getId()) continue;
            Collection versions = ((Map)entry.getValue()).values();
            boolean installed = false;
            Object[] literals = new Object[versions.size()];
            int i = 0;
            for (InstallableUnit iuv : versions) {
                installed = installed || iuv.isInstalled();
                literals[i++] = this.dependencyHelper.not((Object)iuv);
            }
            if (!installed) continue;
            try {
                Projector.AbstractVariable abs = new Projector.AbstractVariable(entry.getKey().toString());
                this.removalVariables.add(abs);
                this.dependencyHelper.and((Object)"OPT1", (Object)abs, literals);
                weightedObjects.add((WeightedObject<Object>)WeightedObject.newWO((Object)abs, (BigInteger)weight));
            }
            catch (ContradictionException e) {
                e.printStackTrace();
            }
        }
    }

    protected void versionChanged(List<WeightedObject<Object>> weightedObjects, BigInteger weight, InstallableUnit metaIu) {
        Set s = this.slice.entrySet();
        for (Map.Entry entry : s) {
            if (entry.getKey() == metaIu.getId()) continue;
            Collection versions = ((Map)entry.getValue()).values();
            boolean installed = false;
            Vec changed = new Vec(versions.size());
            for (InstallableUnit iu : versions) {
                boolean bl = installed = installed || iu.isInstalled();
                if (iu.isInstalled()) continue;
                changed.push((Object)iu);
            }
            if (!installed) continue;
            Object[] changedarray = new InstallableUnit[changed.size()];
            changed.copyTo(changedarray);
            try {
                Projector.AbstractVariable abs = new Projector.AbstractVariable(entry.getKey().toString());
                this.versionChangeVariables.add(abs);
                this.dependencyHelper.or((Object)"OPT3", (Object)abs, changedarray);
                weightedObjects.add((WeightedObject<Object>)WeightedObject.newWO((Object)abs, (BigInteger)weight));
            }
            catch (ContradictionException e) {
                e.printStackTrace();
            }
        }
    }

    protected void changed(Collection<WeightedObject<Object>> weightedObjects, BigInteger weight, InstallableUnit metaIu) {
        Set s = this.slice.entrySet();
        for (Map.Entry entry : s) {
            if (entry.getKey() == metaIu.getId()) continue;
            Collection versions = ((Map)entry.getValue()).values();
            Object[] changed = new Object[versions.size()];
            int i = 0;
            for (InstallableUnit iu : versions) {
                changed[i++] = iu.isInstalled() ? this.dependencyHelper.not((Object)iu) : iu;
            }
            try {
                Projector.AbstractVariable abs = new Projector.AbstractVariable(entry.getKey().toString());
                this.changeVariables.add(abs);
                this.dependencyHelper.or((Object)"OPT3", (Object)abs, changed);
                weightedObjects.add((WeightedObject<Object>)WeightedObject.newWO((Object)abs, (BigInteger)weight));
            }
            catch (ContradictionException e) {
                e.printStackTrace();
            }
        }
    }

    protected void uptodate(List<WeightedObject<?>> weightedObjects, BigInteger weight, InstallableUnit metaIu) {
        Set s = this.slice.entrySet();
        for (Map.Entry entry : s) {
            if (entry.getKey() == metaIu.getId()) continue;
            Map versions = (Map)entry.getValue();
            ArrayList toSort = new ArrayList(versions.values());
            Collections.sort(toSort, Collections.reverseOrder());
            weightedObjects.add(WeightedObject.newWO(toSort.get(0), (BigInteger)weight));
        }
    }

    protected void notuptodate(Collection<WeightedObject<Object>> weightedObjects, BigInteger weight, InstallableUnit metaIu) {
        Set s = this.slice.entrySet();
        for (Map.Entry entry : s) {
            if (entry.getKey() == metaIu.getId()) continue;
            Map versions = (Map)entry.getValue();
            ArrayList toSort = new ArrayList(versions.values());
            Collections.sort(toSort, Collections.reverseOrder());
            Projector.AbstractVariable abs = new Projector.AbstractVariable(entry.getKey().toString());
            Object notlatest = this.dependencyHelper.not(toSort.get(0));
            try {
                this.dependencyHelper.implication(new Object[]{abs}).implies(notlatest).named((Object)"OPT4");
                Object[] clause = new Object[toSort.size()];
                toSort.toArray(clause);
                clause[0] = this.dependencyHelper.not((Object)abs);
                this.dependencyHelper.clause((Object)"OPT4", clause);
                for (int i = 1; i < toSort.size(); ++i) {
                    this.dependencyHelper.implication(new Object[]{notlatest, toSort.get(i)}).implies((Object)abs).named((Object)"OPT4");
                }
            }
            catch (ContradictionException e) {
                e.printStackTrace();
            }
            weightedObjects.add((WeightedObject<Object>)WeightedObject.newWO((Object)abs, (BigInteger)weight));
            this.nouptodateVariables.add(abs);
        }
    }

    protected void unmetRecommends(List<WeightedObject<Object>> weightedObjects, BigInteger weight, InstallableUnit metaIu) {
        for (Pair entry : this.optionalityPairs) {
            if (entry.left == metaIu) continue;
            Projector.AbstractVariable abs = new Projector.AbstractVariable(entry.left.toString() + entry.right);
            try {
                this.dependencyHelper.and((Object)"OPTX", (Object)abs, new Object[]{entry.right, entry.left});
            }
            catch (ContradictionException e) {
                e.printStackTrace();
            }
            weightedObjects.add((WeightedObject<Object>)WeightedObject.newWO((Object)abs, (BigInteger)weight));
            this.unmetVariables.add(abs);
        }
    }

    protected void niou(Collection<WeightedObject<Object>> weightedObjects, BigInteger weight, InstallableUnit metaIu) {
        Set s = this.slice.entrySet();
        for (Map.Entry entry : s) {
            if (entry.getKey() == metaIu.getId()) continue;
            Collection versions = ((Map)entry.getValue()).values();
            boolean installed = false;
            for (InstallableUnit iuv : versions) {
                installed = installed || iuv.isInstalled();
            }
            if (installed) continue;
            try {
                Projector.AbstractVariable abs = new Projector.AbstractVariable(entry.getKey().toString());
                this.newVariables.add(abs);
                Projector.AbstractVariable[] clause = new Projector.AbstractVariable[versions.size()];
                versions.toArray(clause);
                this.dependencyHelper.or((Object)"OPT2", (Object)abs, (Object[])clause);
                weightedObjects.add((WeightedObject<Object>)WeightedObject.newWO((Object)abs, (BigInteger)weight));
            }
            catch (ContradictionException e) {
                e.printStackTrace();
            }
        }
    }

    protected void optional(List<WeightedObject<Object>> weightedObjects, BigInteger weight, InstallableUnit metaIu) {
        for (Pair pair : this.optionalityPairs) {
            if (pair.left == metaIu) continue;
            weightedObjects.add((WeightedObject<Object>)WeightedObject.newWO((Object)pair.right, (BigInteger)weight));
            this.unmetVariables.add(pair.right);
        }
    }

    protected void sum(List<WeightedObject<Object>> weightedObjects, boolean minimize, InstallableUnit metaIu, String sumProperty) {
        Set s = this.slice.entrySet();
        for (Map.Entry entry : s) {
            if (entry.getKey() == metaIu.getId()) continue;
            Collection versions = ((Map)entry.getValue()).values();
            for (InstallableUnit iuv : versions) {
                if (iuv.getSumProperty() == 0L) continue;
                BigInteger weight = BigInteger.valueOf(iuv.getSumProperty());
                weightedObjects.add((WeightedObject<Object>)WeightedObject.newWO((Object)iuv, (BigInteger)(minimize ? weight : weight.negate())));
            }
        }
    }

    public abstract String getName();

    public Map<Criteria, List<String>> getSolutionDetails() {
        HashMap<Criteria, List<String>> details = new HashMap<Criteria, List<String>>();
        details.put(Criteria.NEW, this.getAsStringList(this.newVariables));
        details.put(Criteria.REMOVED, this.getAsStringList(this.removalVariables));
        details.put(Criteria.NOTUPTODATE, this.getAsStringList(this.nouptodateVariables));
        details.put(Criteria.RECOMMENDED, this.getAsStringList(this.unmetVariables));
        details.put(Criteria.VERSION_CHANGED, this.getAsStringList(this.versionChangeVariables));
        details.put(Criteria.CHANGED, this.getAsStringList(this.changeVariables));
        return details;
    }

    private List<String> getAsStringList(List<Projector.AbstractVariable> variables) {
        ArrayList<String> list = new ArrayList<String>();
        for (Projector.AbstractVariable var : variables) {
            if (!this.dependencyHelper.getBooleanValueFor((Object)var)) continue;
            list.add(var.toString().substring(18));
        }
        return list;
    }

    public static enum Criteria {
        NEW("new"),
        REMOVED("removed"),
        NOTUPTODATE("notuptodate"),
        RECOMMENDED("recommended"),
        VERSION_CHANGED("versionchanged"),
        CHANGED("changed");

        public final String label;

        private Criteria(String label) {
            this.label = label;
        }
    }
}

