/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.standalone;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.attribute.FileTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.nuxeo.common.Environment;
import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.XMap;
import org.nuxeo.common.xmap.XValueFactory;
import org.nuxeo.connect.update.LocalPackage;
import org.nuxeo.connect.update.PackageDependency;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.PackageState;
import org.nuxeo.connect.update.PackageType;
import org.nuxeo.connect.update.PackageUpdateService;
import org.nuxeo.connect.update.Version;
import org.nuxeo.connect.update.model.PackageDefinition;
import org.nuxeo.connect.update.standalone.PackagePersistence;
import org.nuxeo.connect.update.task.Command;
import org.nuxeo.connect.update.task.standalone.InstallTask;
import org.nuxeo.connect.update.task.standalone.UninstallTask;
import org.nuxeo.connect.update.task.standalone.commands.Append;
import org.nuxeo.connect.update.task.standalone.commands.Config;
import org.nuxeo.connect.update.task.standalone.commands.Copy;
import org.nuxeo.connect.update.task.standalone.commands.Delete;
import org.nuxeo.connect.update.task.standalone.commands.DeployConfigPlaceholder;
import org.nuxeo.connect.update.task.standalone.commands.DeployPlaceholder;
import org.nuxeo.connect.update.task.standalone.commands.FlushJaasCachePlaceholder;
import org.nuxeo.connect.update.task.standalone.commands.FlushPlaceholder;
import org.nuxeo.connect.update.task.standalone.commands.InstallPlaceholder;
import org.nuxeo.connect.update.task.standalone.commands.LoadJarPlaceholder;
import org.nuxeo.connect.update.task.standalone.commands.ParameterizedCopy;
import org.nuxeo.connect.update.task.standalone.commands.ReloadPropertiesPlaceholder;
import org.nuxeo.connect.update.task.standalone.commands.UnAppend;
import org.nuxeo.connect.update.task.standalone.commands.UndeployConfigPlaceholder;
import org.nuxeo.connect.update.task.standalone.commands.UndeployPlaceholder;
import org.nuxeo.connect.update.task.standalone.commands.UninstallPlaceholder;
import org.nuxeo.connect.update.task.standalone.commands.UnloadJarPlaceholder;
import org.nuxeo.connect.update.task.update.Rollback;
import org.nuxeo.connect.update.task.update.Update;
import org.nuxeo.connect.update.xml.FormsDefinition;
import org.nuxeo.connect.update.xml.PackageDefinitionImpl;

public class StandaloneUpdateService
implements PackageUpdateService {
    protected static volatile XMap xmap;
    protected PackagePersistence persistence;
    protected Map<String, Class<? extends Command>> commands;

    public static XMap getXmap() {
        return xmap;
    }

    public StandaloneUpdateService(Environment env) throws IOException {
        Environment.setDefault((Environment)env);
        this.persistence = new PackagePersistence(this);
        this.commands = new HashMap<String, Class<? extends Command>>();
    }

    public File getDataDir() {
        return this.persistence.getRoot();
    }

    public PackagePersistence getPersistence() {
        return this.persistence;
    }

    public LocalPackage addPackage(File file) throws PackageException {
        return this.persistence.addPackage(file);
    }

    public void removePackage(String id) throws PackageException {
        this.persistence.removePackage(id);
    }

    public LocalPackage getPackage(String id) throws PackageException {
        return this.persistence.getPackage(id);
    }

    public List<LocalPackage> getPackages() throws PackageException {
        return this.persistence.getPackages();
    }

    public static XMap createXmap() {
        XMap xmap = new XMap();
        xmap.setValueFactory(PackageType.class, new XValueFactory(){

            public String serialize(Context arg0, Object arg1) {
                return ((PackageType)arg1).getValue();
            }

            public Object deserialize(Context arg0, String arg1) {
                return PackageType.getByValue((String)arg1);
            }
        });
        xmap.setValueFactory(Version.class, new XValueFactory(){

            public String serialize(Context arg0, Object arg1) {
                return arg1.toString();
            }

            public Object deserialize(Context arg0, String arg1) {
                return new Version(arg1);
            }
        });
        xmap.setValueFactory(PackageDependency.class, new XValueFactory(){

            public String serialize(Context arg0, Object arg1) {
                return arg1.toString();
            }

            public Object deserialize(Context arg0, String arg1) {
                return new PackageDependency(arg1);
            }
        });
        xmap.register(PackageDefinitionImpl.class);
        xmap.register(FormsDefinition.class);
        return xmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void initialize() throws PackageException {
        if (xmap == null) {
            Class<StandaloneUpdateService> clazz = StandaloneUpdateService.class;
            // MONITORENTER : org.nuxeo.connect.update.standalone.StandaloneUpdateService.class
            if (xmap == null) {
                xmap = StandaloneUpdateService.createXmap();
            }
            // MONITOREXIT : clazz
        }
        this.addCommands();
        this.startInstalledPackages();
    }

    protected void addCommands() {
        this.addCommand("copy", Copy.class);
        this.addCommand("append", Append.class);
        this.addCommand("unappend", UnAppend.class);
        this.addCommand("pcopy", ParameterizedCopy.class);
        this.addCommand("delete", Delete.class);
        this.addCommand("install", InstallPlaceholder.class);
        this.addCommand("uninstall", UninstallPlaceholder.class);
        this.addCommand("flush-jaas", FlushJaasCachePlaceholder.class);
        this.addCommand("flush", FlushPlaceholder.class);
        this.addCommand("reload-properties", ReloadPropertiesPlaceholder.class);
        this.addCommand("deploy", DeployPlaceholder.class);
        this.addCommand("undeploy", UndeployPlaceholder.class);
        this.addCommand("deploy-config", DeployConfigPlaceholder.class);
        this.addCommand("undeploy-config", UndeployConfigPlaceholder.class);
        this.addCommand("load-jar", LoadJarPlaceholder.class);
        this.addCommand("unload-jar", UnloadJarPlaceholder.class);
        this.addCommand("config", Config.class);
        this.addCommand("update", Update.class);
        this.addCommand("rollback", Rollback.class);
    }

    @Deprecated
    public void setPackageState(LocalPackage pkg, int state) throws PackageException {
        this.persistence.updateState(pkg.getId(), state);
        pkg.setState(state);
    }

    public void setPackageState(LocalPackage pkg, PackageState state) throws PackageException {
        this.persistence.updateState(pkg.getId(), state);
        pkg.setState(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws PackageException {
        Class<StandaloneUpdateService> clazz = StandaloneUpdateService.class;
        synchronized (StandaloneUpdateService.class) {
            xmap = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public Command getCommand(String id) throws PackageException {
        Class<? extends Command> type = this.commands.get(id);
        if (type != null) {
            try {
                return type.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new PackageException("Failed to load command " + id, (Throwable)e);
            }
        }
        return null;
    }

    public String getDefaultInstallTaskType() {
        return InstallTask.class.getName();
    }

    public String getDefaultUninstallTaskType() {
        return UninstallTask.class.getName();
    }

    public void addCommand(String id, Class<? extends Command> cmd) {
        this.commands.put(id, cmd);
    }

    public void removeCommand(String id) {
        this.commands.remove(id);
    }

    public LocalPackage getActivePackage(String name) throws PackageException {
        return this.persistence.getActivePackage(name);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public PackageDefinition loadPackageFromZip(File file) throws PackageException {
        try (ZipFile zip = new ZipFile(file);){
            PackageDefinition packageDefinition;
            block13: {
                ZipEntry mfEntry = zip.getEntry("package.xml");
                InputStream mfStream = zip.getInputStream(mfEntry);
                try {
                    packageDefinition = this.loadPackage(mfStream);
                    if (mfStream == null) break block13;
                }
                catch (Throwable throwable) {
                    if (mfStream != null) {
                        try {
                            mfStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                mfStream.close();
            }
            return packageDefinition;
        }
        catch (IOException e) {
            throw new PackageException("Failed to load package definition from zip file: " + file, (Throwable)e);
        }
    }

    public PackageDefinition loadPackage(File file) throws PackageException {
        PackageDefinition packageDefinition;
        FileInputStream in = new FileInputStream(file);
        try {
            packageDefinition = this.loadPackage(in);
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new PackageException("Failed to load XML package definition from file: " + file, (Throwable)e);
            }
        }
        in.close();
        return packageDefinition;
    }

    public PackageDefinition loadPackage(InputStream in) throws PackageException {
        try {
            return (PackageDefinition)xmap.load(in);
        }
        catch (IOException e) {
            throw new PackageException("Failed to parse XML package definition", (Throwable)e);
        }
    }

    protected void startInstalledPackages() throws PackageException {
        for (Map.Entry<String, PackageState> entry : this.persistence.getStates().entrySet()) {
            if (entry.getValue() != PackageState.INSTALLED) continue;
            this.persistence.updateState(entry.getKey(), PackageState.STARTED);
        }
    }

    public void reset() throws PackageException {
        this.persistence.reset();
    }

    public void restart() throws PackageException {
        throw new UnsupportedOperationException();
    }

    public boolean isStarted(String pkgId) {
        return this.persistence.getState(pkgId) == PackageState.STARTED;
    }

    public File getRegistry() {
        return new File(this.getDataDir(), "registry.xml");
    }

    public File getBackupDir() {
        return new File(this.getDataDir(), "backup");
    }

    public FileTime getInstallDate(String id) {
        return this.getPersistence().getInstallDate(id);
    }
}

