/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.cache;

import java.util.HashMap;
import java.util.Map;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.core.cache.CacheManagement;
import org.nuxeo.runtime.model.Descriptor;

@XObject(value="cache")
public class CacheDescriptor
implements Descriptor {
    public static final long DEFAULT_TTL = 1L;
    public static final long DEFAULT_MAX_SIZE = 100L;
    public static final String OPTION_MAX_SIZE = "maxSize";
    public static final String OPTION_CONCURRENCY_LEVEL = "concurrencyLevel";
    @XNode(value="@name")
    public String name;
    @XNode(value="@remove")
    public boolean remove;
    @XNode(value="@class")
    protected Class<? extends CacheManagement> klass;
    @XNode(value="ttl")
    private Long ttl;
    @XNodeMap(value="option", key="@name", type=HashMap.class, componentType=String.class)
    public Map<String, String> options = new HashMap<String, String>();

    public String getId() {
        return this.name;
    }

    public long getTTL() {
        return this.ttl == null ? 1L : this.ttl;
    }

    public void setTTL(Long value) {
        this.ttl = value;
    }

    public Descriptor merge(Descriptor o) {
        CacheDescriptor other = (CacheDescriptor)o;
        CacheDescriptor merged = new CacheDescriptor();
        merged.name = this.name;
        merged.remove = other.remove;
        merged.ttl = other.ttl != null ? other.ttl : this.ttl;
        merged.klass = other.klass != null ? other.klass : this.klass;
        merged.options.putAll(this.options);
        merged.options.putAll(other.options);
        return merged;
    }

    public boolean doesRemove() {
        return this.remove;
    }
}

