/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.comment;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.comment.api.Annotation;
import org.nuxeo.ecm.platform.comment.api.AnnotationService;
import org.nuxeo.ecm.platform.comment.api.Comment;
import org.nuxeo.ecm.platform.comment.api.CommentManager;
import org.nuxeo.ecm.webengine.model.WebAdapter;
import org.nuxeo.ecm.webengine.model.impl.DefaultAdapter;
import org.nuxeo.runtime.api.Framework;

@WebAdapter(name="annotation", type="annotationAdapter")
@Produces(value={"application/json"})
public class AnnotationAdapter
extends DefaultAdapter {
    public static final String NAME = "annotation";

    @POST
    public Response createAnnotation(Annotation annotation) {
        DocumentModel doc = (DocumentModel)this.getTarget().getAdapter(DocumentModel.class);
        annotation.setParentId(doc.getId());
        AnnotationService annotationService = (AnnotationService)Framework.getService(AnnotationService.class);
        annotation.setAuthor(this.getContext().getCoreSession().getPrincipal().getName());
        Annotation result = annotationService.createAnnotation(this.getContext().getCoreSession(), annotation);
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)result).build();
    }

    @GET
    public List<Annotation> getAnnotations(@QueryParam(value="xpath") String xpath) {
        DocumentModel doc = (DocumentModel)this.getTarget().getAdapter(DocumentModel.class);
        AnnotationService annotationService = (AnnotationService)Framework.getService(AnnotationService.class);
        return annotationService.getAnnotations(this.getContext().getCoreSession(), doc.getId(), xpath);
    }

    @GET
    @Path(value="comments")
    public List<Comment> getComments(@QueryParam(value="annotationIds") List<String> annotationIds) {
        CommentManager commentManager = (CommentManager)Framework.getService(CommentManager.class);
        ArrayList<Comment> comments = new ArrayList<Comment>();
        for (String annotationId : annotationIds) {
            comments.addAll(this.getAllComments(annotationId, commentManager, this.getContext().getCoreSession()));
        }
        return comments;
    }

    protected List<Comment> getAllComments(String annotationId, CommentManager commentManager, CoreSession session) {
        ArrayList<Comment> allComments = new ArrayList<Comment>();
        List comments = commentManager.getComments(session, annotationId);
        for (Comment comment : comments) {
            allComments.addAll(this.getAllComments(comment.getId(), commentManager, session));
            allComments.add(comment);
        }
        return allComments;
    }

    @GET
    @Path(value="{annotationId}")
    public Annotation getAnnotation(@PathParam(value="annotationId") String annotationId) {
        AnnotationService annotationService = (AnnotationService)Framework.getService(AnnotationService.class);
        return annotationService.getAnnotation(this.getContext().getCoreSession(), annotationId);
    }

    @GET
    @Path(value="external/{entityId}")
    public Annotation getExternalAnnotation(@PathParam(value="entityId") String entityId) {
        DocumentModel doc = (DocumentModel)this.getTarget().getAdapter(DocumentModel.class);
        AnnotationService annotationService = (AnnotationService)Framework.getService(AnnotationService.class);
        return annotationService.getExternalAnnotation(this.getContext().getCoreSession(), doc.getId(), entityId);
    }

    @PUT
    @Path(value="{annotationId}")
    public Annotation updateAnnotation(@PathParam(value="annotationId") String annotationId, Annotation annotation) {
        DocumentModel doc = (DocumentModel)this.getTarget().getAdapter(DocumentModel.class);
        annotation.setParentId(doc.getId());
        AnnotationService annotationService = (AnnotationService)Framework.getService(AnnotationService.class);
        CoreSession session = this.getContext().getCoreSession();
        String author = annotationService.getAnnotation(session, annotationId).getAuthor();
        annotation.setAuthor(author);
        annotationService.updateAnnotation(session, annotationId, annotation);
        return annotation;
    }

    @PUT
    @Path(value="external/{entityId}")
    public Annotation updateExternalAnnotation(@PathParam(value="entityId") String entityId, Annotation annotation) {
        DocumentModel doc = (DocumentModel)this.getTarget().getAdapter(DocumentModel.class);
        AnnotationService annotationService = (AnnotationService)Framework.getService(AnnotationService.class);
        CoreSession session = this.getContext().getCoreSession();
        String author = annotationService.getExternalAnnotation(session, doc.getId(), entityId).getAuthor();
        annotation.setAuthor(author);
        annotationService.updateExternalAnnotation(this.getContext().getCoreSession(), doc.getId(), entityId, annotation);
        return annotation;
    }

    @DELETE
    @Path(value="{annotationId}")
    public Response deleteAnnotation(@PathParam(value="annotationId") String annotationId) {
        AnnotationService annotationService = (AnnotationService)Framework.getService(AnnotationService.class);
        annotationService.deleteAnnotation(this.getContext().getCoreSession(), annotationId);
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="external/{entityId}")
    public Response deleteExternalAnnotation(@PathParam(value="entityId") String entityId) {
        DocumentModel doc = (DocumentModel)this.getTarget().getAdapter(DocumentModel.class);
        AnnotationService annotationService = (AnnotationService)Framework.getService(AnnotationService.class);
        annotationService.deleteExternalAnnotation(this.getContext().getCoreSession(), doc.getId(), entityId);
        return Response.noContent().build();
    }
}

