/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.webdav.jaxrs.xml.elements;

import java.util.Arrays;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import net.java.dev.webdav.jaxrs.xml.elements.Error;
import net.java.dev.webdav.jaxrs.xml.elements.Prop;
import net.java.dev.webdav.jaxrs.xml.elements.ResponseDescription;
import net.java.dev.webdav.jaxrs.xml.elements.Status;
import net.java.dev.webdav.util.Utilities;

@XmlType(propOrder={"prop", "status", "error", "responseDescription"})
@XmlRootElement(name="propstat")
public final class PropStat {
    @XmlElement
    private final Prop prop;
    @XmlElement
    private final Status status;
    @XmlElement
    private final Error error;
    @XmlElement(name="responsedescription")
    private final ResponseDescription responseDescription;

    private PropStat() {
        this.prop = null;
        this.status = null;
        this.error = null;
        this.responseDescription = null;
    }

    public PropStat(Prop prop, Status status, Error error, ResponseDescription responseDescription) {
        this.prop = Utilities.notNull(prop, "prop");
        this.status = Utilities.notNull(status, "status");
        this.error = error;
        this.responseDescription = responseDescription;
    }

    public PropStat(Prop prop, Status status) {
        this(prop, status, null, null);
    }

    public PropStat(Prop prop, Status status, Error error) {
        this(prop, status, error, null);
    }

    public PropStat(Prop prop, Status status, ResponseDescription responseDescription) {
        this(prop, status, null, responseDescription);
    }

    public final Prop getProp() {
        return this.prop;
    }

    public final Status getStatus() {
        return this.status;
    }

    public final Error getError() {
        return this.error;
    }

    public final ResponseDescription getResponseDescription() {
        return this.responseDescription;
    }

    public final int hashCode() {
        return Objects.hash(this.prop, this.status, this.error, this.responseDescription);
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(this instanceof PropStat)) {
            return false;
        }
        PropStat that = (PropStat)o;
        return Arrays.equals(Utilities.array(this.prop, this.status, this.error, this.responseDescription), Utilities.array(that.prop, that.status, that.error, that.responseDescription));
    }

    public final String toString() {
        return Utilities.toString(this, this.prop, this.status, this.error, this.responseDescription);
    }
}

