/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public final class PrimitiveArrays {
    private PrimitiveArrays() {
    }

    public static Object toPrimitiveArray(Collection<Object> col, Class<?> primitiveArrayType) {
        if (primitiveArrayType == Integer.TYPE) {
            return PrimitiveArrays.toIntArray(col);
        }
        if (primitiveArrayType == Long.TYPE) {
            return PrimitiveArrays.toLongArray(col);
        }
        if (primitiveArrayType == Double.TYPE) {
            return PrimitiveArrays.toDoubleArray(col);
        }
        if (primitiveArrayType == Float.TYPE) {
            return PrimitiveArrays.toFloatArray(col);
        }
        if (primitiveArrayType == Boolean.TYPE) {
            return PrimitiveArrays.toBooleanArray(col);
        }
        if (primitiveArrayType == Byte.TYPE) {
            return PrimitiveArrays.toByteArray(col);
        }
        if (primitiveArrayType == Character.TYPE) {
            return PrimitiveArrays.toCharArray(col);
        }
        if (primitiveArrayType == Short.TYPE) {
            return PrimitiveArrays.toShortArray(col);
        }
        return null;
    }

    public static int[] toIntArray(Collection<?> col) {
        int size = col.size();
        int[] ar = new int[size];
        Iterator<?> it = col.iterator();
        int i = 0;
        while (it.hasNext()) {
            ar[i++] = (Integer)it.next();
        }
        return ar;
    }

    public static long[] toLongArray(Collection<?> col) {
        int size = col.size();
        long[] ar = new long[size];
        Iterator<?> it = col.iterator();
        int i = 0;
        while (it.hasNext()) {
            ar[i++] = (Long)it.next();
        }
        return ar;
    }

    public static double[] toDoubleArray(Collection<?> col) {
        int size = col.size();
        double[] ar = new double[size];
        Iterator<?> it = col.iterator();
        int i = 0;
        while (it.hasNext()) {
            ar[i++] = (Double)it.next();
        }
        return ar;
    }

    public static float[] toFloatArray(Collection<?> col) {
        int size = col.size();
        float[] ar = new float[size];
        Iterator<?> it = col.iterator();
        int i = 0;
        while (it.hasNext()) {
            ar[i++] = ((Float)it.next()).floatValue();
        }
        return ar;
    }

    public static boolean[] toBooleanArray(Collection<?> col) {
        int size = col.size();
        boolean[] ar = new boolean[size];
        Iterator<?> it = col.iterator();
        int i = 0;
        while (it.hasNext()) {
            ar[i++] = (Boolean)it.next();
        }
        return ar;
    }

    public static short[] toShortArray(Collection<?> col) {
        int size = col.size();
        short[] ar = new short[size];
        Iterator<?> it = col.iterator();
        int i = 0;
        while (it.hasNext()) {
            ar[i++] = (Short)it.next();
        }
        return ar;
    }

    public static byte[] toByteArray(Collection<?> col) {
        int size = col.size();
        byte[] ar = new byte[size];
        Iterator<?> it = col.iterator();
        int i = 0;
        while (it.hasNext()) {
            ar[i++] = (Byte)it.next();
        }
        return ar;
    }

    public static char[] toCharArray(Collection<?> col) {
        int size = col.size();
        char[] ar = new char[size];
        Iterator<?> it = col.iterator();
        int i = 0;
        while (it.hasNext()) {
            ar[i++] = ((Character)it.next()).charValue();
        }
        return ar;
    }

    public static Object[] toObjectArray(Object array) {
        Class<?> arrType = array.getClass().getComponentType();
        if (arrType == null) {
            throw new IllegalArgumentException("Not an array");
        }
        if (arrType.isPrimitive()) {
            if (arrType == Integer.TYPE) {
                int[] ar = (int[])array;
                Object[] result = new Integer[ar.length];
                for (int i = 0; i < ar.length; ++i) {
                    result[i] = ar[i];
                }
                return result;
            }
            if (arrType == Long.TYPE) {
                long[] ar = (long[])array;
                Object[] result = new Long[ar.length];
                for (int i = 0; i < ar.length; ++i) {
                    result[i] = ar[i];
                }
                return result;
            }
            if (arrType == Double.TYPE) {
                double[] ar = (double[])array;
                Object[] result = new Double[ar.length];
                for (int i = 0; i < ar.length; ++i) {
                    result[i] = ar[i];
                }
                return result;
            }
            if (arrType == Float.TYPE) {
                float[] ar = (float[])array;
                Object[] result = new Float[ar.length];
                for (int i = 0; i < ar.length; ++i) {
                    result[i] = Float.valueOf(ar[i]);
                }
                return result;
            }
            if (arrType == Character.TYPE) {
                char[] ar = (char[])array;
                Object[] result = new Character[ar.length];
                for (int i = 0; i < ar.length; ++i) {
                    result[i] = Character.valueOf(ar[i]);
                }
                return result;
            }
            if (arrType == Byte.TYPE) {
                byte[] ar = (byte[])array;
                Object[] result = new Byte[ar.length];
                for (int i = 0; i < ar.length; ++i) {
                    result[i] = ar[i];
                }
                return result;
            }
            if (arrType == Short.TYPE) {
                short[] ar = (short[])array;
                Object[] result = new Short[ar.length];
                for (int i = 0; i < ar.length; ++i) {
                    result[i] = ar[i];
                }
                return result;
            }
            return null;
        }
        return (Object[])array;
    }

    public static List<?> toList(Object array) {
        Class<?> arrType = array.getClass().getComponentType();
        if (arrType.isPrimitive()) {
            if (arrType == Integer.TYPE) {
                int[] ar = (int[])array;
                ArrayList<Integer> result = new ArrayList<Integer>(ar.length);
                for (int v : ar) {
                    result.add(v);
                }
                return result;
            }
            if (arrType == Long.TYPE) {
                long[] ar = (long[])array;
                ArrayList<Long> result = new ArrayList<Long>(ar.length);
                for (long v : ar) {
                    result.add(v);
                }
                return result;
            }
            if (arrType == Double.TYPE) {
                double[] ar = (double[])array;
                ArrayList<Double> result = new ArrayList<Double>(ar.length);
                for (double v : ar) {
                    result.add(v);
                }
                return result;
            }
            if (arrType == Float.TYPE) {
                float[] ar = (float[])array;
                ArrayList<Float> result = new ArrayList<Float>(ar.length);
                for (float v : ar) {
                    result.add(Float.valueOf(v));
                }
                return result;
            }
            if (arrType == Character.TYPE) {
                char[] ar = (char[])array;
                ArrayList<Character> result = new ArrayList<Character>(ar.length);
                for (char v : ar) {
                    result.add(Character.valueOf(v));
                }
                return result;
            }
            if (arrType == Byte.TYPE) {
                byte[] ar = (byte[])array;
                ArrayList<Byte> result = new ArrayList<Byte>(ar.length);
                for (byte v : ar) {
                    result.add(v);
                }
                return result;
            }
            if (arrType == Short.TYPE) {
                short[] ar = (short[])array;
                ArrayList<Short> result = new ArrayList<Short>(ar.length);
                for (short v : ar) {
                    result.add(v);
                }
                return result;
            }
            return null;
        }
        return Arrays.asList((Object[])array);
    }
}

