/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.services.workmanager;

import java.io.IOException;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.TimeoutException;
import net.jodah.failsafe.RetryPolicy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.work.WorkComputation;
import org.nuxeo.ecm.core.work.WorkHolder;
import org.nuxeo.ecm.core.work.WorkManagerImpl;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.lib.stream.computation.AbstractComputation;
import org.nuxeo.lib.stream.computation.ComputationContext;
import org.nuxeo.lib.stream.computation.ComputationPolicy;
import org.nuxeo.lib.stream.computation.ComputationPolicyBuilder;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.lib.stream.computation.Settings;
import org.nuxeo.lib.stream.computation.StreamManager;
import org.nuxeo.lib.stream.computation.StreamProcessor;
import org.nuxeo.lib.stream.computation.Topology;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.stream.StreamService;

@Operation(id="WorkManager.RunWorkInFailure", category="Services", label="Executes Works stored in the dead letter queue", addToStudio=false, description="Try to execute again Works that have been send to a dead letter queue by the WorkManager after failure")
public class WorkManagerRunWorkInFailure {
    private static final Logger log = LogManager.getLogger(WorkManagerRunWorkInFailure.class);
    public static final String ID = "WorkManager.RunWorkInFailure";
    protected static final long DEFAULT_TIMEOUT_SECONDS = 120L;
    protected static final long ASSIGNMENT_TIMEOUT_SECONDS = 60L;
    protected volatile long countTotal;
    protected volatile long countSuccess;
    @Param(name="timeoutSeconds", required=false)
    protected long timeout = 120L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OperationMethod
    public Blob run() throws IOException, InterruptedException, TimeoutException {
        StreamManager streamManager = ((StreamService)Framework.getService(StreamService.class)).getStreamManager();
        Settings settings = new Settings(1, 1, WorkManagerImpl.DEAD_LETTER_QUEUE_CODEC, this.getComputationPolicy());
        StreamProcessor processor = streamManager.registerAndCreateProcessor("RunWorkInFailure", this.getTopology(), settings);
        try {
            this.countTotal = 0L;
            this.countSuccess = 0L;
            processor.start();
            processor.waitForAssignments(Duration.ofSeconds(60L));
            if (!processor.drainAndStop(this.getTimeout())) {
                throw new TimeoutException();
            }
        }
        finally {
            processor.shutdown();
        }
        return this.buildResult();
    }

    private Blob buildResult() throws IOException {
        HashMap<String, Long> result = new HashMap<String, Long>();
        result.put("total", this.countTotal);
        result.put("success", this.countSuccess);
        return Blobs.createJSONBlobFromValue(result);
    }

    protected Duration getTimeout() {
        return Duration.ofSeconds(this.timeout);
    }

    protected ComputationPolicy getComputationPolicy() {
        return new ComputationPolicyBuilder().retryPolicy(new RetryPolicy(ComputationPolicy.NO_RETRY)).continueOnFailure(true).build();
    }

    protected Topology getTopology() {
        return Topology.builder().addComputation(() -> new WorkFailureComputation(), Collections.singletonList("i1:" + WorkManagerImpl.DEAD_LETTER_QUEUE.getUrn())).build();
    }

    protected class WorkFailureComputation
    extends AbstractComputation {
        private static final String NAME = "WorkFailure";

        public WorkFailureComputation() {
            super(NAME, 1, 0);
        }

        public void processRecord(ComputationContext context, String inputStreamName, Record record) {
            context.askForCheckpoint();
            Work work = WorkComputation.deserialize((byte[])record.getData());
            log.info("Trying to run Work from DLQ: " + work.getCategory() + ":" + work.getId());
            try {
                work.setWorkInstanceState(Work.State.UNKNOWN);
                new WorkHolder(work).run();
                this.cleanup(work, null);
                log.info(work.getId() + ": Success.");
                ++WorkManagerRunWorkInFailure.this.countSuccess;
            }
            catch (Exception e) {
                this.cleanup(work, e);
                log.error(work.getId() + ": Failure, skipping.", (Throwable)e);
            }
            ++WorkManagerRunWorkInFailure.this.countTotal;
        }

        protected void cleanup(Work work, Exception exception) {
            try {
                work.cleanUp(true, exception);
            }
            catch (Exception e) {
                log.error(work.getId() + ": Failure on cleanup", (Throwable)e);
            }
        }
    }
}

