/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.bulk.action.computation;

import com.google.code.externalsorting.ExternalSort;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.bulk.BulkCodecs;
import org.nuxeo.ecm.core.bulk.BulkService;
import org.nuxeo.ecm.core.bulk.action.computation.AbstractTransientBlobComputation;
import org.nuxeo.ecm.core.bulk.message.BulkCommand;
import org.nuxeo.ecm.core.bulk.message.BulkStatus;
import org.nuxeo.ecm.core.bulk.message.DataBucket;
import org.nuxeo.lib.stream.codec.Codec;
import org.nuxeo.lib.stream.computation.ComputationContext;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.runtime.api.Framework;

public class SortBlob
extends AbstractTransientBlobComputation {
    private static final Logger log = LogManager.getLogger(SortBlob.class);
    public static final String NAME = "bulk/sortBlob";
    public static final String SORT_PARAMETER = "sort";
    protected static final String ZIP_STREAM = "o1";
    protected static final String EXPOSE_BLOB_STREAM = "o2";
    protected static final int NB_OUTPUT_STREAMS = 2;

    public SortBlob() {
        super(NAME, 2);
    }

    public void processRecord(ComputationContext context, String inputStreamName, Record record) {
        Codec<DataBucket> codec = BulkCodecs.getDataBucketCodec();
        DataBucket in = (DataBucket)codec.decode(record.getData());
        String commandId = in.getCommandId();
        String storeName = ((BulkStatus)((BulkService)Framework.getService(BulkService.class)).getStatus((Serializable)((Object)commandId))).getAction();
        Blob tmpBlob = this.getBlob(in.getDataAsString(), storeName);
        tmpBlob = this.sort(tmpBlob, commandId);
        Path path = this.createTemp(commandId);
        try (InputStream is = tmpBlob.getStream();
             FileOutputStream os = new FileOutputStream(path.toFile(), true);){
            os.write(in.getHeader());
            IOUtils.copy((InputStream)is, (OutputStream)os);
            os.write(in.getFooter());
            os.flush();
        }
        catch (IOException e) {
            log.error("Unable to copy header/footer", (Throwable)e);
        }
        try {
            Files.delete(tmpBlob.getFile().toPath());
        }
        catch (IOException e) {
            log.error("Unable to delete tmp file", (Throwable)e);
        }
        this.storeBlob((Blob)new FileBlob(path.toFile()), commandId, storeName);
        BulkCommand command = ((BulkService)Framework.getService(BulkService.class)).getCommand(commandId);
        boolean zip = command.getParam("zip") != null ? (Boolean)command.getParam("zip") : false;
        String outputStream = zip ? ZIP_STREAM : EXPOSE_BLOB_STREAM;
        DataBucket out = new DataBucket(commandId, in.getCount(), this.getTransientStoreKey(commandId));
        context.produceRecord(outputStream, Record.of((String)commandId, (byte[])codec.encode((Object)out)));
        context.askForCheckpoint();
    }

    protected Blob sort(Blob blob, String commandId) {
        try {
            Path temp = this.createTemp("tmp" + commandId);
            ExternalSort.sort((File)blob.getFile(), (File)temp.toFile());
            return new FileBlob(temp.toFile());
        }
        catch (IOException e) {
            log.error("Unable to sort blob", (Throwable)e);
            return blob;
        }
    }
}

