/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.bulk.io;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.nuxeo.ecm.core.bulk.message.BulkStatus;
import org.nuxeo.ecm.core.io.marshallers.json.ExtensibleEntityJsonWriter;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class BulkStatusJsonWriter
extends ExtensibleEntityJsonWriter<BulkStatus> {
    public BulkStatusJsonWriter() {
        super("bulkStatus", BulkStatus.class);
    }

    public void writeEntityBody(BulkStatus entity, JsonGenerator jg) throws IOException {
        jg.writeStringField("commandId", entity.getId());
        jg.writeStringField("state", entity.getState() != null ? entity.getState().toString() : null);
        jg.writeNumberField("processed", entity.getProcessed());
        jg.writeBooleanField("error", entity.hasError());
        jg.writeNumberField("errorCount", entity.getErrorCount());
        if (entity.getErrorMessage() != null) {
            jg.writeStringField("errorMessage", entity.getErrorMessage());
        }
        jg.writeNumberField("total", entity.getTotal());
        jg.writeStringField("action", entity.getAction());
        jg.writeStringField("username", entity.getUsername());
        jg.writeStringField("submitted", entity.getSubmitTime() != null ? entity.getSubmitTime().toString() : null);
        jg.writeStringField("scrollStart", entity.getScrollStartTime() != null ? entity.getScrollStartTime().toString() : null);
        jg.writeStringField("scrollEnd", entity.getScrollEndTime() != null ? entity.getScrollEndTime().toString() : null);
        jg.writeStringField("processingStart", entity.getProcessingStartTime() != null ? entity.getProcessingStartTime().toString() : null);
        jg.writeStringField("processingEnd", entity.getProcessingEndTime() != null ? entity.getProcessingEndTime().toString() : null);
        jg.writeStringField("completed", entity.getCompletedTime() != null ? entity.getCompletedTime().toString() : null);
        jg.writeNumberField("processingMillis", entity.getProcessingDurationMillis());
        Map<String, Serializable> result = entity.getResult();
        if (!result.isEmpty()) {
            jg.writeObjectField("result", result);
        }
    }
}

