/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.relations.jena;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.platform.relations.CoreGraphFactory;
import org.nuxeo.ecm.platform.relations.api.Graph;
import org.nuxeo.ecm.platform.relations.api.GraphDescription;
import org.nuxeo.ecm.platform.relations.api.GraphFactory;
import org.nuxeo.ecm.platform.relations.api.RelationManager;
import org.nuxeo.ecm.platform.relations.jena.JenaGraph;
import org.nuxeo.ecm.platform.relations.services.RelationService;
import org.nuxeo.runtime.api.Framework;

public class JenaOrCoreGraphFactory
implements GraphFactory {
    private static final Log log = LogFactory.getLog(JenaOrCoreGraphFactory.class);
    protected static JenaGraph testJenaGraph;

    public Graph createGraph(GraphDescription graphDescription, CoreSession session) {
        RelationService service = (RelationService)Framework.getService(RelationManager.class);
        String name = graphDescription.getName();
        JenaGraph graph = testJenaGraph == null ? new JenaGraph() : testJenaGraph;
        graph.setDescription(graphDescription);
        if (graph.size() > 0L) {
            service.graphFactories.remove(name);
            service.graphRegistry.put(name, graph);
            log.info((Object)("Graph " + name + " using Jena"));
        } else {
            CoreGraphFactory factory = new CoreGraphFactory();
            service.graphFactories.put(name, factory);
            graph = factory.createGraph(graphDescription, session);
            log.info((Object)("Graph " + name + " using Core"));
        }
        return graph;
    }
}

