/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import org.h2.engine.Constants;
import org.h2.engine.SysProperties;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.Trace;
import org.h2.message.TraceObject;
import org.h2.tools.SimpleResultSet;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;

public class JdbcDatabaseMetaData
extends TraceObject
implements DatabaseMetaData {
    private final JdbcConnection conn;
    private String mode;

    JdbcDatabaseMetaData(JdbcConnection jdbcConnection, Trace trace, int n) {
        this.setTrace(trace, 2, n);
        this.conn = jdbcConnection;
    }

    @Override
    public int getDriverMajorVersion() {
        this.debugCodeCall("getDriverMajorVersion");
        return 1;
    }

    @Override
    public int getDriverMinorVersion() {
        this.debugCodeCall("getDriverMinorVersion");
        return 4;
    }

    @Override
    public String getDatabaseProductName() {
        this.debugCodeCall("getDatabaseProductName");
        return "H2";
    }

    @Override
    public String getDatabaseProductVersion() {
        this.debugCodeCall("getDatabaseProductVersion");
        return Constants.getFullVersion();
    }

    @Override
    public String getDriverName() {
        this.debugCodeCall("getDriverName");
        return "H2 JDBC Driver";
    }

    @Override
    public String getDriverVersion() {
        this.debugCodeCall("getDriverVersion");
        return Constants.getFullVersion();
    }

    @Override
    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        try {
            String string4;
            int n;
            Object object;
            if (this.isDebugEnabled()) {
                this.debugCode("getTables(" + JdbcDatabaseMetaData.quote(string) + ", " + JdbcDatabaseMetaData.quote(string2) + ", " + JdbcDatabaseMetaData.quote(string3) + ", " + JdbcDatabaseMetaData.quoteArray(stringArray) + ");");
            }
            this.checkClosed();
            if (stringArray != null && stringArray.length > 0) {
                object = new StatementBuilder("TABLE_TYPE IN(");
                for (n = 0; n < stringArray.length; ++n) {
                    ((StatementBuilder)object).appendExceptFirst(", ");
                    ((StatementBuilder)object).append('?');
                }
                string4 = ((StatementBuilder)object).append(')').toString();
            } else {
                string4 = "TRUE";
            }
            object = this.conn.prepareAutoCloseStatement("SELECT TABLE_CATALOG TABLE_CAT, TABLE_SCHEMA TABLE_SCHEM, TABLE_NAME, TABLE_TYPE, REMARKS, TYPE_NAME TYPE_CAT, TYPE_NAME TYPE_SCHEM, TYPE_NAME, TYPE_NAME SELF_REFERENCING_COL_NAME, TYPE_NAME REF_GENERATION, SQL FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_CATALOG LIKE ? ESCAPE ? AND TABLE_SCHEMA LIKE ? ESCAPE ? AND TABLE_NAME LIKE ? ESCAPE ? AND (" + string4 + ") " + "ORDER BY TABLE_TYPE, TABLE_SCHEMA, TABLE_NAME");
            object.setString(1, JdbcDatabaseMetaData.getCatalogPattern(string));
            object.setString(2, "\\");
            object.setString(3, JdbcDatabaseMetaData.getSchemaPattern(string2));
            object.setString(4, "\\");
            object.setString(5, JdbcDatabaseMetaData.getPattern(string3));
            object.setString(6, "\\");
            for (n = 0; stringArray != null && n < stringArray.length; ++n) {
                object.setString(7 + n, stringArray[n]);
            }
            return object.executeQuery();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getColumns(" + JdbcDatabaseMetaData.quote(string) + ", " + JdbcDatabaseMetaData.quote(string2) + ", " + JdbcDatabaseMetaData.quote(string3) + ", " + JdbcDatabaseMetaData.quote(string4) + ");");
            }
            this.checkClosed();
            PreparedStatement preparedStatement = this.conn.prepareAutoCloseStatement("SELECT TABLE_CATALOG TABLE_CAT, TABLE_SCHEMA TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, DATA_TYPE, TYPE_NAME, CHARACTER_MAXIMUM_LENGTH COLUMN_SIZE, CHARACTER_MAXIMUM_LENGTH BUFFER_LENGTH, NUMERIC_SCALE DECIMAL_DIGITS, NUMERIC_PRECISION_RADIX NUM_PREC_RADIX, NULLABLE, REMARKS, COLUMN_DEFAULT COLUMN_DEF, DATA_TYPE SQL_DATA_TYPE, ZERO() SQL_DATETIME_SUB, CHARACTER_OCTET_LENGTH CHAR_OCTET_LENGTH, ORDINAL_POSITION, IS_NULLABLE IS_NULLABLE, CAST(SOURCE_DATA_TYPE AS VARCHAR) SCOPE_CATALOG, CAST(SOURCE_DATA_TYPE AS VARCHAR) SCOPE_SCHEMA, CAST(SOURCE_DATA_TYPE AS VARCHAR) SCOPE_TABLE, SOURCE_DATA_TYPE, CASE WHEN SEQUENCE_NAME IS NULL THEN CAST(? AS VARCHAR) ELSE CAST(? AS VARCHAR) END IS_AUTOINCREMENT, CAST(SOURCE_DATA_TYPE AS VARCHAR) SCOPE_CATLOG FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_CATALOG LIKE ? ESCAPE ? AND TABLE_SCHEMA LIKE ? ESCAPE ? AND TABLE_NAME LIKE ? ESCAPE ? AND COLUMN_NAME LIKE ? ESCAPE ? ORDER BY TABLE_SCHEM, TABLE_NAME, ORDINAL_POSITION");
            preparedStatement.setString(1, "NO");
            preparedStatement.setString(2, "YES");
            preparedStatement.setString(3, JdbcDatabaseMetaData.getCatalogPattern(string));
            preparedStatement.setString(4, "\\");
            preparedStatement.setString(5, JdbcDatabaseMetaData.getSchemaPattern(string2));
            preparedStatement.setString(6, "\\");
            preparedStatement.setString(7, JdbcDatabaseMetaData.getPattern(string3));
            preparedStatement.setString(8, "\\");
            preparedStatement.setString(9, JdbcDatabaseMetaData.getPattern(string4));
            preparedStatement.setString(10, "\\");
            return preparedStatement.executeQuery();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getIndexInfo(" + JdbcDatabaseMetaData.quote(string) + ", " + JdbcDatabaseMetaData.quote(string2) + ", " + JdbcDatabaseMetaData.quote(string3) + ", " + bl + ", " + bl2 + ");");
            }
            String string4 = bl ? "NON_UNIQUE=FALSE" : "TRUE";
            this.checkClosed();
            PreparedStatement preparedStatement = this.conn.prepareAutoCloseStatement("SELECT TABLE_CATALOG TABLE_CAT, TABLE_SCHEMA TABLE_SCHEM, TABLE_NAME, NON_UNIQUE, TABLE_CATALOG INDEX_QUALIFIER, INDEX_NAME, INDEX_TYPE TYPE, ORDINAL_POSITION, COLUMN_NAME, ASC_OR_DESC, CARDINALITY, PAGES, FILTER_CONDITION, SORT_TYPE FROM INFORMATION_SCHEMA.INDEXES WHERE TABLE_CATALOG LIKE ? ESCAPE ? AND TABLE_SCHEMA LIKE ? ESCAPE ? AND (" + string4 + ") " + "AND TABLE_NAME = ? " + "ORDER BY NON_UNIQUE, TYPE, TABLE_SCHEM, INDEX_NAME, ORDINAL_POSITION");
            preparedStatement.setString(1, JdbcDatabaseMetaData.getCatalogPattern(string));
            preparedStatement.setString(2, "\\");
            preparedStatement.setString(3, JdbcDatabaseMetaData.getSchemaPattern(string2));
            preparedStatement.setString(4, "\\");
            preparedStatement.setString(5, string3);
            return preparedStatement.executeQuery();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getPrimaryKeys(" + JdbcDatabaseMetaData.quote(string) + ", " + JdbcDatabaseMetaData.quote(string2) + ", " + JdbcDatabaseMetaData.quote(string3) + ");");
            }
            this.checkClosed();
            PreparedStatement preparedStatement = this.conn.prepareAutoCloseStatement("SELECT TABLE_CATALOG TABLE_CAT, TABLE_SCHEMA TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, ORDINAL_POSITION KEY_SEQ, IFNULL(CONSTRAINT_NAME, INDEX_NAME) PK_NAME FROM INFORMATION_SCHEMA.INDEXES WHERE TABLE_CATALOG LIKE ? ESCAPE ? AND TABLE_SCHEMA LIKE ? ESCAPE ? AND TABLE_NAME = ? AND PRIMARY_KEY = TRUE ORDER BY COLUMN_NAME");
            preparedStatement.setString(1, JdbcDatabaseMetaData.getCatalogPattern(string));
            preparedStatement.setString(2, "\\");
            preparedStatement.setString(3, JdbcDatabaseMetaData.getSchemaPattern(string2));
            preparedStatement.setString(4, "\\");
            preparedStatement.setString(5, string3);
            return preparedStatement.executeQuery();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean allProceduresAreCallable() {
        this.debugCodeCall("allProceduresAreCallable");
        return true;
    }

    @Override
    public boolean allTablesAreSelectable() {
        this.debugCodeCall("allTablesAreSelectable");
        return true;
    }

    @Override
    public String getURL() throws SQLException {
        try {
            this.debugCodeCall("getURL");
            return this.conn.getURL();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public String getUserName() throws SQLException {
        try {
            this.debugCodeCall("getUserName");
            return this.conn.getUser();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        try {
            this.debugCodeCall("isReadOnly");
            return this.conn.isReadOnly();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean nullsAreSortedHigh() {
        this.debugCodeCall("nullsAreSortedHigh");
        return SysProperties.SORT_NULLS_HIGH;
    }

    @Override
    public boolean nullsAreSortedLow() {
        this.debugCodeCall("nullsAreSortedLow");
        return !SysProperties.SORT_NULLS_HIGH;
    }

    @Override
    public boolean nullsAreSortedAtStart() {
        this.debugCodeCall("nullsAreSortedAtStart");
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() {
        this.debugCodeCall("nullsAreSortedAtEnd");
        return false;
    }

    @Override
    public Connection getConnection() {
        this.debugCodeCall("getConnection");
        return this.conn;
    }

    @Override
    public ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getProcedures(" + JdbcDatabaseMetaData.quote(string) + ", " + JdbcDatabaseMetaData.quote(string2) + ", " + JdbcDatabaseMetaData.quote(string3) + ");");
            }
            this.checkClosed();
            PreparedStatement preparedStatement = this.conn.prepareAutoCloseStatement("SELECT ALIAS_CATALOG PROCEDURE_CAT, ALIAS_SCHEMA PROCEDURE_SCHEM, ALIAS_NAME PROCEDURE_NAME, COLUMN_COUNT NUM_INPUT_PARAMS, ZERO() NUM_OUTPUT_PARAMS, ZERO() NUM_RESULT_SETS, REMARKS, RETURNS_RESULT PROCEDURE_TYPE, ALIAS_NAME SPECIFIC_NAME FROM INFORMATION_SCHEMA.FUNCTION_ALIASES WHERE ALIAS_CATALOG LIKE ? ESCAPE ? AND ALIAS_SCHEMA LIKE ? ESCAPE ? AND ALIAS_NAME LIKE ? ESCAPE ? ORDER BY PROCEDURE_SCHEM, PROCEDURE_NAME, NUM_INPUT_PARAMS");
            preparedStatement.setString(1, JdbcDatabaseMetaData.getCatalogPattern(string));
            preparedStatement.setString(2, "\\");
            preparedStatement.setString(3, JdbcDatabaseMetaData.getSchemaPattern(string2));
            preparedStatement.setString(4, "\\");
            preparedStatement.setString(5, JdbcDatabaseMetaData.getPattern(string3));
            preparedStatement.setString(6, "\\");
            return preparedStatement.executeQuery();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getProcedureColumns(" + JdbcDatabaseMetaData.quote(string) + ", " + JdbcDatabaseMetaData.quote(string2) + ", " + JdbcDatabaseMetaData.quote(string3) + ", " + JdbcDatabaseMetaData.quote(string4) + ");");
            }
            this.checkClosed();
            PreparedStatement preparedStatement = this.conn.prepareAutoCloseStatement("SELECT ALIAS_CATALOG PROCEDURE_CAT, ALIAS_SCHEMA PROCEDURE_SCHEM, ALIAS_NAME PROCEDURE_NAME, COLUMN_NAME, COLUMN_TYPE, DATA_TYPE, TYPE_NAME, PRECISION, PRECISION LENGTH, SCALE, RADIX, NULLABLE, REMARKS, COLUMN_DEFAULT COLUMN_DEF, ZERO() SQL_DATA_TYPE, ZERO() SQL_DATETIME_SUB, ZERO() CHAR_OCTET_LENGTH, POS ORDINAL_POSITION, ? IS_NULLABLE, ALIAS_NAME SPECIFIC_NAME FROM INFORMATION_SCHEMA.FUNCTION_COLUMNS WHERE ALIAS_CATALOG LIKE ? ESCAPE ? AND ALIAS_SCHEMA LIKE ? ESCAPE ? AND ALIAS_NAME LIKE ? ESCAPE ? AND COLUMN_NAME LIKE ? ESCAPE ? ORDER BY PROCEDURE_SCHEM, PROCEDURE_NAME, ORDINAL_POSITION");
            preparedStatement.setString(1, "YES");
            preparedStatement.setString(2, JdbcDatabaseMetaData.getCatalogPattern(string));
            preparedStatement.setString(3, "\\");
            preparedStatement.setString(4, JdbcDatabaseMetaData.getSchemaPattern(string2));
            preparedStatement.setString(5, "\\");
            preparedStatement.setString(6, JdbcDatabaseMetaData.getPattern(string3));
            preparedStatement.setString(7, "\\");
            preparedStatement.setString(8, JdbcDatabaseMetaData.getPattern(string4));
            preparedStatement.setString(9, "\\");
            return preparedStatement.executeQuery();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        try {
            this.debugCodeCall("getSchemas");
            this.checkClosed();
            PreparedStatement preparedStatement = this.conn.prepareAutoCloseStatement("SELECT SCHEMA_NAME TABLE_SCHEM, CATALOG_NAME TABLE_CATALOG,  IS_DEFAULT FROM INFORMATION_SCHEMA.SCHEMATA ORDER BY SCHEMA_NAME");
            return preparedStatement.executeQuery();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        try {
            this.debugCodeCall("getCatalogs");
            this.checkClosed();
            PreparedStatement preparedStatement = this.conn.prepareAutoCloseStatement("SELECT CATALOG_NAME TABLE_CAT FROM INFORMATION_SCHEMA.CATALOGS");
            return preparedStatement.executeQuery();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        try {
            this.debugCodeCall("getTableTypes");
            this.checkClosed();
            PreparedStatement preparedStatement = this.conn.prepareAutoCloseStatement("SELECT TYPE TABLE_TYPE FROM INFORMATION_SCHEMA.TABLE_TYPES ORDER BY TABLE_TYPE");
            return preparedStatement.executeQuery();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getColumnPrivileges(" + JdbcDatabaseMetaData.quote(string) + ", " + JdbcDatabaseMetaData.quote(string2) + ", " + JdbcDatabaseMetaData.quote(string3) + ", " + JdbcDatabaseMetaData.quote(string4) + ");");
            }
            this.checkClosed();
            PreparedStatement preparedStatement = this.conn.prepareAutoCloseStatement("SELECT TABLE_CATALOG TABLE_CAT, TABLE_SCHEMA TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, GRANTOR, GRANTEE, PRIVILEGE_TYPE PRIVILEGE, IS_GRANTABLE FROM INFORMATION_SCHEMA.COLUMN_PRIVILEGES WHERE TABLE_CATALOG LIKE ? ESCAPE ? AND TABLE_SCHEMA LIKE ? ESCAPE ? AND TABLE_NAME = ? AND COLUMN_NAME LIKE ? ESCAPE ? ORDER BY COLUMN_NAME, PRIVILEGE");
            preparedStatement.setString(1, JdbcDatabaseMetaData.getCatalogPattern(string));
            preparedStatement.setString(2, "\\");
            preparedStatement.setString(3, JdbcDatabaseMetaData.getSchemaPattern(string2));
            preparedStatement.setString(4, "\\");
            preparedStatement.setString(5, string3);
            preparedStatement.setString(6, JdbcDatabaseMetaData.getPattern(string4));
            preparedStatement.setString(7, "\\");
            return preparedStatement.executeQuery();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getTablePrivileges(" + JdbcDatabaseMetaData.quote(string) + ", " + JdbcDatabaseMetaData.quote(string2) + ", " + JdbcDatabaseMetaData.quote(string3) + ");");
            }
            this.checkClosed();
            PreparedStatement preparedStatement = this.conn.prepareAutoCloseStatement("SELECT TABLE_CATALOG TABLE_CAT, TABLE_SCHEMA TABLE_SCHEM, TABLE_NAME, GRANTOR, GRANTEE, PRIVILEGE_TYPE PRIVILEGE, IS_GRANTABLE FROM INFORMATION_SCHEMA.TABLE_PRIVILEGES WHERE TABLE_CATALOG LIKE ? ESCAPE ? AND TABLE_SCHEMA LIKE ? ESCAPE ? AND TABLE_NAME LIKE ? ESCAPE ? ORDER BY TABLE_SCHEM, TABLE_NAME, PRIVILEGE");
            preparedStatement.setString(1, JdbcDatabaseMetaData.getCatalogPattern(string));
            preparedStatement.setString(2, "\\");
            preparedStatement.setString(3, JdbcDatabaseMetaData.getSchemaPattern(string2));
            preparedStatement.setString(4, "\\");
            preparedStatement.setString(5, JdbcDatabaseMetaData.getPattern(string3));
            preparedStatement.setString(6, "\\");
            return preparedStatement.executeQuery();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getBestRowIdentifier(" + JdbcDatabaseMetaData.quote(string) + ", " + JdbcDatabaseMetaData.quote(string2) + ", " + JdbcDatabaseMetaData.quote(string3) + ", " + n + ", " + bl + ");");
            }
            this.checkClosed();
            PreparedStatement preparedStatement = this.conn.prepareAutoCloseStatement("SELECT CAST(? AS SMALLINT) SCOPE, C.COLUMN_NAME, C.DATA_TYPE, C.TYPE_NAME, C.CHARACTER_MAXIMUM_LENGTH COLUMN_SIZE, C.CHARACTER_MAXIMUM_LENGTH BUFFER_LENGTH, CAST(C.NUMERIC_SCALE AS SMALLINT) DECIMAL_DIGITS, CAST(? AS SMALLINT) PSEUDO_COLUMN FROM INFORMATION_SCHEMA.INDEXES I,  INFORMATION_SCHEMA.COLUMNS C WHERE C.TABLE_NAME = I.TABLE_NAME AND C.COLUMN_NAME = I.COLUMN_NAME AND C.TABLE_CATALOG LIKE ? ESCAPE ? AND C.TABLE_SCHEMA LIKE ? ESCAPE ? AND C.TABLE_NAME = ? AND I.PRIMARY_KEY = TRUE ORDER BY SCOPE");
            preparedStatement.setInt(1, 2);
            preparedStatement.setInt(2, 1);
            preparedStatement.setString(3, JdbcDatabaseMetaData.getCatalogPattern(string));
            preparedStatement.setString(4, "\\");
            preparedStatement.setString(5, JdbcDatabaseMetaData.getSchemaPattern(string2));
            preparedStatement.setString(6, "\\");
            preparedStatement.setString(7, string3);
            return preparedStatement.executeQuery();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getVersionColumns(" + JdbcDatabaseMetaData.quote(string) + ", " + JdbcDatabaseMetaData.quote(string2) + ", " + JdbcDatabaseMetaData.quote(string3) + ");");
            }
            this.checkClosed();
            PreparedStatement preparedStatement = this.conn.prepareAutoCloseStatement("SELECT ZERO() SCOPE, COLUMN_NAME, CAST(DATA_TYPE AS INT) DATA_TYPE, TYPE_NAME, NUMERIC_PRECISION COLUMN_SIZE, NUMERIC_PRECISION BUFFER_LENGTH, NUMERIC_PRECISION DECIMAL_DIGITS, ZERO() PSEUDO_COLUMN FROM INFORMATION_SCHEMA.COLUMNS WHERE FALSE");
            return preparedStatement.executeQuery();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getImportedKeys(" + JdbcDatabaseMetaData.quote(string) + ", " + JdbcDatabaseMetaData.quote(string2) + ", " + JdbcDatabaseMetaData.quote(string3) + ");");
            }
            this.checkClosed();
            PreparedStatement preparedStatement = this.conn.prepareAutoCloseStatement("SELECT PKTABLE_CATALOG PKTABLE_CAT, PKTABLE_SCHEMA PKTABLE_SCHEM, PKTABLE_NAME PKTABLE_NAME, PKCOLUMN_NAME, FKTABLE_CATALOG FKTABLE_CAT, FKTABLE_SCHEMA FKTABLE_SCHEM, FKTABLE_NAME, FKCOLUMN_NAME, ORDINAL_POSITION KEY_SEQ, UPDATE_RULE, DELETE_RULE, FK_NAME, PK_NAME, DEFERRABILITY FROM INFORMATION_SCHEMA.CROSS_REFERENCES WHERE FKTABLE_CATALOG LIKE ? ESCAPE ? AND FKTABLE_SCHEMA LIKE ? ESCAPE ? AND FKTABLE_NAME = ? ORDER BY PKTABLE_CAT, PKTABLE_SCHEM, PKTABLE_NAME, FK_NAME, KEY_SEQ");
            preparedStatement.setString(1, JdbcDatabaseMetaData.getCatalogPattern(string));
            preparedStatement.setString(2, "\\");
            preparedStatement.setString(3, JdbcDatabaseMetaData.getSchemaPattern(string2));
            preparedStatement.setString(4, "\\");
            preparedStatement.setString(5, string3);
            return preparedStatement.executeQuery();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getExportedKeys(" + JdbcDatabaseMetaData.quote(string) + ", " + JdbcDatabaseMetaData.quote(string2) + ", " + JdbcDatabaseMetaData.quote(string3) + ");");
            }
            this.checkClosed();
            PreparedStatement preparedStatement = this.conn.prepareAutoCloseStatement("SELECT PKTABLE_CATALOG PKTABLE_CAT, PKTABLE_SCHEMA PKTABLE_SCHEM, PKTABLE_NAME PKTABLE_NAME, PKCOLUMN_NAME, FKTABLE_CATALOG FKTABLE_CAT, FKTABLE_SCHEMA FKTABLE_SCHEM, FKTABLE_NAME, FKCOLUMN_NAME, ORDINAL_POSITION KEY_SEQ, UPDATE_RULE, DELETE_RULE, FK_NAME, PK_NAME, DEFERRABILITY FROM INFORMATION_SCHEMA.CROSS_REFERENCES WHERE PKTABLE_CATALOG LIKE ? ESCAPE ? AND PKTABLE_SCHEMA LIKE ? ESCAPE ? AND PKTABLE_NAME = ? ORDER BY FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, FK_NAME, KEY_SEQ");
            preparedStatement.setString(1, JdbcDatabaseMetaData.getCatalogPattern(string));
            preparedStatement.setString(2, "\\");
            preparedStatement.setString(3, JdbcDatabaseMetaData.getSchemaPattern(string2));
            preparedStatement.setString(4, "\\");
            preparedStatement.setString(5, string3);
            return preparedStatement.executeQuery();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getCrossReference(" + JdbcDatabaseMetaData.quote(string) + ", " + JdbcDatabaseMetaData.quote(string2) + ", " + JdbcDatabaseMetaData.quote(string3) + ", " + JdbcDatabaseMetaData.quote(string4) + ", " + JdbcDatabaseMetaData.quote(string5) + ", " + JdbcDatabaseMetaData.quote(string6) + ");");
            }
            this.checkClosed();
            PreparedStatement preparedStatement = this.conn.prepareAutoCloseStatement("SELECT PKTABLE_CATALOG PKTABLE_CAT, PKTABLE_SCHEMA PKTABLE_SCHEM, PKTABLE_NAME PKTABLE_NAME, PKCOLUMN_NAME, FKTABLE_CATALOG FKTABLE_CAT, FKTABLE_SCHEMA FKTABLE_SCHEM, FKTABLE_NAME, FKCOLUMN_NAME, ORDINAL_POSITION KEY_SEQ, UPDATE_RULE, DELETE_RULE, FK_NAME, PK_NAME, DEFERRABILITY FROM INFORMATION_SCHEMA.CROSS_REFERENCES WHERE PKTABLE_CATALOG LIKE ? ESCAPE ? AND PKTABLE_SCHEMA LIKE ? ESCAPE ? AND PKTABLE_NAME = ? AND FKTABLE_CATALOG LIKE ? ESCAPE ? AND FKTABLE_SCHEMA LIKE ? ESCAPE ? AND FKTABLE_NAME = ? ORDER BY FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, FK_NAME, KEY_SEQ");
            preparedStatement.setString(1, JdbcDatabaseMetaData.getCatalogPattern(string));
            preparedStatement.setString(2, "\\");
            preparedStatement.setString(3, JdbcDatabaseMetaData.getSchemaPattern(string2));
            preparedStatement.setString(4, "\\");
            preparedStatement.setString(5, string3);
            preparedStatement.setString(6, JdbcDatabaseMetaData.getCatalogPattern(string4));
            preparedStatement.setString(7, "\\");
            preparedStatement.setString(8, JdbcDatabaseMetaData.getSchemaPattern(string5));
            preparedStatement.setString(9, "\\");
            preparedStatement.setString(10, string6);
            return preparedStatement.executeQuery();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getUDTs(" + JdbcDatabaseMetaData.quote(string) + ", " + JdbcDatabaseMetaData.quote(string2) + ", " + JdbcDatabaseMetaData.quote(string3) + ", " + JdbcDatabaseMetaData.quoteIntArray(nArray) + ");");
            }
            this.checkClosed();
            PreparedStatement preparedStatement = this.conn.prepareAutoCloseStatement("SELECT CAST(NULL AS VARCHAR) TYPE_CAT, CAST(NULL AS VARCHAR) TYPE_SCHEM, CAST(NULL AS VARCHAR) TYPE_NAME, CAST(NULL AS VARCHAR) CLASS_NAME, CAST(NULL AS SMALLINT) DATA_TYPE, CAST(NULL AS VARCHAR) REMARKS, CAST(NULL AS SMALLINT) BASE_TYPE FROM DUAL WHERE FALSE");
            return preparedStatement.executeQuery();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        try {
            this.debugCodeCall("getTypeInfo");
            this.checkClosed();
            PreparedStatement preparedStatement = this.conn.prepareAutoCloseStatement("SELECT TYPE_NAME, DATA_TYPE, PRECISION, PREFIX LITERAL_PREFIX, SUFFIX LITERAL_SUFFIX, PARAMS CREATE_PARAMS, NULLABLE, CASE_SENSITIVE, SEARCHABLE, FALSE UNSIGNED_ATTRIBUTE, FALSE FIXED_PREC_SCALE, AUTO_INCREMENT, TYPE_NAME LOCAL_TYPE_NAME, MINIMUM_SCALE, MAXIMUM_SCALE, DATA_TYPE SQL_DATA_TYPE, ZERO() SQL_DATETIME_SUB, RADIX NUM_PREC_RADIX FROM INFORMATION_SCHEMA.TYPE_INFO ORDER BY DATA_TYPE, POS");
            ResultSet resultSet = preparedStatement.executeQuery();
            return resultSet;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean usesLocalFiles() {
        this.debugCodeCall("usesLocalFiles");
        return true;
    }

    @Override
    public boolean usesLocalFilePerTable() {
        this.debugCodeCall("usesLocalFilePerTable");
        return false;
    }

    @Override
    public String getIdentifierQuoteString() {
        this.debugCodeCall("getIdentifierQuoteString");
        return "\"";
    }

    @Override
    public String getSQLKeywords() {
        this.debugCodeCall("getSQLKeywords");
        return "LIMIT,MINUS,ROWNUM,SYSDATE,SYSTIME,SYSTIMESTAMP,TODAY";
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        this.debugCodeCall("getNumericFunctions");
        return this.getFunctions("Functions (Numeric)");
    }

    @Override
    public String getStringFunctions() throws SQLException {
        this.debugCodeCall("getStringFunctions");
        return this.getFunctions("Functions (String)");
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        this.debugCodeCall("getSystemFunctions");
        return this.getFunctions("Functions (System)");
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        this.debugCodeCall("getTimeDateFunctions");
        return this.getFunctions("Functions (Time and Date)");
    }

    private String getFunctions(String string) throws SQLException {
        try {
            this.checkClosed();
            PreparedStatement preparedStatement = this.conn.prepareAutoCloseStatement("SELECT TOPIC FROM INFORMATION_SCHEMA.HELP WHERE SECTION = ?");
            preparedStatement.setString(1, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            StatementBuilder statementBuilder = new StatementBuilder();
            while (resultSet.next()) {
                String[] stringArray;
                String string2 = resultSet.getString(1).trim();
                for (String string3 : stringArray = StringUtils.arraySplit(string2, ',', true)) {
                    statementBuilder.appendExceptFirst(",");
                    String string4 = string3.trim();
                    if (string4.indexOf(32) >= 0) {
                        string4 = string4.substring(0, string4.indexOf(32)).trim();
                    }
                    statementBuilder.append(string4);
                }
            }
            resultSet.close();
            preparedStatement.close();
            return statementBuilder.toString();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public String getSearchStringEscape() {
        this.debugCodeCall("getSearchStringEscape");
        return "\\";
    }

    @Override
    public String getExtraNameCharacters() {
        this.debugCodeCall("getExtraNameCharacters");
        return "";
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() {
        this.debugCodeCall("supportsAlterTableWithAddColumn");
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() {
        this.debugCodeCall("supportsAlterTableWithDropColumn");
        return true;
    }

    @Override
    public boolean supportsColumnAliasing() {
        this.debugCodeCall("supportsColumnAliasing");
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() {
        this.debugCodeCall("nullPlusNonNullIsNull");
        return true;
    }

    @Override
    public boolean supportsConvert() {
        this.debugCodeCall("supportsConvert");
        return true;
    }

    @Override
    public boolean supportsConvert(int n, int n2) {
        if (this.isDebugEnabled()) {
            this.debugCode("supportsConvert(" + n + ", " + n + ");");
        }
        return true;
    }

    @Override
    public boolean supportsTableCorrelationNames() {
        this.debugCodeCall("supportsTableCorrelationNames");
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() {
        this.debugCodeCall("supportsDifferentTableCorrelationNames");
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() {
        this.debugCodeCall("supportsExpressionsInOrderBy");
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() {
        this.debugCodeCall("supportsOrderByUnrelated");
        return true;
    }

    @Override
    public boolean supportsGroupBy() {
        this.debugCodeCall("supportsGroupBy");
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() {
        this.debugCodeCall("supportsGroupByUnrelated");
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() {
        this.debugCodeCall("supportsGroupByBeyondSelect");
        return true;
    }

    @Override
    public boolean supportsLikeEscapeClause() {
        this.debugCodeCall("supportsLikeEscapeClause");
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() {
        this.debugCodeCall("supportsMultipleResultSets");
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() {
        this.debugCodeCall("supportsMultipleTransactions");
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() {
        this.debugCodeCall("supportsNonNullableColumns");
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() {
        this.debugCodeCall("supportsMinimumSQLGrammar");
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() {
        this.debugCodeCall("supportsCoreSQLGrammar");
        return true;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() {
        this.debugCodeCall("supportsExtendedSQLGrammar");
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() {
        this.debugCodeCall("supportsANSI92EntryLevelSQL");
        return true;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() {
        this.debugCodeCall("supportsANSI92IntermediateSQL");
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() {
        this.debugCodeCall("supportsANSI92FullSQL");
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() {
        this.debugCodeCall("supportsIntegrityEnhancementFacility");
        return true;
    }

    @Override
    public boolean supportsOuterJoins() {
        this.debugCodeCall("supportsOuterJoins");
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() {
        this.debugCodeCall("supportsFullOuterJoins");
        return false;
    }

    @Override
    public boolean supportsLimitedOuterJoins() {
        this.debugCodeCall("supportsLimitedOuterJoins");
        return true;
    }

    @Override
    public String getSchemaTerm() {
        this.debugCodeCall("getSchemaTerm");
        return "schema";
    }

    @Override
    public String getProcedureTerm() {
        this.debugCodeCall("getProcedureTerm");
        return "procedure";
    }

    @Override
    public String getCatalogTerm() {
        this.debugCodeCall("getCatalogTerm");
        return "catalog";
    }

    @Override
    public boolean isCatalogAtStart() {
        this.debugCodeCall("isCatalogAtStart");
        return true;
    }

    @Override
    public String getCatalogSeparator() {
        this.debugCodeCall("getCatalogSeparator");
        return ".";
    }

    @Override
    public boolean supportsSchemasInDataManipulation() {
        this.debugCodeCall("supportsSchemasInDataManipulation");
        return true;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() {
        this.debugCodeCall("supportsSchemasInProcedureCalls");
        return true;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() {
        this.debugCodeCall("supportsSchemasInTableDefinitions");
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() {
        this.debugCodeCall("supportsSchemasInIndexDefinitions");
        return true;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() {
        this.debugCodeCall("supportsSchemasInPrivilegeDefinitions");
        return true;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() {
        this.debugCodeCall("supportsCatalogsInDataManipulation");
        return true;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() {
        this.debugCodeCall("supportsCatalogsInProcedureCalls");
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() {
        this.debugCodeCall("supportsCatalogsInTableDefinitions");
        return true;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() {
        this.debugCodeCall("supportsCatalogsInIndexDefinitions");
        return true;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() {
        this.debugCodeCall("supportsCatalogsInPrivilegeDefinitions");
        return true;
    }

    @Override
    public boolean supportsPositionedDelete() {
        this.debugCodeCall("supportsPositionedDelete");
        return true;
    }

    @Override
    public boolean supportsPositionedUpdate() {
        this.debugCodeCall("supportsPositionedUpdate");
        return true;
    }

    @Override
    public boolean supportsSelectForUpdate() {
        this.debugCodeCall("supportsSelectForUpdate");
        return true;
    }

    @Override
    public boolean supportsStoredProcedures() {
        this.debugCodeCall("supportsStoredProcedures");
        return false;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() {
        this.debugCodeCall("supportsSubqueriesInComparisons");
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() {
        this.debugCodeCall("supportsSubqueriesInExists");
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() {
        this.debugCodeCall("supportsSubqueriesInIns");
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() {
        this.debugCodeCall("supportsSubqueriesInQuantifieds");
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() {
        this.debugCodeCall("supportsCorrelatedSubqueries");
        return true;
    }

    @Override
    public boolean supportsUnion() {
        this.debugCodeCall("supportsUnion");
        return true;
    }

    @Override
    public boolean supportsUnionAll() {
        this.debugCodeCall("supportsUnionAll");
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() {
        this.debugCodeCall("supportsOpenCursorsAcrossCommit");
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() {
        this.debugCodeCall("supportsOpenCursorsAcrossRollback");
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() {
        this.debugCodeCall("supportsOpenStatementsAcrossCommit");
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() {
        this.debugCodeCall("supportsOpenStatementsAcrossRollback");
        return true;
    }

    @Override
    public boolean supportsTransactions() {
        this.debugCodeCall("supportsTransactions");
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int n) {
        this.debugCodeCall("supportsTransactionIsolationLevel");
        return true;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() {
        this.debugCodeCall("supportsDataDefinitionAndDataManipulationTransactions");
        return false;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() {
        this.debugCodeCall("supportsDataManipulationTransactionsOnly");
        return true;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() {
        this.debugCodeCall("dataDefinitionCausesTransactionCommit");
        return true;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() {
        this.debugCodeCall("dataDefinitionIgnoredInTransactions");
        return false;
    }

    @Override
    public boolean supportsResultSetType(int n) {
        this.debugCodeCall("supportsResultSetType", n);
        return n != 1005;
    }

    @Override
    public boolean supportsResultSetConcurrency(int n, int n2) {
        if (this.isDebugEnabled()) {
            this.debugCode("supportsResultSetConcurrency(" + n + ", " + n2 + ");");
        }
        return n != 1005;
    }

    @Override
    public boolean ownUpdatesAreVisible(int n) {
        this.debugCodeCall("ownUpdatesAreVisible", n);
        return true;
    }

    @Override
    public boolean ownDeletesAreVisible(int n) {
        this.debugCodeCall("ownDeletesAreVisible", n);
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int n) {
        this.debugCodeCall("ownInsertsAreVisible", n);
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int n) {
        this.debugCodeCall("othersUpdatesAreVisible", n);
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int n) {
        this.debugCodeCall("othersDeletesAreVisible", n);
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int n) {
        this.debugCodeCall("othersInsertsAreVisible", n);
        return false;
    }

    @Override
    public boolean updatesAreDetected(int n) {
        this.debugCodeCall("updatesAreDetected", n);
        return false;
    }

    @Override
    public boolean deletesAreDetected(int n) {
        this.debugCodeCall("deletesAreDetected", n);
        return false;
    }

    @Override
    public boolean insertsAreDetected(int n) {
        this.debugCodeCall("insertsAreDetected", n);
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() {
        this.debugCodeCall("supportsBatchUpdates");
        return true;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() {
        this.debugCodeCall("doesMaxRowSizeIncludeBlobs");
        return false;
    }

    @Override
    public int getDefaultTransactionIsolation() {
        this.debugCodeCall("getDefaultTransactionIsolation");
        return 2;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() {
        this.debugCodeCall("supportsMixedCaseIdentifiers");
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        this.debugCodeCall("supportsMixedCaseQuotedIdentifiers");
        String string = this.getMode();
        return !string.equals("MySQL");
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        this.debugCodeCall("storesUpperCaseIdentifiers");
        String string = this.getMode();
        return !string.equals("MySQL");
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        this.debugCodeCall("storesLowerCaseIdentifiers");
        String string = this.getMode();
        return string.equals("MySQL");
    }

    @Override
    public boolean storesMixedCaseIdentifiers() {
        this.debugCodeCall("storesMixedCaseIdentifiers");
        return false;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        this.debugCodeCall("storesUpperCaseQuotedIdentifiers");
        String string = this.getMode();
        return string.equals("MySQL");
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        this.debugCodeCall("storesLowerCaseQuotedIdentifiers");
        String string = this.getMode();
        return string.equals("MySQL");
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        this.debugCodeCall("storesMixedCaseQuotedIdentifiers");
        String string = this.getMode();
        return !string.equals("MySQL");
    }

    @Override
    public int getMaxBinaryLiteralLength() {
        this.debugCodeCall("getMaxBinaryLiteralLength");
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() {
        this.debugCodeCall("getMaxCharLiteralLength");
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() {
        this.debugCodeCall("getMaxColumnNameLength");
        return 0;
    }

    @Override
    public int getMaxColumnsInGroupBy() {
        this.debugCodeCall("getMaxColumnsInGroupBy");
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() {
        this.debugCodeCall("getMaxColumnsInIndex");
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() {
        this.debugCodeCall("getMaxColumnsInOrderBy");
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() {
        this.debugCodeCall("getMaxColumnsInSelect");
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() {
        this.debugCodeCall("getMaxColumnsInTable");
        return 0;
    }

    @Override
    public int getMaxConnections() {
        this.debugCodeCall("getMaxConnections");
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() {
        this.debugCodeCall("getMaxCursorNameLength");
        return 0;
    }

    @Override
    public int getMaxIndexLength() {
        this.debugCodeCall("getMaxIndexLength");
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() {
        this.debugCodeCall("getMaxSchemaNameLength");
        return 0;
    }

    @Override
    public int getMaxProcedureNameLength() {
        this.debugCodeCall("getMaxProcedureNameLength");
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() {
        this.debugCodeCall("getMaxCatalogNameLength");
        return 0;
    }

    @Override
    public int getMaxRowSize() {
        this.debugCodeCall("getMaxRowSize");
        return 0;
    }

    @Override
    public int getMaxStatementLength() {
        this.debugCodeCall("getMaxStatementLength");
        return 0;
    }

    @Override
    public int getMaxStatements() {
        this.debugCodeCall("getMaxStatements");
        return 0;
    }

    @Override
    public int getMaxTableNameLength() {
        this.debugCodeCall("getMaxTableNameLength");
        return 0;
    }

    @Override
    public int getMaxTablesInSelect() {
        this.debugCodeCall("getMaxTablesInSelect");
        return 0;
    }

    @Override
    public int getMaxUserNameLength() {
        this.debugCodeCall("getMaxUserNameLength");
        return 0;
    }

    @Override
    public boolean supportsSavepoints() {
        this.debugCodeCall("supportsSavepoints");
        return true;
    }

    @Override
    public boolean supportsNamedParameters() {
        this.debugCodeCall("supportsNamedParameters");
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() {
        this.debugCodeCall("supportsMultipleOpenResults");
        return true;
    }

    @Override
    public boolean supportsGetGeneratedKeys() {
        this.debugCodeCall("supportsGetGeneratedKeys");
        return true;
    }

    @Override
    public ResultSet getSuperTypes(String string, String string2, String string3) throws SQLException {
        throw this.unsupported("superTypes");
    }

    @Override
    public ResultSet getSuperTables(String string, String string2, String string3) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getSuperTables(" + JdbcDatabaseMetaData.quote(string) + ", " + JdbcDatabaseMetaData.quote(string2) + ", " + JdbcDatabaseMetaData.quote(string3) + ");");
            }
            this.checkClosed();
            PreparedStatement preparedStatement = this.conn.prepareAutoCloseStatement("SELECT CATALOG_NAME TABLE_CAT, CATALOG_NAME TABLE_SCHEM, CATALOG_NAME TABLE_NAME, CATALOG_NAME SUPERTABLE_NAME FROM INFORMATION_SCHEMA.CATALOGS WHERE FALSE");
            return preparedStatement.executeQuery();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public ResultSet getAttributes(String string, String string2, String string3, String string4) throws SQLException {
        throw this.unsupported("attributes");
    }

    @Override
    public boolean supportsResultSetHoldability(int n) {
        this.debugCodeCall("supportsResultSetHoldability", n);
        return n == 2;
    }

    @Override
    public int getResultSetHoldability() {
        this.debugCodeCall("getResultSetHoldability");
        return 2;
    }

    @Override
    public int getDatabaseMajorVersion() {
        this.debugCodeCall("getDatabaseMajorVersion");
        return 1;
    }

    @Override
    public int getDatabaseMinorVersion() {
        this.debugCodeCall("getDatabaseMinorVersion");
        return 4;
    }

    @Override
    public int getJDBCMajorVersion() {
        this.debugCodeCall("getJDBCMajorVersion");
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() {
        this.debugCodeCall("getJDBCMinorVersion");
        return 0;
    }

    @Override
    public int getSQLStateType() {
        this.debugCodeCall("getSQLStateType");
        return 2;
    }

    @Override
    public boolean locatorsUpdateCopy() {
        this.debugCodeCall("locatorsUpdateCopy");
        return false;
    }

    @Override
    public boolean supportsStatementPooling() {
        this.debugCodeCall("supportsStatementPooling");
        return false;
    }

    private void checkClosed() {
        this.conn.checkClosed();
    }

    private static String getPattern(String string) {
        return string == null ? "%" : string;
    }

    private static String getSchemaPattern(String string) {
        return string == null ? "%" : (string.length() == 0 ? "PUBLIC" : string);
    }

    private static String getCatalogPattern(String string) {
        return string == null || string.length() == 0 ? "%" : string;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() {
        this.debugCodeCall("getRowIdLifetime");
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public ResultSet getSchemas(String string, String string2) throws SQLException {
        try {
            this.debugCodeCall("getSchemas(String,String)");
            this.checkClosed();
            PreparedStatement preparedStatement = this.conn.prepareAutoCloseStatement("SELECT SCHEMA_NAME TABLE_SCHEM, CATALOG_NAME TABLE_CATALOG,  IS_DEFAULT FROM INFORMATION_SCHEMA.SCHEMATA WHERE CATALOG_NAME LIKE ? ESCAPE ? AND SCHEMA_NAME LIKE ? ESCAPE ? ORDER BY SCHEMA_NAME");
            preparedStatement.setString(1, JdbcDatabaseMetaData.getCatalogPattern(string));
            preparedStatement.setString(2, "\\");
            preparedStatement.setString(3, JdbcDatabaseMetaData.getSchemaPattern(string2));
            preparedStatement.setString(4, "\\");
            return preparedStatement.executeQuery();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() {
        this.debugCodeCall("supportsStoredFunctionsUsingCallSyntax");
        return true;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() {
        this.debugCodeCall("autoCommitFailureClosesAllResultSets");
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        return new SimpleResultSet();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw this.unsupported("unwrap");
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        throw this.unsupported("isWrapperFor");
    }

    @Override
    public ResultSet getFunctionColumns(String string, String string2, String string3, String string4) throws SQLException {
        throw this.unsupported("getFunctionColumns");
    }

    @Override
    public ResultSet getFunctions(String string, String string2, String string3) throws SQLException {
        throw this.unsupported("getFunctions");
    }

    @Override
    public boolean generatedKeyAlwaysReturned() {
        return true;
    }

    @Override
    public ResultSet getPseudoColumns(String string, String string2, String string3, String string4) {
        return null;
    }

    public String toString() {
        return this.getTraceObjectName() + ": " + this.conn;
    }

    private String getMode() throws SQLException {
        if (this.mode == null) {
            PreparedStatement preparedStatement = this.conn.prepareStatement("SELECT VALUE FROM INFORMATION_SCHEMA.SETTINGS WHERE NAME=?");
            preparedStatement.setString(1, "MODE");
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            this.mode = resultSet.getString(1);
            preparedStatement.close();
        }
        return this.mode;
    }
}

