/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.pdf.operations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.platform.pdf.LinkInfo;
import org.nuxeo.ecm.platform.pdf.PDFLinks;

@Operation(id="PDF.ExtractLinks", category="Conversion", label="PDF: Extract Links", description="Returns a JSON string of an array of objects with page, subType, text and link fields. If getAll is true, returns all the links (Remote Go To, Launch and URI in the current version).")
public class PDFExtractLinksOperation {
    public static final String ID = "PDF.ExtractLinks";
    @Param(name="type", required=false, widget="Option", values={"Launch", "Remote Go To", "URI"})
    protected String type;
    @Param(name="getAll", required=false)
    protected boolean getAll = false;

    @OperationMethod
    public String run(Blob inBlob) throws IOException, JSONException {
        ArrayList<String> types = new ArrayList<String>();
        if (this.getAll) {
            types.add("Launch");
            types.add("Remote Go To");
            types.add("URI");
        } else {
            if (StringUtils.isBlank((CharSequence)this.type)) {
                throw new IllegalArgumentException("type cannot be empty if getAll is false");
            }
            types.add(this.type);
        }
        PDFLinks pdfl = new PDFLinks(inBlob);
        JSONArray array = new JSONArray();
        for (String theType : types) {
            List<Object> links = new ArrayList();
            switch (theType.toLowerCase()) {
                case "remote go to": {
                    links = pdfl.getRemoteGoToLinks();
                    break;
                }
                case "launch": {
                    links = pdfl.getLaunchLinks();
                    break;
                }
                case "uri": {
                    links = pdfl.getURILinks();
                }
            }
            for (LinkInfo li : links) {
                JSONObject object = new JSONObject();
                object.put("page", li.getPage());
                object.put("subType", (Object)li.getSubType());
                object.put("text", (Object)li.getText());
                object.put("link", (Object)li.getLink());
                array.put((Object)object);
            }
        }
        pdfl.close();
        return array.toString();
    }
}

