/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.computation;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.lib.stream.computation.AbstractComputation;
import org.nuxeo.lib.stream.computation.ComputationContext;
import org.nuxeo.lib.stream.computation.Record;

public abstract class AbstractBatchComputation
extends AbstractComputation {
    private static final Log log = LogFactory.getLog(AbstractBatchComputation.class);
    public static final String TIMER_BATCH = "batch";
    protected List<Record> batchRecords;
    protected String currentInputStream;
    protected boolean newBatch = true;
    protected long thresholdMillis;
    protected boolean removeLastRecordOnRetry;

    public AbstractBatchComputation(String name, int nbInputStreams, int nbOutputStreams) {
        super(name, nbInputStreams, nbOutputStreams);
    }

    protected abstract void batchProcess(ComputationContext var1, String var2, List<Record> var3);

    public abstract void batchFailure(ComputationContext var1, String var2, List<Record> var3);

    @Override
    public void init(ComputationContext context) {
        this.thresholdMillis = context.getPolicy().getBatchThreshold().toMillis();
        context.setTimer(TIMER_BATCH, System.currentTimeMillis() + this.thresholdMillis);
        this.batchRecords = new ArrayList<Record>(context.getPolicy().batchCapacity);
    }

    @Override
    public void processTimer(ComputationContext context, String key, long timestamp) {
        if (!TIMER_BATCH.equals(key)) {
            return;
        }
        if (!this.batchRecords.isEmpty()) {
            this.batchProcess(context);
        }
        context.setTimer(TIMER_BATCH, System.currentTimeMillis() + this.thresholdMillis);
    }

    @Override
    public void processRecord(ComputationContext context, String inputStreamName, Record record) {
        if (!inputStreamName.equals(this.currentInputStream) && !this.batchRecords.isEmpty()) {
            this.batchProcess(context);
        }
        if (this.newBatch) {
            this.currentInputStream = inputStreamName;
            this.newBatch = false;
        }
        this.batchRecords.add(record);
        if (this.batchRecords.size() >= context.getPolicy().getBatchCapacity()) {
            this.removeLastRecordOnRetry = true;
            this.batchProcess(context);
            this.removeLastRecordOnRetry = false;
        }
    }

    private void batchProcess(ComputationContext context) {
        this.batchProcess(context, this.currentInputStream, this.batchRecords);
        this.checkpointBatch(context);
    }

    protected void checkpointBatch(ComputationContext context) {
        context.askForCheckpoint();
        this.batchRecords.clear();
        this.newBatch = true;
    }

    @Override
    public void processRetry(ComputationContext context, Throwable failure) {
        if (this.removeLastRecordOnRetry) {
            this.batchRecords.remove(this.batchRecords.size() - 1);
            this.removeLastRecordOnRetry = false;
        }
        log.warn((Object)String.format("Computation: %s fails to process batch of %d records, last record: %s, retrying ...", this.metadata.name(), this.batchRecords.size(), context.getLastOffset()), failure);
    }

    @Override
    public void processFailure(ComputationContext context, Throwable failure) {
        log.error((Object)String.format("Computation: %s fails to process batch of %d records after retries, last record: %s, policy: %s", this.metadata.name(), this.batchRecords.size(), context.getLastOffset(), context.getPolicy()), failure);
        this.batchFailure(context, this.currentInputStream, this.batchRecords);
        this.batchRecords.clear();
        this.newBatch = true;
    }
}

