/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.comment.impl;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.security.PermissionProvider;
import org.nuxeo.ecm.core.io.marshallers.json.ExtensibleEntityJsonWriter;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.platform.comment.api.Annotation;
import org.nuxeo.ecm.platform.comment.api.Comment;
import org.nuxeo.ecm.platform.comment.impl.CommentJsonWriter;
import org.nuxeo.runtime.api.Framework;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class AnnotationJsonWriter
extends ExtensibleEntityJsonWriter<Annotation> {
    public static final String ENTITY_TYPE = "annotation";

    public AnnotationJsonWriter() {
        super(ENTITY_TYPE, Annotation.class);
    }

    protected void writeEntityBody(Annotation entity, JsonGenerator jg) throws IOException {
        CommentJsonWriter.writeCommentEntity((Comment)entity, jg);
        jg.writeStringField("xpath", entity.getXpath());
        CoreSession session = this.ctx.getSession(null).getSession();
        NuxeoPrincipal principal = session.getPrincipal();
        PermissionProvider permissionProvider = (PermissionProvider)Framework.getService(PermissionProvider.class);
        Collection permissions = (Collection)CoreInstance.doPrivileged((CoreSession)session, s -> s.filterGrantedPermissions(principal, (DocumentRef)new IdRef(entity.getParentId()), Arrays.asList(permissionProvider.getPermissions())));
        jg.writeArrayFieldStart("permissions");
        for (String permission : permissions) {
            jg.writeString(permission);
        }
        jg.writeEndArray();
    }
}

