/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.comment.impl;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.inject.Inject;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PartialList;
import org.nuxeo.ecm.core.api.security.PermissionProvider;
import org.nuxeo.ecm.core.io.marshallers.json.ExtensibleEntityJsonWriter;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.platform.comment.api.Comment;
import org.nuxeo.ecm.platform.comment.api.CommentManager;
import org.nuxeo.ecm.platform.comment.api.ExternalEntity;
import org.nuxeo.runtime.api.Framework;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class CommentJsonWriter
extends ExtensibleEntityJsonWriter<Comment> {
    public static final String FETCH_REPLIES_SUMMARY = "repliesSummary";
    @Inject
    protected CommentManager commentManager;

    public CommentJsonWriter() {
        super("comment", Comment.class);
    }

    protected void writeEntityBody(Comment entity, JsonGenerator jg) throws IOException {
        CommentJsonWriter.writeCommentEntity(entity, jg);
        CoreSession session = this.ctx.getSession(null).getSession();
        NuxeoPrincipal principal = session.getPrincipal();
        PermissionProvider permissionProvider = (PermissionProvider)Framework.getService(PermissionProvider.class);
        Collection permissions = (Collection)CoreInstance.doPrivileged((CoreSession)session, s -> {
            if (entity.getId() == null) {
                return Collections.emptyList();
            }
            IdRef ancestorRef = new IdRef((String)((Object)this.commentManager.getThreadForComment(s.getDocument((DocumentRef)new IdRef(entity.getId()))).getPropertyValue("comment:parentId")));
            return s.filterGrantedPermissions(principal, (DocumentRef)ancestorRef, Arrays.asList(permissionProvider.getPermissions()));
        });
        jg.writeArrayFieldStart("permissions");
        for (String permission : permissions) {
            jg.writeString(permission);
        }
        jg.writeEndArray();
        boolean includeRepliesSummary = this.ctx.getFetched("comment").contains(FETCH_REPLIES_SUMMARY);
        if (includeRepliesSummary) {
            this.writeRepliesSummary(session, entity, jg);
        }
    }

    protected static void writeCommentEntity(Comment entity, JsonGenerator jg) throws IOException {
        jg.writeStringField("id", entity.getId());
        jg.writeStringField("parentId", entity.getParentId());
        jg.writeArrayFieldStart("ancestorIds");
        for (String ancestorId : entity.getAncestorIds()) {
            jg.writeString(ancestorId);
        }
        jg.writeEndArray();
        jg.writeStringField("author", entity.getAuthor());
        jg.writeStringField("text", entity.getText());
        String creationDate = entity.getCreationDate() != null ? entity.getCreationDate().toString() : null;
        jg.writeStringField("creationDate", creationDate);
        String modificationDate = entity.getModificationDate() != null ? entity.getModificationDate().toString() : null;
        jg.writeStringField("modificationDate", modificationDate);
        if (entity instanceof ExternalEntity) {
            jg.writeStringField("entityId", ((ExternalEntity)entity).getEntityId());
            jg.writeStringField("origin", ((ExternalEntity)entity).getOrigin());
            jg.writeStringField("entity", ((ExternalEntity)entity).getEntity());
        }
    }

    protected void writeRepliesSummary(CoreSession session, Comment entity, JsonGenerator jg) throws IOException {
        PartialList comments = this.commentManager.getComments(session, entity.getId(), Long.valueOf(1L), Long.valueOf(0L), false);
        jg.writeNumberField("numberOfReplies", comments.totalSize());
        if (comments.size() > 0) {
            jg.writeStringField("lastReplyDate", ((Comment)comments.get(0)).getCreationDate().toString());
        }
    }
}

