/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc;

import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FullTextUtils;
import org.nuxeo.ecm.core.api.impl.FacetFilter;
import org.nuxeo.ecm.core.api.trash.TrashService;
import org.nuxeo.ecm.core.query.QueryFilter;
import org.nuxeo.ecm.core.query.QueryParseException;
import org.nuxeo.ecm.core.query.sql.NXQL;
import org.nuxeo.ecm.core.query.sql.SQLQueryParser;
import org.nuxeo.ecm.core.query.sql.model.BooleanLiteral;
import org.nuxeo.ecm.core.query.sql.model.DateLiteral;
import org.nuxeo.ecm.core.query.sql.model.DefaultQueryVisitor;
import org.nuxeo.ecm.core.query.sql.model.DoubleLiteral;
import org.nuxeo.ecm.core.query.sql.model.Expression;
import org.nuxeo.ecm.core.query.sql.model.FromClause;
import org.nuxeo.ecm.core.query.sql.model.FromList;
import org.nuxeo.ecm.core.query.sql.model.Function;
import org.nuxeo.ecm.core.query.sql.model.IVisitor;
import org.nuxeo.ecm.core.query.sql.model.IntegerLiteral;
import org.nuxeo.ecm.core.query.sql.model.Literal;
import org.nuxeo.ecm.core.query.sql.model.LiteralList;
import org.nuxeo.ecm.core.query.sql.model.MultiExpression;
import org.nuxeo.ecm.core.query.sql.model.Operand;
import org.nuxeo.ecm.core.query.sql.model.Operator;
import org.nuxeo.ecm.core.query.sql.model.OrderByClause;
import org.nuxeo.ecm.core.query.sql.model.OrderByExpr;
import org.nuxeo.ecm.core.query.sql.model.OrderByList;
import org.nuxeo.ecm.core.query.sql.model.Predicate;
import org.nuxeo.ecm.core.query.sql.model.Reference;
import org.nuxeo.ecm.core.query.sql.model.SQLQuery;
import org.nuxeo.ecm.core.query.sql.model.SelectClause;
import org.nuxeo.ecm.core.query.sql.model.StringLiteral;
import org.nuxeo.ecm.core.query.sql.model.WhereClause;
import org.nuxeo.ecm.core.storage.sql.ColumnType;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.ModelProperty;
import org.nuxeo.ecm.core.storage.sql.Session;
import org.nuxeo.ecm.core.storage.sql.jdbc.QueryMaker;
import org.nuxeo.ecm.core.storage.sql.jdbc.SQLInfo;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Column;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Database;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Join;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Select;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Table;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.TableAlias;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.Dialect;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.migration.MigrationService;

public class NXQLQueryMaker
implements QueryMaker {
    private static final Log log = LogFactory.getLog(NXQLQueryMaker.class);
    public static final String TYPE_DOCUMENT = "Document";
    public static final String TYPE_RELATION = "Relation";
    public static final String TYPE_TAGGING = "Tagging";
    public static final String RELATION_TABLE = "relation";
    public static final String ECM_SIMPLE_ACP_PRINCIPAL = "ecm:acl/*/principal";
    public static final String ECM_SIMPLE_ACP_PERMISSION = "ecm:acl/*/permission";
    public static final String ECM_SIMPLE_ACP_GRANT = "ecm:acl/*/grant";
    public static final String ECM_SIMPLE_ACP_NAME = "ecm:acl/*/name";
    public static final String ECM_SIMPLE_ACP_POS = "ecm:acl/*/pos";
    public static final String ECM_SIMPLE_ACP_CREATOR = "ecm:acl/*/creator";
    public static final String ECM_SIMPLE_ACP_BEGIN = "ecm:acl/*/begin";
    public static final String ECM_SIMPLE_ACP_END = "ecm:acl/*/end";
    public static final String ECM_SIMPLE_ACP_STATUS = "ecm:acl/*/status";
    public static final String ECM_TAG_STAR = "ecm:tag/*";
    public static final String FACETED_TAG = "nxtag:tags";
    public static final String FACETED_TAG_LABEL = "label";
    protected static final String TABLE_HIER_ALIAS = "_H";
    protected static final String TABLE_FRAG_ALIAS = "_F";
    protected static final String SUBQUERY_ARRAY_ALIAS = "_A";
    protected static final String COL_ALIAS_PREFIX = "_C";
    protected static final String UNION_ALIAS = "_T";
    protected static final String WITH_ALIAS_PREFIX = "_W";
    protected static final String READ_ACL_ALIAS = "_RACL";
    protected static final String READ_ACL_USER_MAP_ALIAS = "_ACLRUSERMAP";
    protected static final String DATE_CAST = "DATE";
    protected static final String COUNT_FUNCTION = "COUNT";
    protected static final String AVG_FUNCTION = "AVG";
    protected static final List<String> AGGREGATE_FUNCTIONS = Arrays.asList("COUNT", "AVG", "SUM", "MIN", "MAX");
    protected SQLInfo sqlInfo;
    protected Database database;
    protected Dialect dialect;
    protected Model model;
    protected Set<String> neverPerInstanceMixins;
    protected Session.PathResolver pathResolver;
    protected final Map<String, String> aliasesByName = new HashMap<String, String>();
    protected final List<String> aliases = new LinkedList<String>();
    protected Set<String> selectCollectionNotNull;
    protected Boolean proxyClause;
    protected String proxyClauseReason;
    protected Table hierTable;
    protected Table dataHierTable;
    protected Table proxyTable;
    protected List<Join> joins;
    protected List<String> whereClauses;
    protected List<Serializable> whereParams;
    protected Map<String, Table> propertyFragmentTables = new HashMap<String, Table>();
    protected int fragJoinCount = 0;
    protected static final Pattern INDEX = Pattern.compile("\\d+|\\*|\\*\\d+");
    protected static final Pattern HAS_WILDCARD_INDEX = Pattern.compile(".*/(\\*|\\*\\d+)(/.*|$)");
    protected static final Pattern HAS_FINAL_WILDCARD_INDEX = Pattern.compile(".*/(\\*|\\*\\d+)");
    protected static final Pattern INDEX_SLASH = Pattern.compile("/(?:\\d+|\\*|\\*\\d+)(/|$)");
    protected static final Pattern NON_CANON_INDEX = Pattern.compile("[^/\\[\\]]+\\[(\\d+|\\*|\\*\\d+)\\]");

    @Override
    public String getName() {
        return "NXQL";
    }

    @Override
    public boolean accepts(String queryType) {
        return queryType.equals("NXQL");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public QueryMaker.Query buildQuery(SQLInfo sqlInfo, Model model, Session.PathResolver pathResolver, String query, QueryFilter queryFilter, Object ... params) {
        this.sqlInfo = sqlInfo;
        this.database = sqlInfo.database;
        this.dialect = sqlInfo.dialect;
        this.model = model;
        this.pathResolver = pathResolver;
        this.neverPerInstanceMixins = new HashSet<String>(model.getNoPerDocumentQueryFacets());
        Set<String> npim = model.getRepositoryDescriptor().neverPerInstanceMixins;
        if (npim != null) {
            this.neverPerInstanceMixins.addAll(npim);
        }
        SQLQuery sqlQuery = SQLQueryParser.parse((String)query);
        for (SQLQuery.Transformer transformer : queryFilter.getQueryTransformers()) {
            sqlQuery = transformer.transform(queryFilter.getPrincipal(), sqlQuery);
        }
        SelectClause selectClause = sqlQuery.select;
        if (selectClause.isEmpty()) {
            selectClause.add((Operand)new Reference("ecm:uuid"));
        }
        boolean selectStar = selectClause.getSelectList().size() == 1 && selectClause.get(0).equals(new Reference("ecm:uuid"));
        QueryAnalyzer queryAnalyzer = this.newQueryAnalyzer(queryFilter.getFacetFilter());
        try {
            queryAnalyzer.visitQuery(sqlQuery);
        }
        catch (QueryMaker.QueryCannotMatchException e) {
            return null;
        }
        boolean distinct = selectClause.isDistinct();
        if (selectStar && queryAnalyzer.hasWildcardIndex) {
            distinct = true;
        }
        boolean reAnalyze = false;
        if (queryAnalyzer.ftCount == 1 && !distinct && sqlQuery.orderBy == null) {
            sqlQuery.orderBy = new OrderByClause(new OrderByList(new OrderByExpr(new Reference("ecm:fulltextScore"), true)), false);
            queryAnalyzer.orderByScore = true;
            reAnalyze = true;
        }
        if (queryAnalyzer.orderByScore && !queryAnalyzer.selectScore) {
            selectClause.add((Operand)new Reference("ecm:fulltextScore"));
            reAnalyze = true;
        }
        if (reAnalyze) {
            queryAnalyzer.visitQuery(sqlQuery);
        }
        if (queryAnalyzer.ftCount > 1 && (queryAnalyzer.orderByScore || queryAnalyzer.selectScore)) {
            throw new QueryParseException("Cannot use ecm:fulltextScore with more than one fulltext match expression");
        }
        if (!model.getRepositoryDescriptor().getProxiesEnabled() || queryAnalyzer.onlyRelations) {
            if (this.proxyClause == Boolean.TRUE) {
                return null;
            }
            this.proxyClause = Boolean.FALSE;
        }
        DocKind[] docKinds = this.proxyClause == Boolean.TRUE ? new DocKind[]{DocKind.PROXY} : (this.proxyClause == Boolean.FALSE ? new DocKind[]{DocKind.DIRECT} : new DocKind[]{DocKind.DIRECT, DocKind.PROXY});
        boolean doUnion = docKinds.length > 1;
        boolean hasSelectCollection = queryAnalyzer.hasSelectCollection;
        if (doUnion || distinct) {
            List<String> whatColumnNames = queryAnalyzer.whatColumnNames;
            if (distinct && !whatColumnNames.contains("ecm:uuid")) {
                hasSelectCollection = false;
            }
            HashSet<String> onlyOrderByColumnNames = new HashSet<String>(queryAnalyzer.orderByColumnNames);
            if (hasSelectCollection) {
                onlyOrderByColumnNames.add("ecm:uuid");
            }
            onlyOrderByColumnNames.removeAll(whatColumnNames);
            if (distinct && !onlyOrderByColumnNames.isEmpty()) {
                if (!selectStar) {
                    throw new QueryParseException("For SELECT DISTINCT the ORDER BY columns must be in the SELECT list, missing: " + onlyOrderByColumnNames);
                }
                if (queryAnalyzer.orderByHasWildcardIndex) {
                    throw new QueryParseException("For SELECT * the ORDER BY columns cannot use wildcard indexes");
                }
            }
            for (String name : onlyOrderByColumnNames) {
                selectClause.add((Operand)new Reference(name));
            }
        }
        LinkedList<Column> whatColumns = null;
        LinkedList<String> whatKeys = null;
        Select select = null;
        String orderBy = null;
        ArrayList<String> statements = new ArrayList<String>(2);
        LinkedList<Serializable> selectParams = new LinkedList<Serializable>();
        LinkedList<CallSite> withTables = new LinkedList<CallSite>();
        LinkedList<Object> withSelects = new LinkedList<Object>();
        LinkedList<String> withSelectsStatements = new LinkedList<String>();
        LinkedList withParams = new LinkedList();
        Table hier = this.database.getTable("hierarchy");
        for (DocKind docKind : docKinds) {
            Object from;
            String hierId;
            this.joins = new LinkedList<Join>();
            this.whereClauses = new LinkedList<String>();
            this.whereParams = new LinkedList<Serializable>();
            this.propertyFragmentTables = new HashMap<String, Table>();
            this.fragJoinCount = 0;
            switch (docKind) {
                case DIRECT: {
                    this.dataHierTable = this.hierTable = hier;
                    hierId = this.hierTable.getColumn("id").getFullQuotedName();
                    from = this.hierTable.getQuotedName();
                    this.proxyTable = null;
                    break;
                }
                case PROXY: {
                    this.hierTable = new TableAlias(hier, TABLE_HIER_ALIAS);
                    this.dataHierTable = hier;
                    from = hier.getQuotedName() + " " + this.hierTable.getQuotedName();
                    hierId = this.hierTable.getColumn("id").getFullQuotedName();
                    this.proxyTable = this.database.getTable("proxies");
                    this.addJoin(1, null, this.proxyTable, "id", this.hierTable, "id", null, -1, null);
                    this.addJoin(1, null, this.dataHierTable, "id", this.proxyTable, "targetid", null, -1, null);
                    break;
                }
                default: {
                    throw new AssertionError((Object)docKind);
                }
            }
            this.fixInitialJoins();
            WhereBuilder whereBuilder = this.newWhereBuilder(docKind == DocKind.PROXY);
            selectClause.accept((IVisitor)whereBuilder);
            whatColumns = whereBuilder.whatColumns;
            whatKeys = whereBuilder.whatKeys;
            if (queryAnalyzer.wherePredicate != null) {
                queryAnalyzer.wherePredicate.accept((IVisitor)whereBuilder);
                String where = whereBuilder.sb.toString();
                if (where.length() != 0) {
                    this.whereClauses.add(where);
                }
            }
            ArrayList<CallSite> whatNames = new ArrayList<CallSite>(1);
            ArrayList<String> whatNamesParams = new ArrayList<String>(1);
            Object mainAlias = hierId;
            this.aliasesByName.clear();
            this.aliases.clear();
            for (int i = 0; i < whatColumns.size(); ++i) {
                String whatName;
                Object alias;
                Column col = (Column)whatColumns.get(i);
                String key = (String)whatKeys.get(i);
                if ("ecm:fulltextScore".equals(key)) {
                    Dialect.FulltextMatchInfo ftMatchInfo = whereBuilder.ftMatchInfo;
                    if (ftMatchInfo == null) {
                        throw new QueryParseException("ecm:fulltextScore cannot be used without ecm:fulltext");
                    }
                    alias = ftMatchInfo.scoreAlias;
                    whatName = ftMatchInfo.scoreExpr;
                    if (ftMatchInfo.scoreExprParam != null) {
                        whatNamesParams.add(ftMatchInfo.scoreExprParam);
                    }
                } else {
                    alias = this.dialect.openQuote() + COL_ALIAS_PREFIX + (i + 1) + this.dialect.closeQuote();
                    whatName = this.getSelectColName(col, key);
                    if (col.getTable().getRealTable() == hier && col.getKey().equals("id")) {
                        mainAlias = alias;
                    }
                }
                this.aliasesByName.put(key, (String)alias);
                this.aliases.add((String)alias);
                whatNames.add((CallSite)((Object)(whatName + " AS " + (String)alias)));
            }
            this.fixWhatColumns(whatColumns);
            if (orderBy == null) {
                if (hasSelectCollection) {
                    if (sqlQuery.orderBy == null) {
                        sqlQuery.orderBy = new OrderByClause(new OrderByList());
                    }
                    sqlQuery.orderBy.elements.add((Object)new OrderByExpr(new Reference("ecm:uuid"), false));
                }
                if (sqlQuery.orderBy != null) {
                    whereBuilder.aliasOrderByColumns = doUnion;
                    whereBuilder.sb.setLength(0);
                    sqlQuery.orderBy.accept((IVisitor)whereBuilder);
                    if (hasSelectCollection) {
                        whereBuilder.visitOrderByPosColumns();
                    }
                    orderBy = whereBuilder.sb.toString();
                }
            }
            Object selectWhat = StringUtils.join(whatNames, (String)", ");
            if (!doUnion && distinct) {
                selectWhat = "DISTINCT " + (String)selectWhat;
            }
            if (model.getRepositoryDescriptor().getSoftDeleteEnabled()) {
                this.whereClauses.add(this.hierTable.getColumn("isdeleted").getFullQuotedName() + " IS NULL");
            }
            String securityClause = null;
            LinkedList<Object[]> securityParams = new LinkedList<Object[]>();
            ArrayList<Join> securityJoins = new ArrayList<Join>(2);
            if (queryFilter.getPrincipals() != null) {
                Object object;
                Object principals = queryFilter.getPrincipals();
                Object permissions = queryFilter.getPermissions();
                if (!this.dialect.supportsArrays()) {
                    principals = StringUtils.join((Object[])principals, (String)"|");
                    permissions = StringUtils.join((Object[])permissions, (String)"|");
                }
                Object object2 = object = this.dialect.supportsWith() ? mainAlias : hierId;
                if (this.dialect.supportsReadAcl()) {
                    String racl = this.dialect.openQuote() + READ_ACL_ALIAS + this.dialect.closeQuote();
                    String aclrum = this.dialect.openQuote() + READ_ACL_USER_MAP_ALIAS + this.dialect.closeQuote();
                    securityJoins.add(new Join(1, "hierarchy_read_acl", READ_ACL_ALIAS, null, (String)object, (String)racl + ".id"));
                    securityJoins.add(new Join(1, "aclr_user_map", READ_ACL_USER_MAP_ALIAS, null, (String)racl + ".acl_id", aclrum + ".acl_id"));
                    securityClause = this.dialect.getReadAclsCheckSql(aclrum + ".user_id");
                    securityParams.add((Object[])principals);
                } else {
                    securityClause = this.dialect.getSecurityCheckSql((String)object);
                    securityParams.add((Object[])principals);
                    securityParams.add((Object[])permissions);
                }
            }
            if (securityClause != null) {
                if (this.dialect.supportsWith()) {
                    void var44_56;
                    String withTable = this.dialect.openQuote() + WITH_ALIAS_PREFIX + (statements.size() + 1) + this.dialect.closeQuote();
                    withTables.add((CallSite)((Object)withTable));
                    Select withSelect = new Select(null);
                    withSelect.setWhat("*");
                    String string = withTable;
                    for (Join j : securityJoins) {
                        String string2 = (String)var44_56 + j.toSql(this.dialect);
                    }
                    withSelect.setFrom((String)var44_56);
                    withSelect.setWhere(securityClause);
                    withSelects.add(withSelect);
                    withSelectsStatements.add(withSelect.getStatement());
                    withParams.addAll(securityParams);
                } else {
                    this.joins.addAll(securityJoins);
                    this.whereClauses.add(securityClause);
                    this.whereParams.addAll(securityParams);
                }
            }
            select = new Select(null);
            select.setWhat((String)selectWhat);
            selectParams.addAll(whatNamesParams);
            StringBuilder fromb = new StringBuilder((String)from);
            if (this.dialect.needsOracleJoins() && doUnion && !securityJoins.isEmpty() && queryAnalyzer.ftCount != 0) {
                for (Join join : this.joins) {
                    if (join.whereClauses.isEmpty()) continue;
                    throw new QueryParseException("Query too complex for Oracle (NXP-5410)");
                }
                LinkedList<Object> joinClauses = new LinkedList<Object>();
                for (Join join : this.joins) {
                    fromb.append(", ");
                    fromb.append(join.getTable(this.dialect));
                    if (join.tableParam != null) {
                        selectParams.add((Serializable)((Object)join.tableParam));
                    }
                    Object joinClause = join.getClause(this.dialect);
                    if (join.kind == 2) {
                        joinClause = (String)joinClause + "(+)";
                    }
                    if (!join.whereClauses.isEmpty()) {
                        joinClause = (String)joinClause + " AND " + StringUtils.join(join.whereClauses, (String)" AND ");
                        selectParams.addAll(join.whereParams);
                    }
                    joinClauses.add(joinClause);
                }
                this.whereClauses.addAll(0, joinClauses);
            } else {
                Collections.sort(this.joins);
                for (Join join : this.joins) {
                    if (join.tableParam != null) {
                        selectParams.add((Serializable)((Object)join.tableParam));
                    }
                    Object joinClause = join.toSql(this.dialect);
                    if (!join.whereClauses.isEmpty()) {
                        joinClause = (String)joinClause + " AND " + StringUtils.join(join.whereClauses, (String)" AND ");
                        selectParams.addAll(join.whereParams);
                    }
                    fromb.append((String)joinClause);
                }
            }
            select.setFrom(fromb.toString());
            select.setWhere(StringUtils.join(this.whereClauses, (String)" AND "));
            selectParams.addAll(this.whereParams);
            statements.add(select.getStatement());
        }
        if (doUnion) {
            Object subselect;
            select = new Select(null);
            Object selectWhat = StringUtils.join(this.aliases, (String)", ");
            if (distinct) {
                selectWhat = "DISTINCT " + (String)selectWhat;
            }
            select.setWhat((String)selectWhat);
            if (withSelects.isEmpty()) {
                subselect = StringUtils.join(statements, (String)" UNION ALL ");
            } else {
                StringBuilder with = new StringBuilder("WITH ");
                for (int i = 0; i < statements.size(); ++i) {
                    if (i > 0) {
                        with.append(", ");
                    }
                    with.append((String)withTables.get(i));
                    with.append(" AS (");
                    with.append((String)statements.get(i));
                    with.append(')');
                }
                with.append(' ');
                subselect = with.toString() + StringUtils.join(withSelectsStatements, (String)" UNION ALL ");
                selectParams.addAll(withParams);
            }
            String selectFrom = "(" + (String)subselect + ")";
            if (this.dialect.needsAliasForDerivedTable()) {
                selectFrom = selectFrom + " AS " + this.dialect.openQuote() + UNION_ALIAS + this.dialect.closeQuote();
            }
            select.setFrom(selectFrom);
        } else if (!withSelects.isEmpty()) {
            select = new Select(null);
            String with = (String)withTables.get(0) + " AS (" + (String)statements.get(0) + ")";
            select.setWith(with);
            Select withSelect = (Select)withSelects.get(0);
            select.setWhat(withSelect.getWhat());
            select.setFrom(withSelect.getFrom());
            select.setWhere(withSelect.getWhere());
            selectParams.addAll(withParams);
        }
        select.setOrderBy(orderBy);
        this.fixSelect(select);
        QueryMaker.Query q = new QueryMaker.Query();
        SQLInfo.ColumnMapMaker mapMaker = new SQLInfo.ColumnMapMaker(whatColumns, whatKeys);
        q.selectInfo = new SQLInfo.SQLInfoSelect(select.getStatement(), whatColumns, mapMaker, null, null);
        q.selectParams = selectParams;
        return q;
    }

    protected void addJoin(int kind, String alias, Table table, String column, Table contextTable, String contextColumn, String name, int index, String primaryType) {
        Column column1 = contextTable.getColumn(contextColumn);
        Column column2 = table.getColumn(column);
        Join join = new Join(kind, table.getRealTable().getQuotedName(), alias, null, column1, column2);
        if (name != null) {
            String nameCol = table.getColumn("name").getFullQuotedName();
            join.addWhereClause(nameCol + " = ?", (Serializable)((Object)name));
        }
        if (index != -1) {
            String posCol = table.getColumn("pos").getFullQuotedName();
            join.addWhereClause(posCol + " = ?", Long.valueOf(index));
        }
        if (primaryType != null) {
            String typeCol = table.getColumn("primarytype").getFullQuotedName();
            join.addWhereClause(typeCol + " = ?", (Serializable)((Object)primaryType));
        }
        this.joins.add(join);
    }

    protected Table getFragmentTable(Table contextHier, String fragmentName) {
        return this.getFragmentTable(2, contextHier, fragmentName, fragmentName, "id", -1, false, null);
    }

    protected Table getFragmentTable(int joinKind, Table contextTable, String contextKey, String fragmentName, String fragmentColumn, int index, boolean skipJoin, String primaryType) {
        Table table = this.propertyFragmentTables.get(contextKey);
        if (table == null) {
            Table baseTable = this.database.getTable(fragmentName);
            String alias = TABLE_FRAG_ALIAS + ++this.fragJoinCount;
            table = new TableAlias(baseTable, alias);
            this.propertyFragmentTables.put(contextKey, table);
            if (!skipJoin) {
                this.addJoin(joinKind, alias, table, fragmentColumn, contextTable, "id", null, index, primaryType);
            }
        }
        return table;
    }

    protected void fixInitialJoins() {
    }

    protected String getSelectColName(Column col) {
        return col.getFullQuotedName();
    }

    protected String getSelectColName(Column col, String key) {
        String segment;
        String[] segments;
        String colName = this.getSelectColName(col);
        if (col.isArray() && (segments = NXQLQueryMaker.canonicalXPath(key).split("/")).length > 1 && INDEX.matcher(segment = segments[segments.length - 1]).matches() && !segment.startsWith("*")) {
            int arrayElementIndex = Integer.parseInt(segment);
            colName = this.dialect.getArrayElementString(colName, arrayElementIndex);
        }
        return colName;
    }

    protected void fixWhatColumns(List<Column> whatColumns) {
    }

    protected void fixSelect(Select select) {
    }

    protected static boolean findFulltextIndexOrField(Model model, String[] nameref) {
        boolean useIndex;
        String name = nameref[0];
        if (name.equals("ecm:fulltext")) {
            name = "default";
            useIndex = true;
        } else {
            char sep = name.charAt("ecm:fulltext".length());
            if (sep != '.' && sep != '_') {
                throw new QueryParseException("Unknown field: " + name);
            }
            useIndex = sep == '_';
            name = name.substring("ecm:fulltext".length() + 1);
            if (useIndex) {
                if (!model.getFulltextConfiguration().indexNames.contains(name)) {
                    throw new QueryParseException("No such fulltext index: " + name);
                }
            } else {
                String index = (String)model.getFulltextConfiguration().fieldToIndexName.get(name);
                if (index != null) {
                    name = index;
                    useIndex = true;
                }
            }
        }
        nameref[0] = name;
        return useIndex;
    }

    public static String canonicalXPath(String xpath) {
        while (xpath.length() > 0 && xpath.charAt(0) == '/') {
            xpath = xpath.substring(1);
        }
        if (xpath.indexOf(91) == -1) {
            return xpath;
        }
        return NON_CANON_INDEX.matcher(xpath).replaceAll("$1");
    }

    public static String simpleXPath(String xpath) {
        xpath = NXQLQueryMaker.canonicalXPath(xpath);
        return INDEX_SLASH.matcher(xpath).replaceAll("/*$1");
    }

    public boolean hasWildcardIndex(String xpath) {
        xpath = NXQLQueryMaker.canonicalXPath(xpath);
        return HAS_WILDCARD_INDEX.matcher(xpath).matches();
    }

    public boolean hasFinalWildcardIndex(String xpath) {
        xpath = NXQLQueryMaker.canonicalXPath(xpath);
        return HAS_FINAL_WILDCARD_INDEX.matcher(xpath).matches();
    }

    protected static String keyForPos(String name) {
        int i = name.lastIndexOf(47);
        if (i == -1) {
            throw new RuntimeException("Unexpected name: " + name);
        }
        return name.substring(0, i) + "#" + name.substring(i + 2);
    }

    protected QueryAnalyzer newQueryAnalyzer(FacetFilter facetFilter) {
        return new QueryAnalyzer(facetFilter);
    }

    protected static Set<String> getStringLiterals(LiteralList list) {
        HashSet<String> set = new HashSet<String>();
        for (Literal literal : list) {
            if (!(literal instanceof StringLiteral)) {
                throw new QueryParseException("requires string literals");
            }
            set.add(((StringLiteral)literal).value);
        }
        return set;
    }

    protected static Serializable getSerializableLiteral(Literal literal) {
        Object value;
        if (literal instanceof BooleanLiteral) {
            value = ((BooleanLiteral)literal).value;
        } else if (literal instanceof DateLiteral) {
            DateLiteral dLit = (DateLiteral)literal;
            value = dLit.onlyDate ? dLit.toSqlDate() : dLit.toCalendar();
        } else if (literal instanceof DoubleLiteral) {
            value = ((DoubleLiteral)literal).value;
        } else if (literal instanceof IntegerLiteral) {
            value = ((IntegerLiteral)literal).value;
        } else if (literal instanceof StringLiteral) {
            value = ((StringLiteral)literal).value;
        } else {
            throw new QueryParseException("type of literal in list is not recognized: " + literal.getClass());
        }
        return value;
    }

    protected static List<Serializable> getSerializableLiterals(LiteralList list) {
        ArrayList<Serializable> serList = new ArrayList<Serializable>(list.size());
        for (Literal literal : list) {
            serList.add(NXQLQueryMaker.getSerializableLiteral(literal));
        }
        return serList;
    }

    protected WhereBuilder newWhereBuilder(boolean isProxies) {
        return new WhereBuilder(isProxies);
    }

    protected class WhereBuilder
    extends DefaultQueryVisitor {
        public static final String PATH_SEP = "/";
        public final LinkedList<Column> whatColumns = new LinkedList();
        public final LinkedList<String> whatKeys = new LinkedList();
        public final StringBuilder sb = new StringBuilder();
        protected int uniqueJoinIndex = 0;
        protected int hierJoinCount = 0;
        protected Map<String, Table> propertyHierTables = new HashMap<String, Table>();
        protected final boolean isProxies;
        protected boolean aliasOrderByColumns;
        protected boolean allowSubSelect;
        protected boolean inSelect;
        protected boolean inOrderBy;
        protected int ftJoinNumber;
        protected Dialect.FulltextMatchInfo ftMatchInfo;
        protected boolean visitingId;
        protected Map<String, Dialect.ArraySubQuery> propertyArraySubQueries = new HashMap<String, Dialect.ArraySubQuery>();
        protected int arraySubQueryJoinCount = 0;
        protected Map<String, Column> posColumns = new LinkedHashMap<String, Column>(0);
        protected List<Column> posColumnsInOrderBy = new ArrayList<Column>();

        public WhereBuilder(boolean isProxies) {
            this.isProxies = isProxies;
        }

        protected int getUniqueJoinIndex() {
            return ++this.uniqueJoinIndex;
        }

        protected Dialect.ArraySubQuery getArraySubQuery(Table contextHier, String contextKey, Column arrayColumn, boolean skipJoin) {
            Dialect.ArraySubQuery arraySubQuery = this.propertyArraySubQueries.get(contextKey);
            if (arraySubQuery == null) {
                String alias = NXQLQueryMaker.SUBQUERY_ARRAY_ALIAS + ++this.arraySubQueryJoinCount;
                arraySubQuery = NXQLQueryMaker.this.dialect.getArraySubQuery(arrayColumn, alias);
                this.propertyArraySubQueries.put(contextKey, arraySubQuery);
                if (!skipJoin) {
                    Join join = new Join(2, arraySubQuery.toSql(), alias, null, arraySubQuery.getSubQueryIdColumn().getFullQuotedName(), contextHier.getColumn("id").getFullQuotedName());
                    NXQLQueryMaker.this.joins.add(join);
                }
            }
            return arraySubQuery;
        }

        protected ColumnInfo getSpecialColumnInfo(String name) {
            String propertyName = null;
            Table table = null;
            String fragmentKey = null;
            if ("ecm:uuid".equals(name)) {
                table = NXQLQueryMaker.this.hierTable;
                fragmentKey = "id";
            } else if ("ecm:name".equals(name)) {
                table = NXQLQueryMaker.this.hierTable;
                fragmentKey = "name";
            } else if ("ecm:pos".equals(name)) {
                table = NXQLQueryMaker.this.hierTable;
                fragmentKey = "pos";
            } else if ("ecm:parentId".equals(name)) {
                table = NXQLQueryMaker.this.hierTable;
                fragmentKey = "parentid";
            } else if ("ecm:isCheckedInVersion".equals(name) || "ecm:isVersion".equals(name)) {
                table = NXQLQueryMaker.this.hierTable;
                fragmentKey = "isversion";
            } else if ("ecm:isCheckedIn".equals(name)) {
                table = NXQLQueryMaker.this.hierTable;
                fragmentKey = "ischeckedin";
            } else if ("ecm:primaryType".equals(name)) {
                table = NXQLQueryMaker.this.dataHierTable;
                fragmentKey = "primarytype";
            } else {
                if ("ecm:mixinType".equals(name)) {
                    throw new QueryParseException("Cannot use non-toplevel " + name + " in query");
                }
                if ("ecm:isTrashed".equals(name)) {
                    table = NXQLQueryMaker.this.hierTable;
                    fragmentKey = "istrashed";
                } else if ("ecm:currentLifeCycleState".equals(name)) {
                    propertyName = "ecm:lifeCycleState";
                } else if ("ecm:versionLabel".equals(name)) {
                    propertyName = "ecm:versionLabel";
                } else if ("ecm:versionDescription".equals(name)) {
                    propertyName = "ecm:versionDescription";
                } else if ("ecm:versionCreated".equals(name)) {
                    propertyName = "ecm:versionCreated";
                } else if ("ecm:versionVersionableId".equals(name)) {
                    propertyName = "ecm:versionableId";
                } else if ("ecm:isLatestVersion".equals(name)) {
                    propertyName = "ecm:isLatestVersion";
                } else if ("ecm:isLatestMajorVersion".equals(name)) {
                    propertyName = "ecm:isLatestMajorVersion";
                } else if ("ecm:lockOwner".equals(name)) {
                    propertyName = "ecm:lockOwner";
                } else if ("ecm:lockCreated".equals(name)) {
                    propertyName = "ecm:lockCreated";
                } else if ("ecm:proxyTargetId".equals(name)) {
                    table = NXQLQueryMaker.this.proxyTable;
                    fragmentKey = "targetid";
                } else if ("ecm:proxyVersionableId".equals(name)) {
                    table = NXQLQueryMaker.this.proxyTable;
                    fragmentKey = "versionableid";
                } else if ("ecm:fulltextJobId".equals(name)) {
                    propertyName = "ecm:fulltextJobId";
                } else {
                    if ("ecm:fulltextScore".equals(name)) {
                        throw new QueryParseException("ecm:fulltextScore cannot be used in WHERE clause");
                    }
                    if (name.startsWith("ecm:fulltext")) {
                        throw new QueryParseException("ecm:fulltext must be used as left-hand operand");
                    }
                    if ("ecm:tag".equals(name) || name.startsWith(NXQLQueryMaker.ECM_TAG_STAR)) {
                        Object suffix;
                        MigrationService.MigrationStatus status = ((MigrationService)Framework.getService(MigrationService.class)).getStatus("tag-storage");
                        boolean facetedTag = "facets".equals(status.getState());
                        if (facetedTag) {
                            Object newName = "nxtag:tags/*";
                            newName = name.startsWith(NXQLQueryMaker.ECM_TAG_STAR) ? (String)newName + name.substring(NXQLQueryMaker.ECM_TAG_STAR.length()) + "/label" : (String)newName + "1/label";
                            return this.getRegularColumnInfo((String)newName);
                        }
                        suffix = name.startsWith(NXQLQueryMaker.ECM_TAG_STAR) ? (((String)(suffix = name.substring(NXQLQueryMaker.ECM_TAG_STAR.length()))).isEmpty() ? "/*-" + this.getUniqueJoinIndex() : "/*" + (String)suffix) : "";
                        String relContextKey = "_tag_relation" + (String)suffix;
                        Table rel = NXQLQueryMaker.this.getFragmentTable(1, NXQLQueryMaker.this.dataHierTable, relContextKey, NXQLQueryMaker.RELATION_TABLE, "source", -1, false, null);
                        String fragmentName = "hierarchy";
                        fragmentKey = "name";
                        String hierContextKey = "_tag_hierarchy" + (String)suffix;
                        table = NXQLQueryMaker.this.getFragmentTable(1, rel, hierContextKey, fragmentName, "id", -1, false, NXQLQueryMaker.TYPE_TAGGING);
                    } else {
                        if (name.startsWith("ecm:acl")) {
                            int i = name.indexOf(47);
                            int j = name.lastIndexOf(47);
                            String index = name.substring(i + 1, j);
                            String suffix = name.substring(j + 1);
                            String newName = "ecm:acl." + suffix + PATH_SEP + index;
                            return this.getRegularColumnInfo(newName);
                        }
                        throw new QueryParseException("No such property: " + name);
                    }
                }
            }
            if (table == null) {
                ModelProperty propertyInfo = NXQLQueryMaker.this.model.getPropertyInfo(propertyName);
                String fragmentName = propertyInfo.fragmentName;
                fragmentKey = propertyInfo.fragmentKey;
                table = fragmentName.equals("hierarchy") ? NXQLQueryMaker.this.dataHierTable : NXQLQueryMaker.this.getFragmentTable(NXQLQueryMaker.this.dataHierTable, fragmentName);
            }
            Column column = table.getColumn(fragmentKey);
            return new ColumnInfo(column, null, -1, false, false);
        }

        public ColumnInfo getColumnInfo(String name) {
            if (name.startsWith("ecm:")) {
                return this.getSpecialColumnInfo(name);
            }
            return this.getRegularColumnInfo(name);
        }

        protected ColumnInfo getRegularColumnInfo(String xpath) {
            Table contextHier = NXQLQueryMaker.this.model.isProxySchemaPath(xpath) ? (NXQLQueryMaker.this.proxyTable != null ? NXQLQueryMaker.this.hierTable : NXQLQueryMaker.this.dataHierTable) : NXQLQueryMaker.this.dataHierTable;
            xpath = NXQLQueryMaker.canonicalXPath(xpath);
            String[] segments = xpath.split(PATH_SEP);
            Object simple = null;
            String contextKey = null;
            for (int i = 0; i < segments.length; ++i) {
                Table table;
                ModelProperty prop;
                String next;
                String segment = segments[i];
                simple = simple == null ? segment : (String)simple + PATH_SEP + segment;
                Object contextStart = contextKey == null ? "" : contextKey + PATH_SEP;
                Object contextSuffix = "";
                int index = -1;
                boolean star = false;
                boolean isArrayElement = false;
                if (i < segments.length - 1 && INDEX.matcher(next = segments[i + 1]).matches()) {
                    isArrayElement = true;
                    if (next.startsWith("*")) {
                        star = true;
                        next = next.substring(1);
                    }
                    if (!next.isEmpty()) {
                        index = Integer.parseInt(next);
                    }
                    ++i;
                    simple = (String)simple + "/*";
                    if (star) {
                        contextSuffix = index == -1 ? "/*-" + this.getUniqueJoinIndex() : "/*" + index;
                        index = -1;
                    } else {
                        contextSuffix = PATH_SEP + index;
                    }
                }
                if ((prop = NXQLQueryMaker.this.model.getPathPropertyInfo((String)simple)) == null) {
                    throw new QueryParseException("No such property: " + xpath);
                }
                if (i < segments.length - 1) {
                    if (!prop.isIntermediateSegment()) {
                        throw new QueryParseException("No such property: " + xpath);
                    }
                    segment = prop.getIntermediateSegment();
                    contextKey = (String)contextStart + segment + (String)contextSuffix;
                    table = this.propertyHierTables.get(contextKey);
                    if (table == null) {
                        String alias = NXQLQueryMaker.TABLE_HIER_ALIAS + ++this.hierJoinCount;
                        table = new TableAlias(NXQLQueryMaker.this.dataHierTable, alias);
                        this.propertyHierTables.put(contextKey, table);
                        NXQLQueryMaker.this.addJoin(2, alias, table, "parentid", contextHier, "id", segment, index, null);
                    }
                } else {
                    if (prop.isIntermediateSegment()) {
                        throw new QueryParseException("No such property: " + xpath);
                    }
                    table = NXQLQueryMaker.this.database.getTable(prop.fragmentName);
                    Column column = table.getColumn(prop.fragmentKey);
                    boolean skipJoin = !isArrayElement && prop.propertyType.isArray() && !column.isArray();
                    Column posColumn = null;
                    if (column.isArray() && star) {
                        contextKey = (String)contextStart + segment + (String)contextSuffix;
                        Dialect.ArraySubQuery arraySubQuery = this.getArraySubQuery(contextHier, contextKey, column, skipJoin);
                        column = arraySubQuery.getSubQueryValueColumn();
                    } else {
                        contextKey = (String)contextStart + prop.fragmentName + (String)contextSuffix;
                        int joinKind = NXQLQueryMaker.this.selectCollectionNotNull.contains(xpath) ? 1 : 2;
                        table = NXQLQueryMaker.this.getFragmentTable(joinKind, contextHier, contextKey, prop.fragmentName, "id", column.isArray() ? -1 : index, skipJoin, null);
                        column = table.getColumn(prop.fragmentKey);
                        if (star) {
                            posColumn = table.getColumn("pos");
                            this.posColumns.put(NXQLQueryMaker.keyForPos(xpath), posColumn);
                        }
                    }
                    return new ColumnInfo(column, posColumn, column.isArray() ? index : -1, isArrayElement, prop.propertyType.isArray());
                }
                contextHier = table;
            }
            throw new AssertionError((Object)"not reached");
        }

        public void visitQuery(SQLQuery node) {
            super.visitQuery(node);
        }

        public void visitSelectClause(SelectClause node) {
            this.inSelect = true;
            super.visitSelectClause(node);
            this.inSelect = false;
        }

        public void visitMultiExpression(MultiExpression node) {
            this.sb.append('(');
            Iterator it = node.predicates.iterator();
            while (it.hasNext()) {
                ((Predicate)it.next()).accept((IVisitor)this);
                if (!it.hasNext()) continue;
                node.operator.accept((IVisitor)this);
            }
            this.sb.append(')');
        }

        public void visitExpression(Expression node) {
            Operator op;
            this.sb.append('(');
            Reference ref = node.lvalue instanceof Reference ? (Reference)node.lvalue : null;
            String name = ref != null ? ref.name : null;
            String cast = ref != null ? ref.cast : null;
            Operand rvalue = node.rvalue;
            if (NXQLQueryMaker.DATE_CAST.equals(cast)) {
                this.checkDateLiteralForCast(rvalue, node);
            }
            if ((op = node.operator) == Operator.STARTSWITH) {
                this.visitExpressionStartsWith(node);
            } else if ("ecm:path".equals(name)) {
                this.visitExpressionEcmPath(node);
            } else if ("ecm:ancestorId".equals(name)) {
                this.visitExpressionAncestorId(node);
            } else if ("ecm:isProxy".equals(name)) {
                this.visitExpressionIsProxy(node);
            } else if ("ecm:isCheckedInVersion".equals(name) || "ecm:isVersion".equals(name)) {
                this.visitExpressionWhereFalseIsNull(node);
            } else if ("ecm:isCheckedIn".equals(name) || "ecm:isLatestVersion".equals(name) || "ecm:isLatestMajorVersion".equals(name)) {
                this.visitExpressionWhereFalseMayBeNull(node);
            } else if ("ecm:isTrashed".equals(name)) {
                this.visitExpressionIsTrashed(node);
            } else if ("ecm:mixinType".equals(name)) {
                this.visitExpressionMixinType(node);
            } else if (name != null && name.startsWith("ecm:fulltext") && !"ecm:fulltextJobId".equals(name)) {
                this.visitExpressionFulltext(node, name);
            } else if (op == Operator.EQ || op == Operator.NOTEQ || op == Operator.IN || op == Operator.NOTIN || op == Operator.LIKE || op == Operator.NOTLIKE || op == Operator.ILIKE || op == Operator.NOTILIKE) {
                ColumnInfo info;
                ColumnInfo columnInfo = info = name == null ? null : this.getColumnInfo(name);
                if (info != null && info.needsSubSelect) {
                    Operator directOp;
                    boolean direct;
                    boolean bl = direct = op == Operator.EQ || op == Operator.IN || op == Operator.LIKE || op == Operator.ILIKE;
                    Operator operator = direct ? op : (op == Operator.NOTEQ ? Operator.EQ : (op == Operator.NOTIN ? Operator.IN : (directOp = op == Operator.NOTLIKE ? Operator.LIKE : Operator.ILIKE)));
                    if (!direct) {
                        this.sb.append("NOT ");
                    }
                    this.generateExistsStart(this.sb, info.column.getTable());
                    this.allowSubSelect = true;
                    this.visitColumnExpression(info.column, directOp, rvalue, cast, name, info.arrayElementIndex);
                    this.allowSubSelect = false;
                    this.generateExistsEnd(this.sb);
                } else if (info != null) {
                    if (info.column.getType() == ColumnType.BOOLEAN) {
                        rvalue = this.getBooleanLiteral(rvalue);
                    }
                    this.visitColumnExpression(info.column, op, rvalue, cast, name, info.arrayElementIndex);
                } else {
                    super.visitExpression(node);
                }
            } else if (op == Operator.BETWEEN || op == Operator.NOTBETWEEN) {
                LiteralList l = (LiteralList)rvalue;
                if (NXQLQueryMaker.DATE_CAST.equals(cast)) {
                    this.checkDateLiteralForCast((Operand)l.get(0), node);
                    this.checkDateLiteralForCast((Operand)l.get(1), node);
                }
                node.lvalue.accept((IVisitor)this);
                this.sb.append(' ');
                op.accept((IVisitor)this);
                this.sb.append(' ');
                ((Literal)l.get(0)).accept((IVisitor)this);
                this.sb.append(" AND ");
                ((Literal)l.get(1)).accept((IVisitor)this);
            } else {
                super.visitExpression(node);
            }
            this.sb.append(')');
        }

        protected Operand getBooleanLiteral(Operand rvalue) {
            if (!(rvalue instanceof IntegerLiteral)) {
                throw new QueryParseException("Boolean expressions require literal 0 or 1 as right argument");
            }
            long v = ((IntegerLiteral)rvalue).value;
            if (v != 0L && v != 1L) {
                throw new QueryParseException("Boolean expressions require literal 0 or 1 as right argument");
            }
            return new BooleanLiteral(v == 1L);
        }

        protected void visitColumnExpression(Column column, Operator op, Operand rvalue, String cast, String lvalueName, int arrayElementIndex) {
            if (op == Operator.EQ || op == Operator.NOTEQ || op == Operator.IN || op == Operator.NOTIN) {
                this.visitExpressionEqOrIn(column, op, rvalue, cast, arrayElementIndex);
            } else if (op == Operator.LIKE || op == Operator.NOTLIKE) {
                this.visitExpressionLike(column, op, rvalue, lvalueName, arrayElementIndex);
            } else if (op == Operator.ILIKE || op == Operator.NOTILIKE) {
                this.visitExpressionIlike(column, op, rvalue, lvalueName, arrayElementIndex);
            } else {
                this.visitSimpleExpression(column, op, rvalue, cast, -1);
            }
        }

        protected void visitSimpleExpression(Column column, Operator op, Operand rvalue, String cast, int arrayElementIndex) {
            this.visitReference(column, cast, arrayElementIndex);
            op.accept((IVisitor)this);
            boolean oldVisitingId = this.visitingId;
            this.visitingId = column.getType().isId();
            rvalue.accept((IVisitor)this);
            this.visitingId = oldVisitingId;
        }

        protected void checkDateLiteralForCast(Operand value, Expression node) {
            if (value instanceof DateLiteral && !((DateLiteral)value).onlyDate) {
                throw new QueryParseException("DATE() cast must be used with DATE literal, not TIMESTAMP: " + node);
            }
        }

        protected void generateExistsStart(StringBuilder sb, Table table) {
            Object tableName = table.isAlias() ? table.getRealTable().getQuotedName() + " " + table.getQuotedName() : table.getQuotedName();
            sb.append(String.format("EXISTS (SELECT 1 FROM %s WHERE %s = %s AND ", tableName, NXQLQueryMaker.this.dataHierTable.getColumn("id").getFullQuotedName(), table.getColumn("id").getFullQuotedName()));
        }

        protected void generateExistsEnd(StringBuilder sb) {
            sb.append(")");
        }

        protected void visitExpressionStartsWith(Expression node) {
            String name;
            if (!(node.lvalue instanceof Reference)) {
                throw new QueryParseException("Illegal left argument for " + Operator.STARTSWITH + ": " + node.lvalue);
            }
            if (!(node.rvalue instanceof StringLiteral)) {
                throw new QueryParseException(Operator.STARTSWITH + " requires literal path as right argument");
            }
            String path = ((StringLiteral)node.rvalue).value;
            if (path.length() > 1 && path.endsWith(PATH_SEP)) {
                path = path.substring(0, path.length() - PATH_SEP.length());
            }
            if ("ecm:path".equals(name = ((Reference)node.lvalue).name)) {
                this.visitExpressionStartsWithPath(path);
            } else {
                this.visitExpressionStartsWithNonPath(node, path);
            }
        }

        protected void visitExpressionStartsWithPath(String path) {
            Serializable id = NXQLQueryMaker.this.pathResolver.getIdForPath(path);
            if (id == null) {
                this.sb.append("0=1");
            } else {
                this.sb.append(NXQLQueryMaker.this.dialect.getInTreeSql(NXQLQueryMaker.this.hierTable.getColumn("id").getFullQuotedName(), null));
                NXQLQueryMaker.this.whereParams.add(id);
            }
        }

        protected void visitExpressionStartsWithNonPath(Expression node, String path) {
            String name = ((Reference)node.lvalue).name;
            ColumnInfo info = this.getColumnInfo(name);
            if (info.needsSubSelect) {
                this.generateExistsStart(this.sb, info.column.getTable());
            }
            this.sb.append('(');
            this.visitExpressionEqOrIn(info.column, Operator.EQ, (Operand)new StringLiteral(path), null, -1);
            this.visitOperator(Operator.OR);
            this.visitExpressionLike(info.column, Operator.LIKE, (Operand)new StringLiteral(path + "/%"), name, -1);
            this.sb.append(')');
            if (info.needsSubSelect) {
                this.generateExistsEnd(this.sb);
            }
        }

        protected void visitExpressionEcmPath(Expression node) {
            Serializable id;
            if (node.operator != Operator.EQ && node.operator != Operator.NOTEQ) {
                throw new QueryParseException("ecm:path requires = or <> operator");
            }
            if (!(node.rvalue instanceof StringLiteral)) {
                throw new QueryParseException("ecm:path requires literal path as right argument");
            }
            String path = ((StringLiteral)node.rvalue).value;
            if (path.length() > 1 && path.endsWith(PATH_SEP)) {
                path = path.substring(0, path.length() - PATH_SEP.length());
            }
            if ((id = NXQLQueryMaker.this.pathResolver.getIdForPath(path)) == null) {
                this.sb.append("0=1");
            } else {
                this.visitReference(NXQLQueryMaker.this.hierTable.getColumn("id"));
                this.visitOperator(node.operator);
                this.visitId(NXQLQueryMaker.this.model.idToString(id));
            }
        }

        protected void visitExpressionAncestorId(Expression node) {
            String sql;
            if (node.operator != Operator.EQ && node.operator != Operator.NOTEQ) {
                throw new QueryParseException("ecm:ancestorId requires = or <> operator");
            }
            if (!(node.rvalue instanceof StringLiteral)) {
                throw new QueryParseException("ecm:ancestorId requires literal id as right argument");
            }
            boolean not = node.operator == Operator.NOTEQ;
            String id = ((StringLiteral)node.rvalue).value;
            if (not) {
                this.sb.append("(NOT (");
            }
            if ((sql = NXQLQueryMaker.this.dialect.getInTreeSql(NXQLQueryMaker.this.hierTable.getColumn("id").getFullQuotedName(), id)) == null) {
                this.sb.append("0=1");
            } else {
                this.sb.append(sql);
                NXQLQueryMaker.this.whereParams.add((Serializable)((Object)id));
            }
            if (not) {
                this.sb.append("))");
            }
        }

        protected void visitExpressionIsProxy(Expression node) {
            boolean bool = this.getBooleanRValue("ecm:isProxy", node);
            this.sb.append(this.isProxies == bool ? "1=1" : "0=1");
        }

        protected void visitExpressionWhereFalseIsNull(Expression node) {
            String name = ((Reference)node.lvalue).name;
            boolean bool = this.getBooleanRValue(name, node);
            node.lvalue.accept((IVisitor)this);
            if (bool) {
                this.sb.append(" = ");
                this.sb.append(NXQLQueryMaker.this.dialect.toBooleanValueString(true));
            } else {
                this.sb.append(" IS NULL");
            }
        }

        protected void visitExpressionWhereFalseMayBeNull(Expression node) {
            String name = ((Reference)node.lvalue).name;
            boolean bool = this.getBooleanRValue(name, node);
            if (bool) {
                node.lvalue.accept((IVisitor)this);
                this.sb.append(" = ");
                this.sb.append(NXQLQueryMaker.this.dialect.toBooleanValueString(true));
            } else {
                this.sb.append('(');
                node.lvalue.accept((IVisitor)this);
                this.sb.append(" = ");
                this.sb.append(NXQLQueryMaker.this.dialect.toBooleanValueString(false));
                this.sb.append(" OR ");
                node.lvalue.accept((IVisitor)this);
                this.sb.append(" IS NULL)");
            }
        }

        protected void visitExpressionIsTrashed(Expression node) {
            TrashService trashService = (TrashService)Framework.getService(TrashService.class);
            if (trashService.hasFeature(TrashService.Feature.TRASHED_STATE_IS_DEDUCED_FROM_LIFECYCLE)) {
                this.visitExpressionIsTrashedOnLifeCycle(node);
            } else if (trashService.hasFeature(TrashService.Feature.TRASHED_STATE_IN_MIGRATION)) {
                this.visitExpressionIsTrashedOnLifeCycle(node);
                this.sb.append(" OR ");
                this.visitExpressionWhereFalseMayBeNull(node);
            } else if (trashService.hasFeature(TrashService.Feature.TRASHED_STATE_IS_DEDICATED_PROPERTY)) {
                this.visitExpressionWhereFalseMayBeNull(node);
            } else {
                throw new UnsupportedOperationException("TrashService is in an unknown state");
            }
        }

        protected void visitExpressionIsTrashedOnLifeCycle(Expression node) {
            String name = ((Reference)node.lvalue).name;
            boolean bool = this.getBooleanRValue(name, node);
            Operator op = bool ? Operator.EQ : Operator.NOTEQ;
            this.visitReference(new Reference("ecm:currentLifeCycleState"));
            this.visitOperator(op);
            this.visitStringLiteral("deleted");
        }

        private boolean getBooleanRValue(String name, Expression node) {
            long v;
            if (node.operator != Operator.EQ && node.operator != Operator.NOTEQ) {
                throw new QueryParseException(name + " requires = or <> operator");
            }
            if (!(node.rvalue instanceof IntegerLiteral) || (v = ((IntegerLiteral)node.rvalue).value) != 0L && v != 1L) {
                throw new QueryParseException(name + " requires literal 0 or 1 as right argument");
            }
            return node.operator == Operator.EQ ^ v == 0L;
        }

        protected void visitExpressionMixinType(Expression expr) {
            HashSet<Object> types;
            Set<String> mixins;
            boolean include;
            Operator op = expr.operator;
            if (op == Operator.EQ || op == Operator.NOTEQ) {
                boolean bl = include = op == Operator.EQ;
                if (!(expr.rvalue instanceof StringLiteral)) {
                    throw new QueryParseException("ecm:mixinType = requires literal string as right argument");
                }
                String value = ((StringLiteral)expr.rvalue).value;
                mixins = Collections.singleton(value);
            } else if (op == Operator.IN || op == Operator.NOTIN) {
                boolean bl = include = op == Operator.IN;
                if (!(expr.rvalue instanceof LiteralList)) {
                    throw new QueryParseException("ecm:mixinType = requires string list as right argument");
                }
                mixins = NXQLQueryMaker.getStringLiterals((LiteralList)expr.rvalue);
            } else {
                throw new QueryParseException("ecm:mixinType unknown operator: " + op);
            }
            if (include) {
                types = new HashSet();
                for (String string : mixins) {
                    types.addAll(NXQLQueryMaker.this.model.getMixinDocumentTypes(string));
                }
            } else {
                types = new HashSet<String>(NXQLQueryMaker.this.model.getDocumentTypes());
                for (String string : mixins) {
                    types.removeAll(NXQLQueryMaker.this.model.getMixinDocumentTypes(string));
                }
            }
            HashSet<String> instanceMixins = new HashSet<String>();
            for (String mixin : mixins) {
                if (NXQLQueryMaker.this.neverPerInstanceMixins.contains(mixin)) continue;
                instanceMixins.add(mixin);
            }
            if (!types.isEmpty()) {
                Column column = NXQLQueryMaker.this.dataHierTable.getColumn("primarytype");
                this.visitReference(column);
                this.sb.append(" IN ");
                this.sb.append('(');
                Iterator it = types.iterator();
                while (it.hasNext()) {
                    this.visitStringLiteral((String)it.next());
                    if (!it.hasNext()) continue;
                    this.sb.append(", ");
                }
                this.sb.append(')');
                if (!instanceMixins.isEmpty()) {
                    this.sb.append(include ? " OR " : " AND ");
                }
            }
            if (!instanceMixins.isEmpty()) {
                this.sb.append('(');
                Column column = NXQLQueryMaker.this.dataHierTable.getColumn("mixintypes");
                String[] returnParam = new String[1];
                Iterator it = instanceMixins.iterator();
                while (it.hasNext()) {
                    String mixin = (String)it.next();
                    String sql = NXQLQueryMaker.this.dialect.getMatchMixinType(column, mixin, include, returnParam);
                    this.sb.append(sql);
                    if (returnParam[0] != null) {
                        NXQLQueryMaker.this.whereParams.add((Serializable)((Object)returnParam[0]));
                    }
                    if (!it.hasNext()) continue;
                    this.sb.append(include ? " OR " : " AND ");
                }
                if (!include) {
                    this.sb.append(" OR ");
                    this.visitReference(column);
                    this.sb.append(" IS NULL");
                }
                this.sb.append(')');
            }
            if (types.isEmpty() && instanceMixins.isEmpty()) {
                this.sb.append(include ? "0=1" : "0=0");
            }
        }

        protected void visitExpressionFulltext(Expression node, String name) {
            String[] nameref = new String[]{name};
            boolean useIndex = NXQLQueryMaker.findFulltextIndexOrField(NXQLQueryMaker.this.model, nameref);
            name = nameref[0];
            if (useIndex) {
                Dialect.FulltextMatchInfo info;
                String fulltextQuery = ((StringLiteral)node.rvalue).value;
                fulltextQuery = NXQLQueryMaker.this.dialect.getDialectFulltextQuery(fulltextQuery);
                ++this.ftJoinNumber;
                Column mainColumn = NXQLQueryMaker.this.dataHierTable.getColumn("id");
                this.ftMatchInfo = info = NXQLQueryMaker.this.dialect.getFulltextScoredMatchInfo(fulltextQuery, name, this.ftJoinNumber, mainColumn, NXQLQueryMaker.this.model, NXQLQueryMaker.this.database);
                if (info.joins != null) {
                    NXQLQueryMaker.this.joins.addAll(info.joins);
                }
                this.sb.append(info.whereExpr);
                if (info.whereExprParam != null) {
                    NXQLQueryMaker.this.whereParams.add((Serializable)((Object)info.whereExprParam));
                }
            } else {
                log.warn((Object)("No fulltext index configured for field " + name + ", falling back on LIKE query"));
                Object value = ((StringLiteral)node.rvalue).value;
                Set words = FullTextUtils.parseFullText((String)value, (boolean)false);
                value = words.isEmpty() ? "DONTMATCHANYTHINGFOREMPTYQUERY" : "%" + StringUtils.join(new ArrayList(words), (String)"%") + "%";
                Reference ref = new Reference(name);
                if (NXQLQueryMaker.this.dialect.supportsIlike()) {
                    this.visitReference(ref);
                    this.sb.append(" ILIKE ");
                    this.visitStringLiteral((String)value);
                } else {
                    this.sb.append("LOWER(");
                    this.visitReference(ref);
                    this.sb.append(") LIKE ");
                    this.visitStringLiteral((String)value);
                }
            }
        }

        protected void visitExpressionEqOrIn(Column column, Operator op, Operand rvalue, String cast, int arrayElementIndex) {
            if (column.isArray() && arrayElementIndex == -1) {
                List<Serializable> params;
                if (rvalue instanceof Literal) {
                    Serializable param = NXQLQueryMaker.getSerializableLiteral((Literal)rvalue);
                    params = Collections.singletonList(param);
                } else {
                    params = NXQLQueryMaker.getSerializableLiterals((LiteralList)rvalue);
                }
                boolean positive = op == Operator.EQ || op == Operator.IN;
                String sql = NXQLQueryMaker.this.dialect.getArrayInSql(column, cast, positive, params);
                this.sb.append(sql);
                NXQLQueryMaker.this.whereParams.addAll(params);
            } else {
                this.visitSimpleExpression(column, op, rvalue, cast, arrayElementIndex);
            }
        }

        protected void visitExpressionLike(Column column, Operator op, Operand rvalue, String lvalueName, int arrayElementIndex) {
            if (column.isArray() && arrayElementIndex == -1) {
                if (lvalueName == null) {
                    throw new AssertionError((Object)"Name is required when lvalue is an array");
                }
                boolean positive = op == Operator.LIKE;
                String sql = NXQLQueryMaker.this.dialect.getArrayLikeSql(column, lvalueName, positive, NXQLQueryMaker.this.dataHierTable);
                this.sb.append(sql);
                NXQLQueryMaker.this.whereParams.add(NXQLQueryMaker.getSerializableLiteral((Literal)rvalue));
            } else {
                this.visitSimpleExpression(column, op, rvalue, null, arrayElementIndex);
                this.addLikeEscaping();
            }
        }

        protected void visitExpressionIlike(Column column, Operator op, Operand rvalue, String lvalueName, int arrayElementIndex) {
            if (column.isArray() && arrayElementIndex == -1) {
                if (lvalueName == null) {
                    throw new AssertionError((Object)"Name is required when lvalue is an array");
                }
                boolean positive = op == Operator.ILIKE;
                String sql = NXQLQueryMaker.this.dialect.getArrayIlikeSql(column, lvalueName, positive, NXQLQueryMaker.this.dataHierTable);
                this.sb.append(sql);
                NXQLQueryMaker.this.whereParams.add(NXQLQueryMaker.getSerializableLiteral((Literal)rvalue));
            } else if (NXQLQueryMaker.this.dialect.supportsIlike()) {
                this.visitSimpleExpression(column, op, rvalue, null, arrayElementIndex);
            } else {
                this.sb.append("LOWER(");
                this.visitReference(column, arrayElementIndex);
                this.sb.append(") ");
                if (op == Operator.NOTILIKE) {
                    this.sb.append("NOT ");
                }
                this.sb.append("LIKE");
                this.sb.append(" LOWER(");
                rvalue.accept((IVisitor)this);
                this.sb.append(")");
                this.addLikeEscaping();
            }
        }

        protected void addLikeEscaping() {
            String escape = NXQLQueryMaker.this.dialect.getLikeEscaping();
            if (escape != null) {
                this.sb.append(escape);
            }
        }

        public void visitOperator(Operator node) {
            if (node != Operator.NOT) {
                this.sb.append(' ');
            }
            this.sb.append(node.toString());
            this.sb.append(' ');
        }

        public void visitReference(Reference node) {
            String name = node.name;
            if ("ecm:fulltextScore".equals(name)) {
                this.visitScore();
                return;
            }
            ColumnInfo info = this.getColumnInfo(name);
            if (info.needsSubSelect && !this.allowSubSelect) {
                String msg = this.inOrderBy ? "Cannot use collection %s in ORDER BY clause" : "Can only use collection %s with =, <>, IN or NOT IN clause";
                throw new QueryParseException(String.format(msg, name));
            }
            if (this.inSelect) {
                this.whatColumns.add(info.column);
                this.whatKeys.add(name);
                if (info.posColumn != null) {
                    this.whatColumns.add(info.posColumn);
                    this.whatKeys.add(NXQLQueryMaker.keyForPos(name));
                }
            } else {
                this.visitReference(info.column, node.cast);
                if (this.inOrderBy && info.posColumn != null) {
                    this.sb.append(", ");
                    this.visitReference(info.posColumn);
                    this.posColumnsInOrderBy.add(info.posColumn);
                }
            }
        }

        protected void visitReference(Column column) {
            this.visitReference(column, null, -1);
        }

        protected void visitReference(Column column, String cast) {
            this.visitReference(column, cast, -1);
        }

        protected void visitReference(Column column, int arrayElementIndex) {
            this.visitReference(column, null, arrayElementIndex);
        }

        protected void visitReference(Column column, String cast, int arrayElementIndex) {
            String colFmt;
            if (NXQLQueryMaker.DATE_CAST.equals(cast) && column.getType() != ColumnType.TIMESTAMP) {
                throw new QueryParseException("Cannot cast to " + cast + ": " + column);
            }
            String qname = column.getFullQuotedName();
            if (arrayElementIndex != -1) {
                if (column.isArray()) {
                    qname = NXQLQueryMaker.this.dialect.getArrayElementString(qname, arrayElementIndex);
                } else {
                    throw new QueryParseException("Cannot use array index " + arrayElementIndex + " for non-array column " + column);
                }
            }
            if (column.getJdbcType() == 2005 && (colFmt = NXQLQueryMaker.this.dialect.getClobCast(this.inOrderBy)) != null) {
                qname = String.format(colFmt, qname, 255);
            }
            if (cast != null) {
                String fmt = NXQLQueryMaker.this.dialect.getDateCast();
                this.sb.append(String.format(fmt, qname));
            } else {
                this.sb.append(qname);
            }
        }

        public void visitLiteralList(LiteralList node) {
            this.sb.append('(');
            Iterator it = node.iterator();
            while (it.hasNext()) {
                ((Literal)it.next()).accept((IVisitor)this);
                if (!it.hasNext()) continue;
                this.sb.append(", ");
            }
            this.sb.append(')');
        }

        public void visitDateLiteral(DateLiteral node) {
            this.sb.append('?');
            if (node.onlyDate) {
                NXQLQueryMaker.this.whereParams.add(node.toSqlDate());
            } else {
                NXQLQueryMaker.this.whereParams.add(node.toCalendar());
            }
        }

        public void visitStringLiteral(StringLiteral node) {
            if (this.visitingId) {
                this.visitId(node.value);
            } else {
                this.visitStringLiteral(node.value);
            }
        }

        protected void visitId(String string) {
            this.sb.append('?');
            NXQLQueryMaker.this.whereParams.add(new ColumnType.WrappedId(string));
        }

        public void visitStringLiteral(String string) {
            this.sb.append('?');
            NXQLQueryMaker.this.whereParams.add((Serializable)((Object)string));
        }

        public void visitDoubleLiteral(DoubleLiteral node) {
            this.sb.append(node.value);
        }

        public void visitIntegerLiteral(IntegerLiteral node) {
            this.sb.append(node.value);
        }

        public void visitBooleanLiteral(BooleanLiteral node) {
            this.sb.append('?');
            NXQLQueryMaker.this.whereParams.add(Boolean.valueOf(node.value));
        }

        public void visitFunction(Function node) {
            if (this.inSelect) {
                String func = node.name.toUpperCase();
                Reference ref = (Reference)node.args.get(0);
                ref.accept((IVisitor)this);
                Column col = this.whatColumns.removeLast();
                String key = this.whatKeys.removeLast();
                final String aggFQN = func + "(" + col.getFullQuotedName() + ")";
                final ColumnType aggType = this.getAggregateType(func, col.getType());
                final int aggJdbcType = NXQLQueryMaker.this.dialect.getJDBCTypeAndString((ColumnType)aggType).jdbcType;
                Column cc = new Column(col, col.getTable()){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public String getFullQuotedName() {
                        return aggFQN;
                    }

                    @Override
                    public ColumnType getType() {
                        return aggType;
                    }

                    @Override
                    public int getJdbcType() {
                        return aggJdbcType;
                    }
                };
                this.whatColumns.add(cc);
                this.whatKeys.add(func + "(" + key + ")");
            } else {
                ZonedDateTime dateTime;
                if (this.inOrderBy) {
                    throw new AssertionError();
                }
                String periodAndDurationText = node.args == null || node.args.size() != 1 ? null : ((StringLiteral)node.args.get((int)0)).value;
                try {
                    dateTime = NXQL.nowPlusPeriodAndDuration(periodAndDurationText);
                }
                catch (IllegalArgumentException e) {
                    throw new QueryParseException((Throwable)e);
                }
                DateLiteral dateLiteral = new DateLiteral(dateTime);
                this.visitDateLiteral(dateLiteral);
            }
        }

        protected void visitScore() {
            if (this.inSelect) {
                Column col = new Column(NXQLQueryMaker.this.hierTable, null, ColumnType.DOUBLE, null);
                this.whatColumns.add(col);
                this.whatKeys.add("ecm:fulltextScore");
            } else {
                this.sb.append(NXQLQueryMaker.this.aliasesByName.get("ecm:fulltextScore"));
            }
        }

        protected ColumnType getAggregateType(String func, ColumnType arg) {
            if (NXQLQueryMaker.COUNT_FUNCTION.equals(func)) {
                return ColumnType.LONG;
            }
            if (NXQLQueryMaker.AVG_FUNCTION.equals(func)) {
                return ColumnType.DOUBLE;
            }
            return arg;
        }

        public void visitOrderByList(OrderByList node) {
            this.inOrderBy = true;
            for (OrderByExpr obe : node) {
                if (this.sb.length() != 0) {
                    this.sb.append(", ");
                }
                obe.accept((IVisitor)this);
            }
            this.inOrderBy = false;
        }

        public void visitOrderByPosColumns() {
            this.inOrderBy = true;
            for (Map.Entry<String, Column> es : this.posColumns.entrySet()) {
                Column col = es.getValue();
                if (this.posColumnsInOrderBy.contains(col)) continue;
                if (this.sb.length() != 0) {
                    this.sb.append(", ");
                }
                int length = this.sb.length();
                this.visitReference(col);
                if (!this.aliasOrderByColumns) continue;
                this.sb.setLength(length);
                String alias = NXQLQueryMaker.this.aliasesByName.get(es.getKey());
                this.sb.append(alias);
            }
            this.inOrderBy = false;
        }

        public void visitOrderByExpr(OrderByExpr node) {
            int length = this.sb.length();
            super.visitOrderByExpr(node);
            if (this.aliasOrderByColumns) {
                this.sb.setLength(length);
                this.sb.append(NXQLQueryMaker.this.aliasesByName.get(node.reference.name));
            }
            if (node.isDescending) {
                this.sb.append(NXQLQueryMaker.this.dialect.getDescending());
            }
        }
    }

    protected static class ColumnInfo {
        public final Column column;
        public final Column posColumn;
        public final int arrayElementIndex;
        public final boolean isArrayElement;
        public final boolean needsSubSelect;

        public ColumnInfo(Column column, Column posColumn, int arrayElementIndex, boolean isArrayElement, boolean isArray) {
            this.column = column;
            this.posColumn = posColumn;
            this.arrayElementIndex = arrayElementIndex;
            this.isArrayElement = isArrayElement;
            this.needsSubSelect = !isArrayElement && isArray && !column.getType().isArray();
        }
    }

    protected class QueryAnalyzer
    extends DefaultQueryVisitor {
        protected FacetFilter facetFilter;
        protected boolean inSelect;
        protected boolean inOrderBy;
        protected LinkedList<Predicate> toplevelPredicates;
        protected MultiExpression wherePredicate;
        protected boolean onlyRelations;
        protected List<String> whatColumnNames;
        protected List<String> orderByColumnNames;
        protected boolean hasSelectCollection;
        protected boolean hasWildcardIndex;
        protected boolean orderByHasWildcardIndex;
        protected int ftCount;
        protected boolean selectScore;
        protected boolean orderByScore;

        public QueryAnalyzer(FacetFilter facetFilter) {
            this.facetFilter = facetFilter;
        }

        protected void init() {
            this.toplevelPredicates = new LinkedList();
            this.whatColumnNames = new LinkedList<String>();
            this.orderByColumnNames = new LinkedList<String>();
            NXQLQueryMaker.this.selectCollectionNotNull = new HashSet<String>();
            this.hasWildcardIndex = false;
            this.orderByHasWildcardIndex = false;
            this.ftCount = 0;
            this.selectScore = false;
            this.orderByScore = false;
        }

        public void visitQuery(SQLQuery node) {
            this.init();
            if (this.facetFilter != null) {
                this.addFacetFilterClauses(this.facetFilter);
            }
            this.visitSelectClause(node.select);
            this.visitFromClause(node.from);
            this.visitWhereClause(node.where);
            if (node.orderBy != null) {
                this.visitOrderByClause(node.orderBy);
            }
        }

        public void addFacetFilterClauses(FacetFilter facetFilter) {
            for (Object mixin : facetFilter.required) {
                Predicate predicate = new Predicate((Operand)new Reference("ecm:mixinType"), Operator.EQ, (Operand)new StringLiteral((String)mixin));
                this.toplevelPredicates.add(predicate);
            }
            if (!facetFilter.excluded.isEmpty()) {
                LiteralList list = new LiteralList();
                for (String mixin : facetFilter.excluded) {
                    list.add((Object)new StringLiteral(mixin));
                }
                Predicate predicate = new Predicate((Operand)new Reference("ecm:mixinType"), Operator.NOTIN, (Operand)list);
                this.toplevelPredicates.add(predicate);
            }
        }

        public void visitSelectClause(SelectClause node) {
            this.inSelect = true;
            super.visitSelectClause(node);
            this.inSelect = false;
        }

        public void visitFromClause(FromClause node) {
            this.onlyRelations = true;
            HashSet<String> fromTypes = new HashSet<String>();
            FromList elements = node.elements;
            for (String typeName : elements.values()) {
                Set<String> subTypes;
                if (NXQLQueryMaker.TYPE_DOCUMENT.equalsIgnoreCase(typeName)) {
                    typeName = NXQLQueryMaker.TYPE_DOCUMENT;
                }
                if ((subTypes = NXQLQueryMaker.this.model.getDocumentSubTypes(typeName)) == null) {
                    throw new QueryParseException("Unknown type: " + typeName);
                }
                fromTypes.addAll(subTypes);
                boolean isRelation = false;
                do {
                    if (!NXQLQueryMaker.TYPE_RELATION.equals(typeName)) continue;
                    isRelation = true;
                    break;
                } while ((typeName = NXQLQueryMaker.this.model.getDocumentSuperType(typeName)) != null);
                this.onlyRelations = this.onlyRelations && isRelation;
            }
            fromTypes.remove("Root");
            LiteralList list = new LiteralList();
            for (String type : fromTypes) {
                list.add((Object)new StringLiteral(type));
            }
            this.toplevelPredicates.add(new Predicate((Operand)new Reference("ecm:primaryType"), Operator.IN, (Operand)list));
        }

        public void visitWhereClause(WhereClause node) {
            if (node != null) {
                this.analyzeToplevelPredicates(node.predicate);
            }
            this.simplifyToplevelPredicates();
            this.wherePredicate = new MultiExpression(Operator.AND, this.toplevelPredicates);
            super.visitMultiExpression(this.wherePredicate);
        }

        protected void analyzeToplevelPredicates(Predicate predicate) {
            Operator op = predicate.operator;
            if (op == Operator.AND) {
                if (predicate.lvalue instanceof Predicate && predicate.rvalue instanceof Predicate) {
                    this.analyzeToplevelPredicates((Predicate)predicate.lvalue);
                    this.analyzeToplevelPredicates((Predicate)predicate.rvalue);
                    return;
                }
                if (predicate instanceof MultiExpression) {
                    for (Predicate p : ((MultiExpression)predicate).predicates) {
                        this.analyzeToplevelPredicates(p);
                    }
                    return;
                }
            }
            if (op == Operator.EQ || op == Operator.NOTEQ) {
                if (predicate.rvalue instanceof Reference) {
                    predicate = new Predicate(predicate.rvalue, op, predicate.lvalue);
                }
                if (predicate.lvalue instanceof Reference) {
                    String name = ((Reference)predicate.lvalue).name;
                    if ("ecm:isProxy".equals(name)) {
                        this.analyzeToplevelIsProxy((Expression)predicate);
                        return;
                    }
                    if ("ecm:proxyTargetId".equals(name) || "ecm:proxyVersionableId".equals(name)) {
                        this.analyzeToplevelProxyProperty((Expression)predicate);
                    }
                }
            }
            this.toplevelPredicates.add(predicate);
        }

        protected void simplifyToplevelPredicates() {
            Set<String> primaryTypes = null;
            Iterator it = this.toplevelPredicates.iterator();
            while (it.hasNext()) {
                String mixin;
                Expression expr = (Expression)it.next();
                if (!(expr.lvalue instanceof Reference)) continue;
                String name = ((Reference)expr.lvalue).name;
                Operator op = expr.operator;
                Operand rvalue = expr.rvalue;
                if ("ecm:primaryType".equals(name)) {
                    Set<String> set;
                    if (op != Operator.EQ && op != Operator.IN) continue;
                    if (op == Operator.EQ) {
                        if (!(rvalue instanceof StringLiteral)) continue;
                        String primaryType = ((StringLiteral)rvalue).value;
                        set = new HashSet<String>(Collections.singleton(primaryType));
                    } else {
                        if (!(rvalue instanceof LiteralList)) continue;
                        set = NXQLQueryMaker.getStringLiterals((LiteralList)rvalue);
                    }
                    if (primaryTypes == null) {
                        primaryTypes = set;
                    } else {
                        primaryTypes.retainAll(set);
                    }
                    it.remove();
                    continue;
                }
                if (!"ecm:mixinType".equals(name) || op != Operator.EQ && op != Operator.NOTEQ || !(rvalue instanceof StringLiteral) || !NXQLQueryMaker.this.neverPerInstanceMixins.contains(mixin = ((StringLiteral)rvalue).value)) continue;
                Set<String> set = NXQLQueryMaker.this.model.getMixinDocumentTypes(mixin);
                if (primaryTypes == null) {
                    if (op != Operator.EQ) continue;
                    primaryTypes = new HashSet<String>(set);
                } else if (op == Operator.EQ) {
                    primaryTypes.retainAll(set);
                } else {
                    primaryTypes.removeAll(set);
                }
                it.remove();
            }
            if (primaryTypes != null) {
                Predicate predicate;
                if (primaryTypes.isEmpty()) {
                    primaryTypes.add("__NOSUCHTYPE__");
                }
                if (primaryTypes.size() == 1) {
                    String pt = (String)primaryTypes.iterator().next();
                    predicate = new Predicate((Operand)new Reference("ecm:primaryType"), Operator.EQ, (Operand)new StringLiteral(pt));
                } else {
                    LiteralList list = new LiteralList();
                    for (String pt : primaryTypes) {
                        list.add((Object)new StringLiteral(pt));
                    }
                    predicate = new Predicate((Operand)new Reference("ecm:primaryType"), Operator.IN, (Operand)list);
                }
                this.toplevelPredicates.addFirst(predicate);
            }
        }

        protected void analyzeToplevelIsProxy(Expression expr) {
            if (!(expr.rvalue instanceof IntegerLiteral)) {
                throw new QueryParseException("ecm:isProxy requires literal 0 or 1 as right argument");
            }
            long v = ((IntegerLiteral)expr.rvalue).value;
            if (v != 0L && v != 1L) {
                throw new QueryParseException("ecm:isProxy requires literal 0 or 1 as right argument");
            }
            boolean isEq = expr.operator == Operator.EQ;
            this.updateProxyClause(v == 1L == isEq, expr);
        }

        protected void analyzeToplevelProxyProperty(Expression expr) {
            this.updateProxyClause(Boolean.TRUE, expr);
        }

        private void updateProxyClause(Boolean value, Expression expr) {
            if (NXQLQueryMaker.this.proxyClause != null && NXQLQueryMaker.this.proxyClause != value) {
                throw new QueryMaker.QueryCannotMatchException();
            }
            NXQLQueryMaker.this.proxyClause = value;
            NXQLQueryMaker.this.proxyClauseReason = expr.toString();
        }

        public void visitExpression(Expression node) {
            String name;
            Reference ref = node.lvalue instanceof Reference ? (Reference)node.lvalue : null;
            String string = name = ref != null ? ref.name : null;
            if (name != null && name.startsWith("ecm:fulltext") && !"ecm:fulltextJobId".equals(name)) {
                this.visitExpressionFulltext(node, name);
            } else {
                super.visitExpression(node);
            }
        }

        protected void visitExpressionFulltext(Expression node, String name) {
            if (node.operator != Operator.EQ && node.operator != Operator.LIKE) {
                throw new QueryParseException("ecm:fulltext requires = or LIKE operator");
            }
            if (!(node.rvalue instanceof StringLiteral)) {
                throw new QueryParseException("ecm:fulltext requires literal string as right argument");
            }
            if (NXQLQueryMaker.this.model.getRepositoryDescriptor().getFulltextDescriptor().getFulltextSearchDisabled()) {
                throw new QueryParseException("Fulltext search disabled by configuration");
            }
            String[] nameref = new String[]{name};
            boolean useIndex = NXQLQueryMaker.findFulltextIndexOrField(NXQLQueryMaker.this.model, nameref);
            if (useIndex) {
                ++this.ftCount;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void visitReference(Reference node) {
            boolean hasTag = false;
            if (node.cast != null && !NXQLQueryMaker.DATE_CAST.equals(node.cast)) {
                throw new QueryParseException("Invalid cast: " + node);
            }
            String name = node.name;
            if ("ecm:path".equals(name) || "ecm:ancestorId".equals(name) || "ecm:isProxy".equals(name) || "ecm:mixinType".equals(name)) {
                if (this.inSelect) {
                    throw new QueryParseException("Cannot select on column: " + name);
                }
                if (this.inOrderBy) {
                    throw new QueryParseException("Cannot order by column: " + name);
                }
            } else if (!("ecm:primaryType".equals(name) || "ecm:uuid".equals(name) || "ecm:name".equals(name) || "ecm:pos".equals(name) || "ecm:parentId".equals(name) || "ecm:currentLifeCycleState".equals(name) || "ecm:versionLabel".equals(name) || "ecm:versionDescription".equals(name) || "ecm:versionCreated".equals(name) || "ecm:versionVersionableId".equals(name) || "ecm:isLatestVersion".equals(name) || "ecm:isLatestMajorVersion".equals(name) || "ecm:isCheckedInVersion".equals(name) || "ecm:isVersion".equals(name) || "ecm:isCheckedIn".equals(name) || "ecm:lockOwner".equals(name) || "ecm:lockCreated".equals(name) || "ecm:proxyTargetId".equals(name) || "ecm:proxyVersionableId".equals(name) || "ecm:fulltextJobId".equals(name))) {
                if ("ecm:isTrashed".equals(name)) {
                    TrashService trashService = (TrashService)Framework.getService(TrashService.class);
                    if (!trashService.hasFeature(TrashService.Feature.TRASHED_STATE_IS_DEDICATED_PROPERTY) && !trashService.hasFeature(TrashService.Feature.TRASHED_STATE_IN_MIGRATION)) {
                        name = "ecm:currentLifeCycleState";
                    }
                } else if ("ecm:tag".equals(name) || name.startsWith(NXQLQueryMaker.ECM_TAG_STAR)) {
                    hasTag = true;
                } else if ("ecm:fulltextScore".equals(name)) {
                    if (this.inOrderBy) {
                        this.orderByScore = true;
                    } else {
                        if (!this.inSelect) throw new QueryParseException("Can only use column in SELECT or ORDER BY: " + name);
                        this.selectScore = true;
                    }
                } else if (name.startsWith("ecm:fulltext")) {
                    if (this.inSelect) {
                        throw new QueryParseException("Cannot select on column: " + name);
                    }
                    if (this.inOrderBy) {
                        throw new QueryParseException("Cannot order by column: " + name);
                    }
                    String[] nameref = new String[]{name};
                    boolean useIndex = NXQLQueryMaker.findFulltextIndexOrField(NXQLQueryMaker.this.model, nameref);
                    if (!useIndex) {
                        name = nameref[0];
                        this.checkProperty(name);
                    }
                } else if (name.startsWith("ecm:acl")) {
                    String simple = NXQLQueryMaker.simpleXPath(name);
                    if (!(simple.equals(NXQLQueryMaker.ECM_SIMPLE_ACP_PRINCIPAL) || simple.equals(NXQLQueryMaker.ECM_SIMPLE_ACP_PERMISSION) || simple.equals(NXQLQueryMaker.ECM_SIMPLE_ACP_GRANT) || simple.equals(NXQLQueryMaker.ECM_SIMPLE_ACP_NAME) || simple.equals(NXQLQueryMaker.ECM_SIMPLE_ACP_POS) || simple.equals(NXQLQueryMaker.ECM_SIMPLE_ACP_CREATOR) || simple.equals(NXQLQueryMaker.ECM_SIMPLE_ACP_BEGIN) || simple.equals(NXQLQueryMaker.ECM_SIMPLE_ACP_END) || simple.equals(NXQLQueryMaker.ECM_SIMPLE_ACP_STATUS))) {
                        throw new QueryParseException("Unknown field: " + name);
                    }
                } else {
                    if (name.startsWith("ecm:")) {
                        throw new QueryParseException("Unknown field: " + name);
                    }
                    this.checkProperty(name);
                }
            }
            if (this.inSelect) {
                this.whatColumnNames.add(name);
            } else if (this.inOrderBy) {
                this.orderByColumnNames.add(name);
            }
            if (!NXQLQueryMaker.this.hasWildcardIndex(name) && !hasTag) return;
            this.hasWildcardIndex = true;
            if (this.inOrderBy) {
                this.orderByHasWildcardIndex = true;
            }
            if (!NXQLQueryMaker.this.hasFinalWildcardIndex(name)) return;
            if (this.inSelect) {
                this.hasSelectCollection = true;
                NXQLQueryMaker.this.selectCollectionNotNull.add(name);
                return;
            } else {
                if (this.inOrderBy) return;
                NXQLQueryMaker.this.selectCollectionNotNull.remove(name);
            }
        }

        protected void checkProperty(String xpath) {
            String simple = NXQLQueryMaker.simpleXPath(xpath);
            ModelProperty prop = NXQLQueryMaker.this.model.getPathPropertyInfo(simple);
            if (prop == null || prop.isIntermediateSegment()) {
                throw new QueryParseException("No such property: " + xpath);
            }
        }

        public void visitFunction(Function node) {
            String func = node.name.toUpperCase();
            if (this.inSelect) {
                Operand arg;
                if (!AGGREGATE_FUNCTIONS.contains(func) || node.args.size() != 1 || !((arg = (Operand)node.args.get(0)) instanceof Reference)) {
                    throw new QueryParseException("Function not supported in SELECT clause: " + node);
                }
                this.visitReference((Reference)arg);
            } else {
                if (this.inOrderBy) {
                    throw new QueryParseException("Function not supported in ORDER BY clause: " + node);
                }
                if ("NOW".equals(func)) {
                    if (!(node.args == null || node.args.isEmpty() || node.args.size() == 1 && node.args.get(0) instanceof StringLiteral)) {
                        throw new QueryParseException("Function not supported in WHERE clause: " + node);
                    }
                } else {
                    throw new QueryParseException("Function not supported in WHERE clause: " + node);
                }
            }
        }

        public void visitOrderByClause(OrderByClause node) {
            this.inOrderBy = true;
            super.visitOrderByClause(node);
            this.inOrderBy = false;
        }
    }

    public static enum DocKind {
        DIRECT,
        PROXY;

    }
}

