/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client;

import java.io.IOException;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestConverters;
import org.elasticsearch.client.rollup.GetRollupCapsRequest;
import org.elasticsearch.client.rollup.GetRollupJobRequest;
import org.elasticsearch.client.rollup.PutRollupJobRequest;
import org.elasticsearch.common.xcontent.ToXContent;

final class RollupRequestConverters {
    private RollupRequestConverters() {
    }

    static Request putJob(PutRollupJobRequest putRollupJobRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_xpack").addPathPartAsIs("rollup").addPathPartAsIs("job").addPathPart(putRollupJobRequest.getConfig().getId()).build();
        Request request = new Request("PUT", endpoint);
        request.setEntity(RequestConverters.createEntity((ToXContent)putRollupJobRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request getJob(GetRollupJobRequest getRollupJobRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_xpack").addPathPartAsIs("rollup").addPathPartAsIs("job").addPathPart(getRollupJobRequest.getJobId()).build();
        return new Request("GET", endpoint);
    }

    static Request getRollupCaps(GetRollupCapsRequest getRollupCapsRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_xpack").addPathPartAsIs("rollup").addPathPartAsIs("data").addPathPart(getRollupCapsRequest.getIndexPattern()).build();
        Request request = new Request("GET", endpoint);
        request.setEntity(RequestConverters.createEntity((ToXContent)getRollupCapsRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }
}

