/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.aggregate;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.range.Range;
import org.elasticsearch.search.aggregations.bucket.range.RangeAggregationBuilder;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.query.api.AggregateDefinition;
import org.nuxeo.ecm.platform.query.api.AggregateRangeDefinition;
import org.nuxeo.ecm.platform.query.core.BucketRange;
import org.nuxeo.elasticsearch.aggregate.MultiBucketAggregate;

public class RangeAggregate
extends MultiBucketAggregate<BucketRange> {
    public RangeAggregate(AggregateDefinition definition, DocumentModel searchDocument) {
        super(definition, searchDocument);
    }

    @JsonIgnore
    public RangeAggregationBuilder getEsAggregate() {
        RangeAggregationBuilder ret = (RangeAggregationBuilder)AggregationBuilders.range((String)this.getId()).field(this.getField());
        for (AggregateRangeDefinition range : this.getRanges()) {
            if (range.getFrom() != null) {
                if (range.getTo() != null) {
                    ret.addRange(range.getKey(), range.getFrom().doubleValue(), range.getTo().doubleValue());
                    continue;
                }
                ret.addUnboundedFrom(range.getKey(), range.getFrom().doubleValue());
                continue;
            }
            if (range.getTo() == null) continue;
            ret.addUnboundedTo(range.getKey(), range.getTo().doubleValue());
        }
        return ret;
    }

    @Override
    @JsonIgnore
    public QueryBuilder getEsFilter() {
        if (this.getSelection().isEmpty()) {
            return null;
        }
        BoolQueryBuilder ret = QueryBuilders.boolQuery();
        for (AggregateRangeDefinition range : this.getRanges()) {
            if (!this.getSelection().contains(range.getKey())) continue;
            RangeQueryBuilder rangeFilter = QueryBuilders.rangeQuery((String)this.getField());
            if (range.getFrom() != null) {
                rangeFilter.gte((Object)range.getFrom());
            }
            if (range.getTo() != null) {
                rangeFilter.lt((Object)range.getTo());
            }
            ret.should((QueryBuilder)rangeFilter);
        }
        return ret;
    }

    @Override
    @JsonIgnore
    public void parseEsBuckets(Collection<? extends MultiBucketsAggregation.Bucket> buckets) {
        ArrayList<BucketRange> nxBuckets = new ArrayList<BucketRange>(buckets.size());
        for (MultiBucketsAggregation.Bucket bucket : buckets) {
            Range.Bucket rangeBucket = (Range.Bucket)bucket;
            double from = (Double)rangeBucket.getFrom();
            double to = (Double)rangeBucket.getTo();
            nxBuckets.add(new BucketRange(bucket.getKeyAsString(), (Number)from, (Number)to, rangeBucket.getDocCount()));
        }
        nxBuckets.sort(new BucketRangeComparator());
        this.buckets = nxBuckets;
    }

    protected class BucketRangeComparator
    implements Comparator<BucketRange> {
        protected BucketRangeComparator() {
        }

        @Override
        public int compare(BucketRange arg0, BucketRange arg1) {
            return ((Integer)RangeAggregate.this.definition.getAggregateRangeDefinitionOrderMap().get(arg0.getKey())).compareTo((Integer)RangeAggregate.this.definition.getAggregateRangeDefinitionOrderMap().get(arg1.getKey()));
        }
    }
}

