/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.api;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Optional;
import org.nuxeo.elasticsearch.api.ESClient;
import org.nuxeo.elasticsearch.api.ESHintQueryBuilder;

public interface ElasticSearchAdmin {
    public ESClient getClient();

    public void initIndexes(boolean var1);

    public void dropAndInitIndex(String var1);

    default public void dropAndInitRepositoryIndex(String repositoryName) {
        this.dropAndInitRepositoryIndex(repositoryName, true);
    }

    public void dropAndInitRepositoryIndex(String var1, boolean var2);

    public List<String> getRepositoryNames();

    public String getIndexNameForRepository(String var1);

    public String getRepositoryForIndex(String var1);

    public List<String> getIndexNamesForType(String var1);

    public String getIndexNameForType(String var1);

    public String getWriteIndexName(String var1);

    public void syncSearchAndWriteAlias(String var1);

    public boolean isIndexingInProgress();

    public ListenableFuture<Boolean> prepareWaitForIndexing();

    public void refresh();

    public void refreshRepositoryIndex(String var1);

    public void flush();

    public void flushRepositoryIndex(String var1);

    public void optimize();

    public void optimizeRepositoryIndex(String var1);

    public void optimizeIndex(String var1);

    public long getPendingWorkerCount();

    public long getRunningWorkerCount();

    public int getTotalCommandProcessed();

    public boolean isEmbedded();

    public boolean useExternalVersion();

    public Optional<ESHintQueryBuilder> getHintByOperator(String var1);
}

