/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.core;

import java.io.Closeable;
import java.io.IOException;
import java.net.BindException;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.analysis.common.CommonAnalysisPlugin;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeValidationException;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.transport.Netty4Plugin;
import org.nuxeo.common.utils.ExceptionUtils;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.elasticsearch.config.ElasticSearchEmbeddedServerConfig;
import org.nuxeo.elasticsearch.core.PluginConfigurableNode;
import org.nuxeo.runtime.api.Framework;

public class ElasticSearchEmbeddedNode
implements Closeable {
    private static final Log log = LogFactory.getLog(ElasticSearchEmbeddedNode.class);
    private static final int DEFAULT_RETRY = 3;
    protected final ElasticSearchEmbeddedServerConfig config;
    protected Node node;
    protected int retry = 3;

    public ElasticSearchEmbeddedNode(ElasticSearchEmbeddedServerConfig config) {
        this.config = config;
    }

    public void start() {
        log.info((Object)"Starting embedded (in JVM) Elasticsearch");
        if (Framework.isInitialized() && !Framework.isTestModeSet()) {
            log.warn((Object)"Elasticsearch embedded configuration is ONLY for testing purpose. You need to create a dedicated Elasticsearch cluster for production.");
        }
        Settings.Builder buidler = Settings.builder();
        buidler.put("network.host", this.config.getNetworkHost()).put("path.home", this.config.getHomePath()).put("path.data", this.config.getDataPath()).put("cluster.name", this.config.getClusterName()).put("node.name", this.config.getNodeName()).put("http.netty.worker_count", 4).put("http.cors.enabled", true).put("http.cors.allow-origin", "*").put("http.cors.allow-credentials", true).put("http.cors.allow-headers", "Authorization, X-Requested-With, Content-Type, Content-Length").put("cluster.routing.allocation.disk.threshold_enabled", false).put("http.port", this.config.getHttpPort());
        if (this.config.getIndexStorageType() != null) {
            buidler.put("index.store.type", this.config.getIndexStorageType());
        }
        Settings settings = buidler.build();
        log.debug((Object)("Using settings: " + settings.toDelimitedString(',')));
        HashSet<Class<? extends Plugin>> plugins = new HashSet<Class<? extends Plugin>>();
        plugins.add(Netty4Plugin.class);
        plugins.add(CommonAnalysisPlugin.class);
        try {
            this.node = new PluginConfigurableNode(settings, plugins);
            this.node.start();
            this.config.setHomePath(null);
        }
        catch (NodeValidationException e) {
            throw new NuxeoException("Cannot start embedded Elasticsearch: " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            Throwable cause = ExceptionUtils.getRootCause((Throwable)e);
            if (cause != null && cause instanceof BindException) {
                --this.retry;
                log.error((Object)String.format("Cannot bind local Elasticsearch on port %s, from %s, retry countdown: %d", this.config.getHttpPort(), this.config.getDataPath(), this.retry));
                try {
                    this.node.close();
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                    throw new NuxeoException((Throwable)e1);
                }
                catch (IOException e1) {
                    throw new NuxeoException((Throwable)e1);
                }
                if (this.retry <= 0) {
                    String msg = "Not able to bind to local Elasticsearch after multiple attempts, give up";
                    log.error((Object)msg);
                    throw new IllegalStateException(msg);
                }
                this.start();
            }
            throw e;
        }
        this.retry = 3;
        log.debug((Object)"Elasticsearch node started.");
    }

    @Override
    public void close() throws IOException {
        if (this.node != null) {
            log.info((Object)"Closing embedded (in JVM) Elasticsearch");
            this.node.close();
            log.info((Object)("Node closed: " + this.node.isClosed()));
        }
        this.node = null;
    }

    public ElasticSearchEmbeddedServerConfig getConfig() {
        return this.config;
    }

    public Node getNode() {
        return this.node;
    }
}

