/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.hint;

import org.elasticsearch.index.query.MoreLikeThisQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.query.sql.model.EsHint;
import org.nuxeo.elasticsearch.api.ESHintQueryBuilder;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.runtime.api.Framework;

public class MoreLikeThisESHintQueryBuilder
implements ESHintQueryBuilder {
    public static final int MORE_LIKE_THIS_MIN_TERM_FREQ = 1;
    public static final int MORE_LIKE_THIS_MIN_DOC_FREQ = 3;
    public static final int MORE_LIKE_THIS_MAX_QUERY_TERMS = 12;

    @Override
    public QueryBuilder make(EsHint hint, String fieldName, Object value) {
        String[] stringArray;
        String[] indexFields = hint.getIndexFieldNames();
        if (indexFields.length > 0) {
            stringArray = indexFields;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = fieldName;
        }
        String[] fields = stringArray;
        return QueryBuilders.moreLikeThisQuery((String[])fields, null, (MoreLikeThisQueryBuilder.Item[])MoreLikeThisESHintQueryBuilder.getItems(value)).analyzer(hint.analyzer).minDocFreq(3).minTermFreq(1).maxQueryTerms(12);
    }

    public static MoreLikeThisQueryBuilder.Item[] getItems(Object value) {
        RepositoryManager rm = (RepositoryManager)Framework.getService(RepositoryManager.class);
        String repo = rm.getDefaultRepository().getName();
        ElasticSearchAdmin esa = (ElasticSearchAdmin)Framework.getService(ElasticSearchAdmin.class);
        String esIndex = esa.getIndexNameForRepository(repo);
        String[] values = value instanceof String[] ? (String[])value : new String[]{(String)value};
        MoreLikeThisQueryBuilder.Item[] ret = new MoreLikeThisQueryBuilder.Item[values.length];
        for (int i = 0; i < values.length; ++i) {
            ret[i] = new MoreLikeThisQueryBuilder.Item(esIndex, "doc", values[i]);
        }
        return ret;
    }
}

