/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableObject;
import org.nuxeo.ecm.core.api.CloseableCoreSession;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.local.LocalException;
import org.nuxeo.ecm.core.schema.types.resolver.AbstractObjectResolver;
import org.nuxeo.ecm.core.schema.types.resolver.ObjectResolver;

public class DocumentModelResolver
extends AbstractObjectResolver
implements ObjectResolver {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "documentResolver";
    public static final String PARAM_STORE = "store";
    public static final String STORE_REPO_AND_PATH = "path";
    public static final String STORE_PATH_ONLY = "pathOnly";
    public static final String STORE_REPO_AND_ID = "id";
    public static final String STORE_ID_ONLY = "idOnly";
    private MODE mode = MODE.REPO_AND_ID_REF;
    private List<Class<?>> managedClasses = null;

    public MODE getMode() {
        return this.mode;
    }

    public List<Class<?>> getManagedClasses() {
        if (this.managedClasses == null) {
            this.managedClasses = new ArrayList();
            this.managedClasses.add(DocumentModel.class);
        }
        return this.managedClasses;
    }

    public void configure(Map<String, String> parameters) throws IllegalStateException {
        super.configure(parameters);
        String store = parameters.get(PARAM_STORE);
        if (store == null) {
            store = "";
        }
        switch (store) {
            case "pathOnly": {
                this.mode = MODE.PATH_ONLY_REF;
                break;
            }
            case "idOnly": {
                this.mode = MODE.ID_ONLY_REF;
                break;
            }
            case "path": {
                this.mode = MODE.REPO_AND_PATH_REF;
                break;
            }
            default: {
                this.mode = MODE.REPO_AND_ID_REF;
                store = STORE_REPO_AND_ID;
            }
        }
        this.parameters.put(PARAM_STORE, store);
    }

    public String getName() {
        this.checkConfig();
        return NAME;
    }

    public boolean validate(Object value) {
        return this.validate(value, null);
    }

    public boolean validate(Object value, Object context) {
        if (!this.validation) {
            return true;
        }
        MutableBoolean validated = new MutableBoolean();
        this.resolve(value, context, (session, docRef) -> {
            if (session.exists(docRef)) {
                validated.setTrue();
            }
        });
        return validated.isTrue();
    }

    public Object fetch(Object value) {
        return this.fetch(value, null);
    }

    public Object fetch(Object value, Object context) {
        MutableObject docHolder = new MutableObject();
        this.resolve(value, context, (session, docRef) -> {
            if (session.exists(docRef)) {
                DocumentModel doc = session.getDocument(docRef);
                doc.detach(true);
                docHolder.setValue((Object)doc);
            }
        });
        return docHolder.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resolve(Object value, Object context, BiConsumer<CoreSession, DocumentRef> resolver) {
        this.checkConfig();
        if (!(value instanceof String)) {
            return;
        }
        REF ref = REF.fromValue((String)value);
        if (ref == null) {
            return;
        }
        try (CloseableCoreSession closeableCoreSession = null;){
            IdRef docRef;
            CoreSession session;
            try {
                if (ref.repo != null) {
                    if (context != null && ref.repo.equals(((CoreSession)context).getRepositoryName())) {
                        session = (CoreSession)context;
                    } else {
                        closeableCoreSession = CoreInstance.openCoreSession((String)ref.repo);
                        session = closeableCoreSession;
                    }
                } else {
                    session = (CoreSession)context;
                    if (session == null) {
                        closeableCoreSession = CoreInstance.openCoreSession(null);
                        session = closeableCoreSession;
                    }
                }
            }
            catch (LocalException e) {
                if (closeableCoreSession != null) {
                    closeableCoreSession.close();
                }
                return;
            }
            switch (this.mode) {
                case ID_ONLY_REF: 
                case REPO_AND_ID_REF: {
                    docRef = new IdRef(ref.ref);
                    break;
                }
                case PATH_ONLY_REF: 
                case REPO_AND_PATH_REF: {
                    docRef = new PathRef(ref.ref);
                    break;
                }
                default: {
                    return;
                }
            }
            resolver.accept(session, (DocumentRef)docRef);
        }
    }

    public <T> T fetch(Class<T> type, Object value) throws IllegalStateException {
        this.checkConfig();
        DocumentModel doc = (DocumentModel)this.fetch(value);
        if (doc != null) {
            if (type.isInstance(doc)) {
                return type.cast(doc);
            }
            return (T)doc.getAdapter(type);
        }
        return null;
    }

    public Serializable getReference(Object entity) throws IllegalStateException {
        this.checkConfig();
        if (entity instanceof DocumentModel) {
            DocumentModel doc = (DocumentModel)entity;
            switch (this.mode) {
                case ID_ONLY_REF: {
                    return doc.getId();
                }
                case PATH_ONLY_REF: {
                    return doc.getPath().toString();
                }
                case REPO_AND_ID_REF: {
                    return doc.getRepositoryName() + ":" + doc.getId();
                }
                case REPO_AND_PATH_REF: {
                    return doc.getRepositoryName() + ":" + doc.getPath().toString();
                }
            }
        }
        return null;
    }

    public String getConstraintErrorMessage(Object invalidValue, Locale locale) {
        this.checkConfig();
        switch (this.mode) {
            case ID_ONLY_REF: 
            case REPO_AND_ID_REF: {
                return ObjectResolver.Helper.getConstraintErrorMessage((ObjectResolver)this, (String)STORE_REPO_AND_ID, (Object)invalidValue, (Locale)locale, (String[])new String[0]);
            }
            case PATH_ONLY_REF: 
            case REPO_AND_PATH_REF: {
                return ObjectResolver.Helper.getConstraintErrorMessage((ObjectResolver)this, (String)STORE_REPO_AND_PATH, (Object)invalidValue, (Locale)locale, (String[])new String[0]);
            }
        }
        return String.format("%s cannot resolve reference %s", this.getName(), invalidValue);
    }

    protected static final class REF {
        protected String repo;
        protected String ref;

        protected REF() {
        }

        protected static REF fromValue(String value) {
            String[] split = value.split(":");
            if (split.length == 1) {
                REF ref = new REF();
                ref.repo = null;
                ref.ref = split[0];
                return ref;
            }
            if (split.length == 2) {
                REF ref = new REF();
                ref.repo = split[0];
                ref.ref = split[1];
                return ref;
            }
            return null;
        }
    }

    public static enum MODE {
        REPO_AND_PATH_REF,
        REPO_AND_ID_REF,
        PATH_ONLY_REF,
        ID_ONLY_REF;

    }
}

