/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.filemanager.core.listener;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.utils.BlobsExtractor;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeEntry;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.ecm.platform.types.Type;
import org.nuxeo.ecm.platform.types.TypeManager;
import org.nuxeo.runtime.api.Framework;

public class MimetypeIconUpdater
implements EventListener {
    protected Log log = LogFactory.getLog(MimetypeIconUpdater.class);
    public static final String ICON_SCHEMA = "common";
    public static final String ICON_FIELD = "common:icon";
    public static final String MAIN_BLOB_FIELD = "file:content";
    public static final String MAIN_BLOB_SCHEMA = "file";
    @Deprecated(since="11.1", forRemoval=true)
    protected static final String OCTET_STREAM_MT = "application/octet-stream";
    @Deprecated(since="11.1", forRemoval=true)
    public final BlobsExtractor blobExtractor = new BlobsExtractor();
    @Deprecated(since="11.1", forRemoval=true)
    MimetypeRegistry mimetypeService;

    @Deprecated(since="11.1", forRemoval=true)
    public MimetypeRegistry getMimetypeRegistry() {
        if (this.mimetypeService == null) {
            this.mimetypeService = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
        }
        return this.mimetypeService;
    }

    public void handleEvent(Event event) {
        EventContext ctx = event.getContext();
        if (ctx instanceof DocumentEventContext) {
            DocumentEventContext docCtx = (DocumentEventContext)ctx;
            DocumentModel doc = docCtx.getSourceDocument();
            if (doc.hasFacet("Immutable")) {
                return;
            }
            try {
                this.setDefaultIcon(doc);
                MimetypeRegistry mimetypeRegistry = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
                BlobsExtractor extractor = new BlobsExtractor();
                for (Property prop : extractor.getBlobsProperties(doc)) {
                    if (!prop.isDirty()) continue;
                    this.updateBlobProperty(doc, mimetypeRegistry, prop);
                }
                if (doc.hasSchema(MAIN_BLOB_SCHEMA) && doc.getProperty(MAIN_BLOB_FIELD).isDirty()) {
                    this.updateIconAndSizeFields(doc, mimetypeRegistry, (Blob)doc.getProperty(MAIN_BLOB_FIELD).getValue(Blob.class));
                }
            }
            catch (PropertyException e) {
                e.addInfo("Error in MimetypeIconUpdater listener");
                throw e;
            }
        }
    }

    public void updateBlobProperty(DocumentModel doc, MimetypeRegistry mimetypeService, Property dirtyProperty) {
        Blob blob;
        Object fieldPath = dirtyProperty.getXPath();
        if (!((String)fieldPath).contains(":")) {
            fieldPath = dirtyProperty.getSchema().getName() + ":" + (String)fieldPath;
        }
        if ((blob = (Blob)dirtyProperty.getValue(Blob.class)) == null) {
            return;
        }
        if (blob.getMimeType() == null || blob.getMimeType().equals(OCTET_STREAM_MT)) {
            blob = mimetypeService.updateMimetype(blob);
            doc.setPropertyValue((String)fieldPath, (Serializable)blob);
        } else if (!mimetypeService.isMimeTypeNormalized(blob.getMimeType())) {
            mimetypeService.getNormalizedMimeType(blob.getMimeType()).ifPresent(arg_0 -> ((Blob)blob).setMimeType(arg_0));
        }
    }

    private void updateIconAndSizeFields(DocumentModel doc, MimetypeRegistry mimetypeService, Blob blob) {
        if (blob != null && !doc.isFolder()) {
            MimetypeEntry mimetypeEntry = mimetypeService.getMimetypeEntryByMimeType(blob.getMimeType());
            this.updateIconField(mimetypeEntry, doc);
        } else {
            this.updateIconField(null, doc);
        }
    }

    public void setDefaultIcon(DocumentModel doc) {
        if (doc.hasSchema(ICON_SCHEMA) && doc.getProperty(ICON_FIELD).getValue(String.class) == null) {
            this.updateIconField(null, doc);
        }
    }

    public void updateIconField(MimetypeEntry mimetypeEntry, DocumentModel doc) {
        Object iconPath = null;
        if (mimetypeEntry != null && mimetypeEntry.getIconPath() != null) {
            iconPath = "/icons/" + mimetypeEntry.getIconPath();
        } else {
            TypeManager typeManager = (TypeManager)Framework.getService(TypeManager.class);
            if (typeManager == null) {
                return;
            }
            Type uiType = typeManager.getType(doc.getType());
            if (uiType != null) {
                iconPath = uiType.getIcon();
            }
        }
        if (iconPath != null && doc.hasSchema(ICON_SCHEMA)) {
            doc.setPropertyValue(ICON_FIELD, (Serializable)iconPath);
        }
    }
}

