/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.persistence;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.hibernate.HibernateException;
import org.hibernate.connection.ConnectionProvider;
import org.nuxeo.runtime.datasource.DataSourceHelper;

public class NuxeoConnectionProvider
implements ConnectionProvider {
    protected DataSource ds;

    public void configure(Properties props) {
        String name = props.getProperty("hibernate.connection.datasource");
        try {
            this.ds = DataSourceHelper.getDataSource((String)name);
        }
        catch (NamingException cause) {
            throw new HibernateException("Cannot lookup datasource by name " + name, (Throwable)cause);
        }
    }

    public Connection getConnection() throws SQLException {
        return this.ds.getConnection();
    }

    public void closeConnection(Connection connection) throws SQLException {
        connection.close();
    }

    public void close() throws HibernateException {
        this.ds = null;
    }

    public boolean supportsAggressiveRelease() {
        return false;
    }
}

