/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.task.live.commands;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.task.Command;
import org.nuxeo.connect.update.task.Task;
import org.nuxeo.connect.update.task.live.commands.Undeploy;
import org.nuxeo.connect.update.task.standalone.commands.CompositeCommand;
import org.nuxeo.connect.update.task.standalone.commands.DeployPlaceholder;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.reload.ReloadContext;
import org.nuxeo.runtime.reload.ReloadResult;
import org.nuxeo.runtime.reload.ReloadService;
import org.osgi.framework.BundleException;

public class Deploy
extends DeployPlaceholder {
    private static final Log log = LogFactory.getLog(Deploy.class);

    public Deploy() {
    }

    public Deploy(File file) {
        super(file);
    }

    @Deprecated
    protected Undeploy deployFile(File file, ReloadService service) throws PackageException {
        String name = service.getOSGIBundleName(file);
        if (name == null) {
            return null;
        }
        try {
            service.deployBundle(file, true);
        }
        catch (BundleException e) {
            throw new PackageException("Failed to deploy bundle " + file, (Throwable)e);
        }
        return new Undeploy(file);
    }

    @Deprecated
    protected CompositeCommand deployDirectory(File dir, ReloadService service) throws PackageException {
        CompositeCommand cmd = new CompositeCommand();
        File[] files = dir.listFiles();
        if (files != null) {
            for (File fileInDir : files) {
                Undeploy ud = this.deployFile(fileInDir, service);
                if (ud == null) continue;
                cmd.addCommand((Command)ud);
            }
        }
        if (cmd.isEmpty()) {
            return null;
        }
        return cmd;
    }

    protected Command doRun(Task task, Map<String, String> prefs) throws PackageException {
        if (!this.file.exists()) {
            log.warn((Object)("Can't deploy file " + this.file + ". File is missing."));
            return null;
        }
        ReloadService srv = (ReloadService)Framework.getService(ReloadService.class);
        boolean useCompatReload = Framework.isBooleanPropertyTrue((String)"nuxeo.hotreload.compat.mechanism");
        if (useCompatReload) {
            return this.doCompatRun(srv);
        }
        if (this.file.isDirectory()) {
            return this._deployDirectory(this.file, srv);
        }
        return this._deployFile(this.file, srv);
    }

    @Deprecated
    protected Command doCompatRun(ReloadService srv) throws PackageException {
        Object rollback = this.file.isDirectory() ? this.deployDirectory(this.file, srv) : this.deployFile(this.file, srv);
        if (rollback != null) {
            try {
                srv.runDeploymentPreprocessor();
            }
            catch (IOException e) {
                throw new PackageException(e.getMessage(), (Throwable)e);
            }
        }
        return rollback;
    }

    protected Undeploy _deployFile(File file, ReloadService service) throws PackageException {
        String name = service.getOSGIBundleName(file);
        if (name == null) {
            return null;
        }
        try {
            ReloadResult result = service.reloadBundles(new ReloadContext().deploy(new File[]{file}));
            return result.deployedFilesAsStream().map(Undeploy::new).findFirst().orElseThrow(() -> new IllegalStateException("Bundle " + file + " wasn't deployed"));
        }
        catch (BundleException e) {
            throw new PackageException("Failed to deploy bundle " + file, (Throwable)e);
        }
    }

    protected CompositeCommand _deployDirectory(File dir, ReloadService service) throws PackageException {
        File[] files = dir.listFiles();
        if (files != null) {
            List bundles = Arrays.stream(files).filter(f -> service.getOSGIBundleName(f) != null).collect(Collectors.toList());
            if (bundles.isEmpty()) {
                return null;
            }
            try {
                ReloadResult result = service.reloadBundles(new ReloadContext().deploy(bundles));
                return result.deployedFilesAsStream().map(Undeploy::new).collect(Collector.of(CompositeCommand::new, CompositeCommand::addCommand, CompositeCommand::combine, new Collector.Characteristics[0]));
            }
            catch (BundleException e) {
                throw new PackageException("Failed to deploy bundles " + bundles, (Throwable)e);
            }
        }
        return null;
    }
}

