/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.comment.api;

import java.io.Serializable;
import java.time.Instant;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.comment.api.Annotation;
import org.nuxeo.ecm.platform.comment.api.AnnotationImpl;
import org.nuxeo.ecm.platform.comment.api.Comment;
import org.nuxeo.ecm.platform.comment.api.CommentImpl;
import org.nuxeo.ecm.platform.comment.api.ExternalEntity;

public class Comments {
    private Comments() {
    }

    public static void commentToDocumentModel(Comment comment, DocumentModel documentModel) {
        Instant modificationDate;
        documentModel.setPropertyValue("comment:author", (Serializable)((Object)comment.getAuthor()));
        documentModel.setPropertyValue("comment:text", (Serializable)((Object)comment.getText()));
        documentModel.setPropertyValue("comment:parentId", (Serializable)((Object)comment.getParentId()));
        Instant creationDate = comment.getCreationDate();
        if (creationDate != null) {
            documentModel.setPropertyValue("comment:creationDate", (Serializable)Date.from(creationDate));
        }
        if ((modificationDate = comment.getModificationDate()) != null) {
            documentModel.setPropertyValue("comment:modificationDate", (Serializable)Date.from(modificationDate));
        }
    }

    public static void annotationToDocumentModel(Annotation annotation, DocumentModel documentModel) {
        Comments.commentToDocumentModel(annotation, documentModel);
        documentModel.setPropertyValue("annotation:xpath", (Serializable)((Object)annotation.getXpath()));
    }

    public static void externalEntityToDocumentModel(ExternalEntity entity, DocumentModel documentModel) {
        documentModel.setPropertyValue("externalEntity:entityId", (Serializable)((Object)entity.getEntityId()));
        documentModel.setPropertyValue("externalEntity:origin", (Serializable)((Object)entity.getOrigin()));
        documentModel.setPropertyValue("externalEntity:entity", (Serializable)((Object)entity.getEntity()));
    }

    public static void documentModelToComment(DocumentModel documentModel, Comment comment) {
        Calendar modificationDate;
        comment.setId(documentModel.getId());
        comment.setAuthor((String)((Object)documentModel.getPropertyValue("comment:author")));
        comment.setText((String)((Object)documentModel.getPropertyValue("comment:text")));
        Collection ancestorIds = (Collection)((Object)documentModel.getPropertyValue("comment:ancestorIds"));
        ancestorIds.forEach(comment::addAncestorId);
        String parentId = (String)((Object)documentModel.getPropertyValue("comment:parentId"));
        comment.setParentId(parentId);
        Calendar creationDate = (Calendar)documentModel.getPropertyValue("comment:creationDate");
        if (creationDate != null) {
            comment.setCreationDate(creationDate.toInstant());
        }
        if ((modificationDate = (Calendar)documentModel.getPropertyValue("comment:modificationDate")) != null) {
            comment.setModificationDate(modificationDate.toInstant());
        }
    }

    public static void documentModelToAnnotation(DocumentModel documentModel, Annotation annotation) {
        Comments.documentModelToComment(documentModel, annotation);
        annotation.setXpath((String)((Object)documentModel.getPropertyValue("annotation:xpath")));
    }

    public static void documentModelToExternalEntity(DocumentModel documentModel, ExternalEntity entity) {
        if (documentModel.hasFacet("ExternalEntity")) {
            entity.setEntityId((String)((Object)documentModel.getPropertyValue("externalEntity:entityId")));
            entity.setOrigin((String)((Object)documentModel.getPropertyValue("externalEntity:origin")));
            entity.setEntity((String)((Object)documentModel.getPropertyValue("externalEntity:entity")));
        }
    }

    public static Comment newComment(DocumentModel commentModel) {
        CommentImpl comment = new CommentImpl();
        Comments.documentModelToComment(commentModel, comment);
        Comments.documentModelToExternalEntity(commentModel, comment);
        return comment;
    }

    public static Annotation newAnnotation(DocumentModel annotationModel) {
        AnnotationImpl annotation = new AnnotationImpl();
        Comments.documentModelToAnnotation(annotationModel, annotation);
        Comments.documentModelToExternalEntity(annotationModel, annotation);
        return annotation;
    }
}

