/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth2.tokens;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.query.sql.model.Predicate;
import org.nuxeo.ecm.core.query.sql.model.Predicates;
import org.nuxeo.ecm.core.query.sql.model.QueryBuilder;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.oauth2.enums.NuxeoOAuth2TokenType;
import org.nuxeo.ecm.platform.oauth2.tokens.NuxeoOAuth2Token;
import org.nuxeo.ecm.platform.oauth2.tokens.OAuth2TokenService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.DefaultComponent;

public class OAuth2TokenServiceImpl
extends DefaultComponent
implements OAuth2TokenService {
    public static final String TOKEN_DIR = "oauth2Tokens";

    @Override
    public List<NuxeoOAuth2Token> getTokens(NuxeoPrincipal principal) {
        return this.findTokens(this.getQueryBuilder(null, null), principal);
    }

    @Override
    public List<NuxeoOAuth2Token> getTokens(String nxuser) {
        Objects.requireNonNull(nxuser, "nxuser cannot be null");
        return this.findTokens(this.getQueryBuilder(nxuser, null));
    }

    @Override
    public List<NuxeoOAuth2Token> getTokens(NuxeoOAuth2TokenType type, NuxeoPrincipal principal) {
        Objects.requireNonNull(type, "oAuth2TokenType cannot be null");
        return this.findTokens(this.getQueryBuilder(null, type), principal);
    }

    @Override
    public List<NuxeoOAuth2Token> getTokens(String nxuser, NuxeoOAuth2TokenType type) {
        Objects.requireNonNull(nxuser, "nxuser cannot be null");
        Objects.requireNonNull(type, "oAuth2TokenType cannot be null");
        return this.findTokens(this.getQueryBuilder(nxuser, type));
    }

    @Override
    public List<NuxeoOAuth2Token> search(String query, NuxeoPrincipal principal) {
        return this.findTokens(this.getQueryBuilder(query), principal);
    }

    protected List<NuxeoOAuth2Token> findTokens(QueryBuilder queryBuilder) {
        return this.findTokens(queryBuilder, null);
    }

    protected List<NuxeoOAuth2Token> findTokens(QueryBuilder queryBuilder, NuxeoPrincipal principal) {
        if (principal != null) {
            this.checkPermission(principal);
        }
        return (List)Framework.doPrivileged(() -> {
            DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
            try (Session session = ds.open(TOKEN_DIR);){
                DocumentModelList documents = session.query(queryBuilder, false);
                List list = documents.stream().map(NuxeoOAuth2Token::new).collect(Collectors.toList());
                return list;
            }
        });
    }

    protected void checkPermission(NuxeoPrincipal principal) {
        if (!principal.isAdministrator()) {
            throw new NuxeoException("You do not have permissions to perform this operation.", 403);
        }
    }

    protected QueryBuilder getQueryBuilder(String query) {
        if (StringUtils.isEmpty((CharSequence)query)) {
            throw new NuxeoException("query is required", 400);
        }
        String match = String.format("%%%s%%", query);
        return new QueryBuilder().predicate(Predicates.or((Predicate)Predicates.like((String)"nuxeoLogin", (Object)match), (Predicate)Predicates.like((String)"serviceName", (Object)match)));
    }

    protected QueryBuilder getQueryBuilder(String nxuser, NuxeoOAuth2TokenType type) {
        QueryBuilder queryBuilder = new QueryBuilder();
        if (nxuser != null) {
            queryBuilder.predicate(Predicates.eq((String)"nuxeoLogin", (Object)nxuser));
        }
        if (type != null) {
            queryBuilder.predicate(type.getPredicate());
        }
        return queryBuilder;
    }
}

