/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.event.impl;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.common.logging.SequenceTracer;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventStats;
import org.nuxeo.ecm.core.event.ReconnectedEventBundle;
import org.nuxeo.ecm.core.event.impl.EventListenerDescriptor;
import org.nuxeo.ecm.core.event.impl.ReconnectedEventBundleImpl;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class PostCommitEventExecutor {
    private static final Logger log = LogManager.getLogger(PostCommitEventExecutor.class);
    public static final String TIMEOUT_MS_PROP = "org.nuxeo.ecm.core.event.tx.PostCommitExecutor.timeoutMs";
    public static final int DEFAULT_TIMEOUT_MS = 300;
    public static final int DEFAULT_TIMEOUT_TEST_MS = 60000;
    private Integer defaultTimeoutMs;
    public static final String DEFAULT_BULK_TIMEOUT_S = "600";
    public static final String BULK_TIMEOUT_PROP = "org.nuxeo.ecm.core.event.tx.BulkExecutor.timeout";
    private static final long KEEP_ALIVE_TIME_SECOND = 10L;
    private static final int MAX_POOL_SIZE = 100;
    protected final ExecutorService executor;

    public PostCommitEventExecutor() {
        NamedThreadFactory threadFactory = new NamedThreadFactory("Nuxeo-Event-PostCommit-");
        this.executor = new ThreadPoolExecutor(0, 100, 10L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory);
        ((ThreadPoolExecutor)this.executor).allowCoreThreadTimeOut(true);
    }

    protected int getDefaultTimeoutMs() {
        if (this.defaultTimeoutMs == null) {
            this.defaultTimeoutMs = Framework.getProperty((String)TIMEOUT_MS_PROP) != null ? Integer.valueOf(Integer.parseInt(Framework.getProperty((String)TIMEOUT_MS_PROP))) : (Framework.isTestModeSet() ? Integer.valueOf(60000) : Integer.valueOf(300));
        }
        return this.defaultTimeoutMs;
    }

    public void shutdown(long timeoutMillis) throws InterruptedException {
        this.executor.shutdown();
        this.executor.awaitTermination(timeoutMillis, TimeUnit.MILLISECONDS);
        if (!this.executor.isTerminated()) {
            this.executor.shutdownNow();
        }
    }

    public void run(List<EventListenerDescriptor> listeners, EventBundle event) {
        log.warn("Running post commit event listeners: {}. Post commit event listener execution will soon be deprecated, see NXP-27986. As explained in NXP-26911, please update your post commit event listener contributions to make the listeners asynchronous with <listener async=\"true\"...>.\n You can disable this warning by following the instructions provided in NXP-26911.", listeners);
        this.run(listeners, event, this.getDefaultTimeoutMs(), false);
    }

    public void runBulk(List<EventListenerDescriptor> listeners, EventBundle event) {
        String timeoutSeconds = Framework.getProperty((String)BULK_TIMEOUT_PROP, (String)DEFAULT_BULK_TIMEOUT_S);
        this.run(listeners, event, Long.parseLong(timeoutSeconds) * 1000L, true);
    }

    public void run(List<EventListenerDescriptor> listeners, EventBundle bundle, long timeoutMillis, boolean bulk) {
        boolean some = false;
        for (EventListenerDescriptor listener : listeners) {
            if (!listener.acceptBundle(bundle)) continue;
            some = true;
            break;
        }
        if (!some) {
            log.debug("Events postcommit execution has nothing to do");
            return;
        }
        log.debug("Events postcommit execution starting with timeout {}ms{}", new Supplier[]{() -> timeoutMillis, () -> bulk ? " in bulk mode" : ""});
        Callable<Boolean> callable = !bulk ? new EventBundleRunner(listeners, bundle) : new EventBundleBulkRunner(listeners, bundle);
        FutureTask<Boolean> futureTask = new FutureTask<Boolean>(callable);
        try {
            this.executor.execute(futureTask);
        }
        catch (RejectedExecutionException e) {
            log.error("Events postcommit execution rejected", (Throwable)e);
            return;
        }
        try {
            Boolean ok = futureTask.get(timeoutMillis, TimeUnit.MILLISECONDS);
            if (Boolean.FALSE.equals(ok)) {
                log.error("Events postcommit bulk execution aborted due to previous error");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            futureTask.cancel(true);
        }
        catch (TimeoutException e) {
            if (!bulk) {
                log.info("Events postcommit execution exceeded timeout of {}ms, leaving thread running", new Supplier[]{() -> timeoutMillis});
            } else {
                log.error("Events postcommit bulk execution exceeded timeout of {}ms, interrupting thread", new Supplier[]{() -> timeoutMillis});
                futureTask.cancel(true);
            }
        }
        catch (ExecutionException e) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = e::getCause;
            log.error("Events postcommit execution encountered unexpected exception", supplierArray);
        }
        log.debug("Events postcommit execution finished");
    }

    protected static class EventBundleBulkRunner
    implements Callable<Boolean> {
        protected final List<EventListenerDescriptor> listeners;
        protected final EventBundle bundle;
        protected final String callerThread;

        public EventBundleBulkRunner(List<EventListenerDescriptor> listeners, EventBundle bundle) {
            this.listeners = listeners;
            this.bundle = bundle;
            this.callerThread = SequenceTracer.getThreadName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() {
            block26: {
                SequenceTracer.startFrom((String)this.callerThread, (String)"BulkPostcommit", (String)"#ff410f");
                log.debug("Events postcommit bulk execution starting in thread: {}", new Supplier[]{() -> Thread.currentThread().getName()});
                long t0 = System.currentTimeMillis();
                boolean ok = false;
                boolean interrupt = false;
                ReconnectedEventBundle reconnected = null;
                boolean tx = TransactionHelper.startTransaction();
                reconnected = new ReconnectedEventBundleImpl(this.bundle, this.listeners.toString());
                for (EventListenerDescriptor listener : this.listeners) {
                    EventBundle filtered = listener.filterBundle(reconnected);
                    if (filtered.isEmpty()) continue;
                    SequenceTracer.start((String)("run listener " + listener.getName()));
                    Supplier[] supplierArray = new Supplier[1];
                    supplierArray[0] = listener::getName;
                    log.debug("Events postcommit bulk execution start for listener: {}", supplierArray);
                    long t1 = System.currentTimeMillis();
                    try {
                        listener.asPostCommitListener().handleEvent(filtered);
                        if (Thread.currentThread().isInterrupted()) {
                            Supplier[] supplierArray2 = new Supplier[1];
                            supplierArray2[0] = listener::getName;
                            log.error("Events postcommit bulk execution interrupted for listener: {}, will rollback and abort bulk processing", supplierArray2);
                            interrupt = true;
                        }
                    }
                    catch (RuntimeException e) {
                        Boolean bl;
                        try {
                            Supplier[] supplierArray3 = new Supplier[2];
                            supplierArray3[0] = listener::getName;
                            supplierArray3[1] = () -> e;
                            log.error("Events postcommit bulk execution encountered exception for listener: {}", supplierArray3);
                            bl = Boolean.FALSE;
                        }
                        catch (Throwable throwable) {
                            long elapsed = System.currentTimeMillis() - t1;
                            Supplier[] supplierArray4 = new Supplier[2];
                            supplierArray4[0] = listener::getName;
                            supplierArray4[1] = () -> elapsed;
                            log.debug("Events postcommit bulk execution end for listener: {} in {}ms", supplierArray4);
                            SequenceTracer.stop((String)("listener done " + elapsed + " ms"));
                            throw throwable;
                        }
                        long elapsed = System.currentTimeMillis() - t1;
                        Supplier[] supplierArray5 = new Supplier[2];
                        supplierArray5[0] = listener::getName;
                        supplierArray5[1] = () -> elapsed;
                        log.debug("Events postcommit bulk execution end for listener: {} in {}ms", supplierArray5);
                        SequenceTracer.stop((String)("listener done " + elapsed + " ms"));
                        try {
                            if (reconnected != null) {
                                reconnected.disconnect();
                            }
                        }
                        finally {
                            if (tx) {
                                if (!ok) {
                                    TransactionHelper.setTransactionRollbackOnly();
                                    log.error("Rolling back transaction");
                                }
                                TransactionHelper.commitOrRollbackTransaction();
                            }
                        }
                        elapsed = System.currentTimeMillis() - t0;
                        SequenceTracer.stop((String)("BulkPostcommit done " + elapsed + " ms"));
                        log.debug("Events postcommit bulk execution finished in {}ms", (Object)elapsed);
                        return bl;
                    }
                    long elapsed = System.currentTimeMillis() - t1;
                    Supplier[] supplierArray6 = new Supplier[2];
                    supplierArray6[0] = listener::getName;
                    supplierArray6[1] = () -> elapsed;
                    log.debug("Events postcommit bulk execution end for listener: {} in {}ms", supplierArray6);
                    SequenceTracer.stop((String)("listener done " + elapsed + " ms"));
                    if (!interrupt) continue;
                    break;
                }
                ok = !interrupt;
                break block26;
                finally {
                    try {
                        if (reconnected != null) {
                            reconnected.disconnect();
                        }
                    }
                    finally {
                        if (tx) {
                            if (!ok) {
                                TransactionHelper.setTransactionRollbackOnly();
                                log.error("Rolling back transaction");
                            }
                            TransactionHelper.commitOrRollbackTransaction();
                        }
                    }
                    long elapsed = System.currentTimeMillis() - t0;
                    SequenceTracer.stop((String)("BulkPostcommit done " + elapsed + " ms"));
                    log.debug("Events postcommit bulk execution finished in {}ms", (Object)elapsed);
                }
            }
            return Boolean.TRUE;
        }
    }

    protected static class EventBundleRunner
    implements Callable<Boolean> {
        protected final List<EventListenerDescriptor> listeners;
        protected final EventBundle bundle;
        protected String callerThread;

        public EventBundleRunner(List<EventListenerDescriptor> listeners, EventBundle bundle) {
            this.listeners = listeners;
            this.bundle = bundle;
            this.callerThread = SequenceTracer.getThreadName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public Boolean call() {
            log.debug("Events postcommit execution starting in thread: {}", new Supplier[]{() -> Thread.currentThread().getName()});
            SequenceTracer.startFrom((String)this.callerThread, (String)"Postcommit", (String)"#ff410f");
            long t0 = System.currentTimeMillis();
            EventStats stats = (EventStats)Framework.getService(EventStats.class);
            for (EventListenerDescriptor listener : this.listeners) {
                boolean tx;
                ReconnectedEventBundle reconnected;
                boolean ok;
                long t1;
                block26: {
                    block27: {
                        EventBundle filtered = listener.filterBundle(this.bundle);
                        if (filtered.isEmpty()) continue;
                        Supplier[] supplierArray = new Supplier[1];
                        supplierArray[0] = listener::getName;
                        log.debug("Events postcommit execution start for listener: {}", supplierArray);
                        SequenceTracer.start((String)("run listener " + listener.getName()));
                        t1 = System.currentTimeMillis();
                        ok = false;
                        reconnected = null;
                        tx = TransactionHelper.startTransaction();
                        reconnected = new ReconnectedEventBundleImpl(filtered, this.listeners.toString());
                        listener.asPostCommitListener().handleEvent(reconnected);
                        ok = true;
                        try {
                            if (reconnected != null) {
                                reconnected.disconnect();
                            }
                            if (!tx) break block26;
                            if (ok) break block27;
                        }
                        catch (Throwable throwable) {
                            if (tx) {
                                if (!ok) {
                                    TransactionHelper.setTransactionRollbackOnly();
                                    log.error("Rolling back transaction");
                                }
                                TransactionHelper.commitOrRollbackTransaction();
                            }
                            long elapsed = System.currentTimeMillis() - t1;
                            if (stats != null) {
                                stats.logAsyncExec(listener, elapsed);
                            }
                            Supplier[] supplierArray2 = new Supplier[2];
                            supplierArray2[0] = listener::getName;
                            supplierArray2[1] = () -> elapsed;
                            log.debug("Events postcommit execution end for listener: {} in {}ms", supplierArray2);
                            SequenceTracer.stop((String)("listener done " + elapsed + " ms"));
                            throw throwable;
                        }
                        TransactionHelper.setTransactionRollbackOnly();
                        log.error("Rolling back transaction");
                    }
                    TransactionHelper.commitOrRollbackTransaction();
                }
                long elapsed = System.currentTimeMillis() - t1;
                if (stats != null) {
                    stats.logAsyncExec(listener, elapsed);
                }
                Supplier[] supplierArray = new Supplier[2];
                supplierArray[0] = listener::getName;
                supplierArray[1] = () -> elapsed;
                log.debug("Events postcommit execution end for listener: {} in {}ms", supplierArray);
                SequenceTracer.stop((String)("listener done " + elapsed + " ms"));
                continue;
                catch (RuntimeException e) {
                    block28: {
                        block29: {
                            try {
                                Supplier[] supplierArray3 = new Supplier[2];
                                supplierArray3[0] = listener::getName;
                                supplierArray3[1] = () -> e;
                                log.error("Events postcommit execution encountered exception for listener: {}", supplierArray3);
                            }
                            catch (Throwable throwable) {
                                block30: {
                                    block31: {
                                        try {
                                            if (reconnected != null) {
                                                reconnected.disconnect();
                                            }
                                            if (!tx) break block30;
                                            if (ok) break block31;
                                        }
                                        catch (Throwable throwable2) {
                                            if (tx) {
                                                if (!ok) {
                                                    TransactionHelper.setTransactionRollbackOnly();
                                                    log.error("Rolling back transaction");
                                                }
                                                TransactionHelper.commitOrRollbackTransaction();
                                            }
                                            long elapsed2 = System.currentTimeMillis() - t1;
                                            if (stats != null) {
                                                stats.logAsyncExec(listener, elapsed2);
                                            }
                                            Supplier[] supplierArray4 = new Supplier[2];
                                            supplierArray4[0] = listener::getName;
                                            supplierArray4[1] = () -> elapsed;
                                            log.debug("Events postcommit execution end for listener: {} in {}ms", supplierArray4);
                                            SequenceTracer.stop((String)("listener done " + elapsed2 + " ms"));
                                            throw throwable2;
                                        }
                                        TransactionHelper.setTransactionRollbackOnly();
                                        log.error("Rolling back transaction");
                                    }
                                    TransactionHelper.commitOrRollbackTransaction();
                                }
                                long elapsed3 = System.currentTimeMillis() - t1;
                                if (stats != null) {
                                    stats.logAsyncExec(listener, elapsed3);
                                }
                                Supplier[] supplierArray5 = new Supplier[2];
                                supplierArray5[0] = listener::getName;
                                supplierArray5[1] = () -> elapsed;
                                log.debug("Events postcommit execution end for listener: {} in {}ms", supplierArray5);
                                SequenceTracer.stop((String)("listener done " + elapsed3 + " ms"));
                                throw throwable;
                            }
                            try {
                                if (reconnected != null) {
                                    reconnected.disconnect();
                                }
                                if (!tx) break block28;
                                if (ok) break block29;
                            }
                            catch (Throwable throwable) {
                                if (tx) {
                                    if (!ok) {
                                        TransactionHelper.setTransactionRollbackOnly();
                                        log.error("Rolling back transaction");
                                    }
                                    TransactionHelper.commitOrRollbackTransaction();
                                }
                                long elapsed4 = System.currentTimeMillis() - t1;
                                if (stats != null) {
                                    stats.logAsyncExec(listener, elapsed4);
                                }
                                Supplier[] supplierArray6 = new Supplier[2];
                                supplierArray6[0] = listener::getName;
                                supplierArray6[1] = () -> elapsed;
                                log.debug("Events postcommit execution end for listener: {} in {}ms", supplierArray6);
                                SequenceTracer.stop((String)("listener done " + elapsed4 + " ms"));
                                throw throwable;
                            }
                            TransactionHelper.setTransactionRollbackOnly();
                            log.error("Rolling back transaction");
                        }
                        TransactionHelper.commitOrRollbackTransaction();
                    }
                    elapsed = System.currentTimeMillis() - t1;
                    if (stats != null) {
                        stats.logAsyncExec(listener, elapsed);
                    }
                    Supplier[] supplierArray7 = new Supplier[2];
                    supplierArray7[0] = listener::getName;
                    supplierArray7[1] = () -> elapsed;
                    log.debug("Events postcommit execution end for listener: {} in {}ms", supplierArray7);
                    SequenceTracer.stop((String)("listener done " + elapsed + " ms"));
                }
            }
            long elapsed = System.currentTimeMillis() - t0;
            log.debug("Events postcommit execution finished in {}ms", (Object)elapsed);
            SequenceTracer.stop((String)("postcommit done" + elapsed + " ms"));
            return Boolean.TRUE;
        }
    }

    private static class NamedThreadFactory
    implements ThreadFactory {
        private final AtomicInteger threadNumber = new AtomicInteger();
        private final ThreadGroup group;
        private final String prefix;

        public NamedThreadFactory(String prefix) {
            SecurityManager sm = System.getSecurityManager();
            this.group = sm == null ? Thread.currentThread().getThreadGroup() : sm.getThreadGroup();
            this.prefix = prefix;
        }

        @Override
        public Thread newThread(Runnable r) {
            String name = this.prefix + this.threadNumber.incrementAndGet();
            Thread thread = new Thread(this.group, r, name);
            thread.setPriority(5);
            return thread;
        }
    }
}

