/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.cache;

import java.io.Serializable;
import org.nuxeo.ecm.core.cache.CacheManagement;
import org.nuxeo.ecm.core.cache.CacheServiceImpl;
import org.nuxeo.ecm.core.cache.CacheWrapper;

public class CacheInvalidator
extends CacheWrapper {
    protected final CacheServiceImpl.CachePubSubInvalidator invalidator;

    public CacheInvalidator(CacheManagement cache, CacheServiceImpl.CachePubSubInvalidator invalidator) {
        super(cache);
        this.invalidator = invalidator;
    }

    @Override
    public void put(String key, Serializable value) {
        super.put(key, value);
        this.invalidator.sendInvalidation(this.getName(), key);
    }

    @Override
    public void invalidate(String key) {
        super.invalidate(key);
        this.invalidator.sendInvalidation(this.getName(), key);
    }

    @Override
    public void invalidateAll() {
        super.invalidateAll();
        this.invalidator.sendInvalidationsAll(this.getName());
    }
}

