/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.apache.poi.hslf.exceptions.CorruptPowerPointFileException;
import org.apache.poi.hslf.exceptions.HSLFException;
import org.apache.poi.hslf.record.PositionDependentRecord;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public abstract class Record {
    protected static final POILogger logger = POILogFactory.getLogger(Record.class);

    public abstract boolean isAnAtom();

    public abstract long getRecordType();

    public abstract Record[] getChildRecords();

    public abstract void writeOut(OutputStream var1) throws IOException;

    public static void writeLittleEndian(int i, OutputStream o) throws IOException {
        byte[] bi = new byte[4];
        LittleEndian.putInt((byte[])bi, (int)0, (int)i);
        o.write(bi);
    }

    public static void writeLittleEndian(short s, OutputStream o) throws IOException {
        byte[] bs = new byte[2];
        LittleEndian.putShort((byte[])bs, (int)0, (short)s);
        o.write(bs);
    }

    public static Record buildRecordAtOffset(byte[] b, int offset) {
        long type = LittleEndian.getUShort((byte[])b, (int)(offset + 2));
        long rlen = LittleEndian.getUInt((byte[])b, (int)(offset + 4));
        int rleni = (int)rlen;
        if (rleni < 0) {
            rleni = 0;
        }
        return Record.createRecordForType(type, b, offset, 8 + rleni);
    }

    public static Record[] findChildRecords(byte[] b, int start, int len) {
        int rleni;
        ArrayList<Record> children = new ArrayList<Record>(5);
        for (int pos = start; pos <= start + len - 8; pos += rleni) {
            long type = LittleEndian.getUShort((byte[])b, (int)(pos + 2));
            long rlen = LittleEndian.getUInt((byte[])b, (int)(pos + 4));
            rleni = (int)rlen;
            if (rleni < 0) {
                rleni = 0;
            }
            if (pos == 0 && type == 0L && rleni == 65535) {
                throw new CorruptPowerPointFileException("Corrupt document - starts with record of type 0000 and length 0xFFFF");
            }
            Record r = Record.createRecordForType(type, b, pos, 8 + rleni);
            if (r != null) {
                children.add(r);
            }
            pos += 8;
        }
        Record[] cRecords = children.toArray(new Record[children.size()]);
        return cRecords;
    }

    public static Record createRecordForType(long type, byte[] b, int start, int len) {
        Record toReturn = null;
        if (start + len > b.length) {
            logger.log(5, new Object[]{"Warning: Skipping record of type " + type + " at position " + start + " which claims to be longer than the file! (" + len + " vs " + (b.length - start) + ")"});
            return null;
        }
        Class<? extends Record> c = null;
        try {
            c = RecordTypes.forTypeID((int)((short)((int)type))).handlingClass;
            if (c == null) {
                c = RecordTypes.UnknownRecordPlaceholder.handlingClass;
            }
            Constructor<? extends Record> con = c.getDeclaredConstructor(byte[].class, Integer.TYPE, Integer.TYPE);
            toReturn = con.newInstance(b, start, len);
        }
        catch (InstantiationException ie) {
            throw new HSLFException("Couldn't instantiate the class for type with id " + type + " on class " + c + " : " + ie, ie);
        }
        catch (InvocationTargetException ite) {
            throw new HSLFException("Couldn't instantiate the class for type with id " + type + " on class " + c + " : " + ite + "\nCause was : " + ite.getCause(), ite);
        }
        catch (IllegalAccessException iae) {
            throw new HSLFException("Couldn't access the constructor for type with id " + type + " on class " + c + " : " + iae, iae);
        }
        catch (NoSuchMethodException nsme) {
            throw new HSLFException("Couldn't access the constructor for type with id " + type + " on class " + c + " : " + nsme, nsme);
        }
        if (toReturn instanceof PositionDependentRecord) {
            PositionDependentRecord pdr = (PositionDependentRecord)((Object)toReturn);
            pdr.setLastOnDiskOffset(start);
        }
        return toReturn;
    }
}

