/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.management.works;

import org.nuxeo.ecm.core.management.works.WorksQueueMonitoringMBean;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.core.work.api.WorkQueueMetrics;
import org.nuxeo.runtime.api.Framework;

public class WorksQueueMonitoring
implements WorksQueueMonitoringMBean {
    protected final String queueId;

    public WorksQueueMonitoring(String id) {
        this.queueId = id;
    }

    protected WorkManager manager() {
        return (WorkManager)Framework.getService(WorkManager.class);
    }

    @Override
    public long[] getMetrics() {
        WorkQueueMetrics metrics = this.manager().getMetrics(this.queueId);
        return new long[]{metrics.scheduled.longValue(), metrics.running.longValue(), metrics.completed.longValue(), metrics.canceled.longValue()};
    }

    @Override
    public boolean isProcessing() {
        return this.manager().isProcessingEnabled(this.queueId);
    }

    @Override
    public boolean toggleProcessing() {
        WorkManager manager = this.manager();
        boolean enabled = !manager.isProcessingEnabled(this.queueId);
        manager.enableProcessing(this.queueId, enabled);
        return enabled;
    }
}

