/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.helper;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.publisher.api.PublicationTree;
import org.nuxeo.ecm.platform.publisher.api.PublisherService;
import org.nuxeo.ecm.platform.relations.api.Node;
import org.nuxeo.ecm.platform.relations.api.QNameResource;
import org.nuxeo.ecm.platform.relations.api.RelationManager;
import org.nuxeo.ecm.platform.relations.api.Resource;
import org.nuxeo.ecm.platform.relations.api.Statement;
import org.nuxeo.ecm.platform.relations.api.impl.QNameResourceImpl;
import org.nuxeo.ecm.platform.relations.api.impl.ResourceImpl;
import org.nuxeo.ecm.platform.relations.api.impl.StatementImpl;
import org.nuxeo.ecm.platform.relations.api.util.RelationHelper;
import org.nuxeo.runtime.api.Framework;

public class PublicationRelationHelper {
    public static final String PUBLICATION_GRAPH_NAME = "publication";
    public static final String PUBLICATION_TREE_NAMESPACE = "http://www.nuxeo.org/publication/tree/";
    public static final Resource PUBLISHED_BY = new ResourceImpl("http://www.nuxeo.org/publication/publishedBy");
    private static Log log = LogFactory.getLog(PublicationRelationHelper.class);

    private PublicationRelationHelper() {
    }

    public static void addPublicationRelation(DocumentModel documentModel, PublicationTree publicationTree) {
        RelationManager rm = RelationHelper.getRelationManager();
        QNameResource docResource = RelationHelper.getDocumentResource((DocumentModel)documentModel);
        QNameResourceImpl treeResource = new QNameResourceImpl(PUBLICATION_TREE_NAMESPACE, publicationTree.getConfigName());
        StatementImpl stmt = new StatementImpl((Node)docResource, (Node)PUBLISHED_BY, (Node)treeResource);
        rm.getGraphByName(PUBLICATION_GRAPH_NAME).add((Statement)stmt);
    }

    public static void removePublicationRelation(DocumentModel documentModel) {
        List stmts = RelationHelper.getStatements((String)PUBLICATION_GRAPH_NAME, (DocumentModel)documentModel, (Resource)PUBLISHED_BY);
        RelationManager rm = RelationHelper.getRelationManager();
        if (stmts != null) {
            rm.getGraphByName(PUBLICATION_GRAPH_NAME).remove(stmts);
        }
    }

    public static boolean isPublished(DocumentModel documentModel) {
        List stmts = RelationHelper.getStatements((String)PUBLICATION_GRAPH_NAME, (DocumentModel)documentModel, (Resource)PUBLISHED_BY);
        return stmts != null && !stmts.isEmpty();
    }

    public static PublicationTree getPublicationTreeUsedForPublishing(DocumentModel documentModel, CoreSession coreSession) {
        if (!PublicationRelationHelper.isPublished(documentModel)) {
            throw new NuxeoException("The document " + documentModel.getPathAsString() + " is not a published document");
        }
        List stmts = RelationHelper.getStatements((String)PUBLICATION_GRAPH_NAME, (DocumentModel)documentModel, (Resource)PUBLISHED_BY);
        Statement statement = (Statement)stmts.get(0);
        PublicationTree tree = null;
        Node node = statement.getObject();
        if (node.isQNameResource()) {
            QNameResource resource = (QNameResource)statement.getObject();
            String localName = resource.getLocalName();
            PublisherService publisherService = (PublisherService)Framework.getService(PublisherService.class);
            tree = publisherService.getPublicationTree(localName, coreSession, null);
        } else {
            log.error((Object)"Resource is not a QNameResource, check the namespace");
        }
        return tree;
    }
}

