/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.bulk.message;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class DataBucket
implements Serializable {
    private static final long serialVersionUID = 20181021L;
    protected String commandId;
    protected long count;
    protected byte[] data;
    protected byte[] header;
    protected byte[] footer;

    protected DataBucket() {
    }

    public DataBucket(String commandId, long count, String data) {
        this(commandId, count, data, "", "");
    }

    public DataBucket(String commandId, long count, byte[] data) {
        this(commandId, count, data, new byte[0], new byte[0]);
    }

    public DataBucket(String commandId, long count, String data, String header, String footer) {
        this(commandId, count, data.getBytes(StandardCharsets.UTF_8), header.getBytes(StandardCharsets.UTF_8), footer.getBytes(StandardCharsets.UTF_8));
    }

    public DataBucket(String commandId, long count, byte[] data, byte[] header, byte[] footer) {
        this.commandId = commandId;
        this.count = count;
        this.data = data;
        this.header = header;
        this.footer = footer;
    }

    public String getCommandId() {
        return this.commandId;
    }

    public long getCount() {
        return this.count;
    }

    public byte[] getData() {
        return this.data;
    }

    public byte[] getHeader() {
        return this.header;
    }

    public byte[] getFooter() {
        return this.footer;
    }

    public String getDataAsString() {
        return new String(this.data, StandardCharsets.UTF_8);
    }

    public String getHeaderAsString() {
        return new String(this.header, StandardCharsets.UTF_8);
    }

    public String getFooterAsString() {
        return new String(this.footer, StandardCharsets.UTF_8);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

