/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.trash;

import java.util.Collections;
import java.util.List;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;

public interface TrashService {
    public static final String DOCUMENT_TRASHED = "documentTrashed";
    public static final String DOCUMENT_UNTRASHED = "documentUntrashed";
    public static final String DISABLE_TRASH_RENAMING = "skipTrashRenaming";

    public boolean isTrashed(CoreSession var1, DocumentRef var2);

    public boolean canPurgeOrUntrash(List<DocumentModel> var1, NuxeoPrincipal var2);

    default public boolean canPurgeOrUntrash(DocumentModel doc, NuxeoPrincipal principal) {
        return this.canPurgeOrUntrash(Collections.singletonList(doc), principal);
    }

    public DocumentModel getAboveDocument(DocumentModel var1, NuxeoPrincipal var2);

    public void trashDocuments(List<DocumentModel> var1);

    default public void trashDocument(DocumentModel doc) {
        this.trashDocuments(Collections.singletonList(doc));
    }

    public void purgeDocuments(CoreSession var1, List<DocumentRef> var2);

    public void purgeDocumentsUnder(DocumentModel var1);

    public void untrashDocuments(List<DocumentModel> var1);

    default public void untrashDocument(DocumentModel doc) {
        this.untrashDocuments(Collections.singletonList(doc));
    }

    public DocumentModelList getDocuments(DocumentModel var1);

    public String mangleName(DocumentModel var1);

    public String unmangleName(DocumentModel var1);

    public boolean hasFeature(Feature var1);

    public static enum Feature {
        TRASHED_STATE_IS_DEDUCED_FROM_LIFECYCLE,
        TRASHED_STATE_IN_MIGRATION,
        TRASHED_STATE_IS_DEDICATED_PROPERTY;

    }
}

