/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob.binary;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.common.xmap.XMap;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.blob.binary.Binary;
import org.nuxeo.ecm.core.blob.binary.BinaryBlob;
import org.nuxeo.ecm.core.blob.binary.BinaryGarbageCollector;
import org.nuxeo.ecm.core.blob.binary.BinaryManager;
import org.nuxeo.ecm.core.blob.binary.BinaryManagerRootDescriptor;

public abstract class AbstractBinaryManager
implements BinaryManager {
    public static final String MD5_DIGEST = "MD5";
    public static final String SHA1_DIGEST = "SHA-1";
    public static final String SHA256_DIGEST = "SHA-256";
    public static final int MD5_DIGEST_LENGTH = 32;
    public static final int SHA1_DIGEST_LENGTH = 40;
    public static final int SHA256_DIGEST_LENGTH = 64;
    public static final HashMap<Integer, String> DIGESTS_BY_LENGTH = new HashMap();
    public static final String DEFAULT_DIGEST = "MD5";
    public static final int DEFAULT_DEPTH = 2;
    public String blobProviderId;
    protected BinaryManagerRootDescriptor descriptor;
    protected BinaryGarbageCollector garbageCollector;
    public static final int MIN_BUF_SIZE = 8192;
    public static final int MAX_BUF_SIZE = 65536;
    private static final char[] HEX_DIGITS = "0123456789abcdef".toCharArray();

    @Override
    public void initialize(String blobProviderId, Map<String, String> properties) throws IOException {
        this.blobProviderId = blobProviderId;
        DIGESTS_BY_LENGTH.put(32, "MD5");
        DIGESTS_BY_LENGTH.put(40, SHA1_DIGEST);
        DIGESTS_BY_LENGTH.put(64, SHA256_DIGEST);
    }

    protected abstract Binary getBinary(InputStream var1) throws IOException;

    @Override
    public Binary getBinary(Blob blob) throws IOException {
        Binary binary;
        if (blob instanceof BinaryBlob && (binary = ((BinaryBlob)blob).getBinary()).getBlobProviderId().equals(this.blobProviderId)) {
            return binary;
        }
        try (InputStream stream = blob.getStream();){
            Binary binary2 = this.getBinary(stream);
            return binary2;
        }
    }

    @Override
    public abstract Binary getBinary(String var1);

    @Override
    public void removeBinaries(Collection<String> digests) {
        throw new UnsupportedOperationException();
    }

    protected BinaryManagerRootDescriptor getDescriptor(File configFile) throws IOException {
        BinaryManagerRootDescriptor desc;
        if (configFile.exists()) {
            XMap xmap = new XMap();
            xmap.register(BinaryManagerRootDescriptor.class);
            try (FileInputStream in = new FileInputStream(configFile);){
                desc = (BinaryManagerRootDescriptor)xmap.load((InputStream)in);
            }
        } else {
            desc = new BinaryManagerRootDescriptor();
            desc.digest = this.getDefaultDigestAlgorithm();
            desc.depth = 2;
            desc.write(configFile);
        }
        return desc;
    }

    protected String storeAndDigest(InputStream in, OutputStream out) throws IOException {
        int n;
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance(this.getDigestAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            throw (IOException)new IOException().initCause(e);
        }
        int size = in.available();
        if (size == 0) {
            size = 65536;
        } else if (size < 8192) {
            size = 8192;
        } else if (size > 65536) {
            size = 65536;
        }
        byte[] buf = new byte[size];
        while ((n = in.read(buf)) != -1) {
            digest.update(buf, 0, n);
            out.write(buf, 0, n);
        }
        out.flush();
        return AbstractBinaryManager.toHexString(digest.digest());
    }

    public static String toHexString(byte[] data) {
        StringBuilder sb = new StringBuilder(2 * data.length);
        for (byte b : data) {
            sb.append(HEX_DIGITS[(0xF0 & b) >> 4]);
            sb.append(HEX_DIGITS[0xF & b]);
        }
        return sb.toString();
    }

    @Override
    public BinaryGarbageCollector getGarbageCollector() {
        return this.garbageCollector;
    }

    @Override
    public String getDigestAlgorithm() {
        return this.descriptor.digest;
    }

    protected String getDefaultDigestAlgorithm() {
        return "MD5";
    }
}

