/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.web.resources.wro.factory;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.web.resources.api.ResourceBundle;
import org.nuxeo.ecm.web.resources.api.ResourceContext;
import org.nuxeo.ecm.web.resources.api.ResourceContextImpl;
import org.nuxeo.ecm.web.resources.api.ResourceType;
import org.nuxeo.ecm.web.resources.api.service.WebResourceManager;
import org.nuxeo.ecm.web.resources.wro.provider.NuxeoUriLocator;
import org.nuxeo.runtime.api.Framework;
import ro.isdc.wro.model.WroModel;
import ro.isdc.wro.model.factory.WroModelFactory;
import ro.isdc.wro.model.group.Group;
import ro.isdc.wro.model.resource.Resource;

public class NuxeoWroModelFactory
implements WroModelFactory {
    private static final Log log = LogFactory.getLog(NuxeoWroModelFactory.class);

    public WroModel create() {
        WroModel model = new WroModel();
        WebResourceManager service = (WebResourceManager)Framework.getService(WebResourceManager.class);
        ResourceContextImpl rcontext = new ResourceContextImpl();
        List bundles = service.getResourceBundles();
        for (ResourceBundle bundle : bundles) {
            String groupName = bundle.getName();
            Group group = new Group(groupName);
            List resources = service.getResources((ResourceContext)rcontext, groupName, ResourceType.any.name());
            if (resources != null) {
                for (org.nuxeo.ecm.web.resources.api.Resource resource : resources) {
                    Resource wr = this.toWroResource(groupName, resource);
                    if (wr == null) continue;
                    group.addResource(wr);
                }
            }
            model.addGroup(group);
        }
        return model;
    }

    protected Resource toWroResource(String bundle, org.nuxeo.ecm.web.resources.api.Resource resource) {
        ro.isdc.wro.model.resource.ResourceType type = this.toWroResourceType(resource.getType());
        if (type == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cannot handle resource type '" + resource.getType() + "' for resource '" + resource.getName() + "'"));
            }
            return null;
        }
        String uri = NuxeoUriLocator.getUri(resource);
        if (uri == null) {
            log.error((Object)("Cannot handle resource '" + resource.getName() + "' for bundle '" + bundle + "': no uri resolved"));
            return null;
        }
        Resource res = Resource.create((String)uri, (ro.isdc.wro.model.resource.ResourceType)type);
        res.setMinimize(resource.isShrinkable());
        return res;
    }

    protected ro.isdc.wro.model.resource.ResourceType toWroResourceType(String type) {
        if (StringUtils.isBlank((CharSequence)type)) {
            return null;
        }
        if (ResourceType.js.name().equals(type.toLowerCase())) {
            return ro.isdc.wro.model.resource.ResourceType.JS;
        }
        if (ResourceType.css.name().equals(type.toLowerCase())) {
            return ro.isdc.wro.model.resource.ResourceType.CSS;
        }
        return null;
    }

    public void destroy() {
    }
}

