/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.util;

import com.fasterxml.jackson.databind.node.ObjectNode;
import javax.servlet.ServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.automation.core.util.JSONBlobDecoder;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.io.download.DownloadService;
import org.nuxeo.ecm.platform.web.common.RequestContext;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.runtime.api.Framework;

public class JSONObjectBlobDecoder
implements JSONBlobDecoder {
    private static final Logger log = LogManager.getLogger(JSONObjectBlobDecoder.class);
    public static final String DATA_FIELD_NAME = "data";

    @Override
    public Blob getBlobFromJSON(ObjectNode jsonObject) {
        if (!jsonObject.has(DATA_FIELD_NAME)) {
            return null;
        }
        String data = jsonObject.get(DATA_FIELD_NAME).textValue();
        if (data != null && data.startsWith("http")) {
            return this.getBlobFromURL(data);
        }
        return null;
    }

    protected Blob getBlobFromURL(String url) {
        RequestContext activeContext = RequestContext.getActiveContext();
        if (activeContext == null) {
            return null;
        }
        String baseURL = VirtualHostHelper.getBaseURL((ServletRequest)activeContext.getRequest());
        String path = url.replace(baseURL, "");
        Blob blob = ((DownloadService)Framework.getService(DownloadService.class)).resolveBlobFromDownloadUrl(path);
        if (blob == null) {
            log.debug("No Blob found for: {}", (Object)url);
            throw new NuxeoException(400);
        }
        return blob;
    }
}

