/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.jwt;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTCreationException;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.Field;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.jwt.JWTService;
import org.nuxeo.ecm.jwt.JWTServiceConfigurationDescriptor;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.SimpleContributionRegistry;

public class JWTServiceImpl
extends DefaultComponent
implements JWTService {
    private static final Log log = LogFactory.getLog(JWTServiceImpl.class);
    public static final String XP_CONFIGURATION = "configuration";
    public static final String NUXEO_ISSUER = "nuxeo";
    protected static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    protected static final TypeReference<Map<String, Object>> MAP_STRING_OBJECT = new TypeReference<Map<String, Object>>(){};
    protected final JWTServiceConfigurationRegistry registry = new JWTServiceConfigurationRegistry();

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (!XP_CONFIGURATION.equals(extensionPoint)) {
            throw new NuxeoException("Unknown extension point: " + extensionPoint);
        }
        this.registry.addContribution((JWTServiceConfigurationDescriptor)contribution);
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (XP_CONFIGURATION.equals(extensionPoint)) {
            this.registry.removeContribution((JWTServiceConfigurationDescriptor)contribution);
        }
    }

    @Override
    public JWTService.JWTBuilder newBuilder() {
        return new JWTBuilderImpl();
    }

    protected void builderWithClaim(JWTCreator.Builder builder, String name, Object value) {
        if (value instanceof Boolean) {
            builder.withClaim(name, (Boolean)value);
        } else if (value instanceof Date) {
            builder.withClaim(name, (Date)value);
        } else if (value instanceof Double) {
            builder.withClaim(name, (Double)value);
        } else if (value instanceof Integer) {
            builder.withClaim(name, (Integer)value);
        } else if (value instanceof Long) {
            builder.withClaim(name, (Long)value);
        } else if (value instanceof String) {
            builder.withClaim(name, (String)value);
        } else if (value instanceof Integer[]) {
            builder.withArrayClaim(name, (Integer[])value);
        } else if (value instanceof Long[]) {
            builder.withArrayClaim(name, (Long[])value);
        } else if (value instanceof String[]) {
            builder.withArrayClaim(name, (String[])value);
        } else {
            throw new NuxeoException("Unknown claim type: " + value);
        }
    }

    @Override
    public Map<String, Object> verifyToken(String token) {
        DecodedJWT jwt;
        Objects.requireNonNull(token);
        Algorithm algorithm = this.getAlgorithm();
        if (algorithm == null) {
            log.debug((Object)"secret not configured, cannot verify token");
            return null;
        }
        JWTVerifier verifier = JWT.require((Algorithm)algorithm).withIssuer(NUXEO_ISSUER).build();
        try {
            jwt = verifier.verify(token);
        }
        catch (JWTVerificationException e2) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("token verification failed: " + e2.toString()));
            }
            return null;
        }
        Object payload = JWTServiceImpl.getFieldValue(jwt, "payload");
        Map tree = (Map)JWTServiceImpl.getFieldValue(payload, "tree");
        return tree.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> JWTServiceImpl.nodeToValue((JsonNode)e.getValue())));
    }

    protected static Object nodeToValue(JsonNode node) {
        Object value;
        if (node == null || node.isNull() || node.isMissingNode()) {
            return null;
        }
        if (node.isObject()) {
            Object object;
            block17: {
                JsonParser parser = OBJECT_MAPPER.treeAsTokens((TreeNode)node);
                try {
                    object = parser.readValueAs(MAP_STRING_OBJECT);
                    if (parser == null) break block17;
                }
                catch (Throwable throwable) {
                    try {
                        if (parser != null) {
                            try {
                                parser.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new NuxeoException("Cannot map claim value to Map", (Throwable)e);
                    }
                }
                parser.close();
            }
            return object;
        }
        if (node.isArray()) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (JsonNode elem : node) {
                try {
                    list.add(OBJECT_MAPPER.treeToValue((TreeNode)elem, Object.class));
                }
                catch (IOException e) {
                    throw new NuxeoException("Cannot map Claim array value to Object", (Throwable)e);
                }
            }
            return list;
        }
        try {
            value = JWTServiceImpl.getFieldValue(node, "_value");
        }
        catch (NuxeoException e) {
            log.warn((Object)("Cannot extract primitive value from JsonNode: " + node.getClass().getName()));
            value = null;
        }
        if (value instanceof Integer) {
            value = ((Integer)value).longValue();
        }
        return value;
    }

    protected int getDefaultTTL() {
        return this.registry.getContribution().getDefaultTTL();
    }

    protected Algorithm getAlgorithm() {
        String secret = this.registry.getContribution().getSecret();
        if (StringUtils.isBlank((CharSequence)secret)) {
            return null;
        }
        return Algorithm.HMAC512((String)secret);
    }

    protected static <T> T getFieldValue(Object object, String name) {
        try {
            Field field = object.getClass().getDeclaredField(name);
            field.setAccessible(true);
            return (T)field.get(object);
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    public class JWTBuilderImpl
    implements JWTService.JWTBuilder {
        public final JWTCreator.Builder builder = JWT.create();

        public JWTBuilderImpl() {
            this.builder.withIssuer(JWTServiceImpl.NUXEO_ISSUER);
            String subject = NuxeoPrincipal.getCurrent().getActingUser();
            if (subject == null) {
                throw new NuxeoException("No currently logged-in user");
            }
            this.builder.withSubject(subject);
            this.withTTL(0);
        }

        @Override
        public JWTBuilderImpl withTTL(int ttlSeconds) {
            if (ttlSeconds <= 0) {
                ttlSeconds = JWTServiceImpl.this.getDefaultTTL();
            }
            this.builder.withExpiresAt(Date.from(Instant.now().plusSeconds(ttlSeconds)));
            return this;
        }

        @Override
        public JWTBuilderImpl withClaim(String name, Object value) {
            if (value instanceof Boolean) {
                this.builder.withClaim(name, (Boolean)value);
            } else if (value instanceof Date) {
                this.builder.withClaim(name, (Date)value);
            } else if (value instanceof Double) {
                this.builder.withClaim(name, (Double)value);
            } else if (value instanceof Integer) {
                this.builder.withClaim(name, (Integer)value);
            } else if (value instanceof Long) {
                this.builder.withClaim(name, (Long)value);
            } else if (value instanceof String) {
                this.builder.withClaim(name, (String)value);
            } else if (value instanceof Integer[]) {
                this.builder.withArrayClaim(name, (Integer[])value);
            } else if (value instanceof Long[]) {
                this.builder.withArrayClaim(name, (Long[])value);
            } else if (value instanceof String[]) {
                this.builder.withArrayClaim(name, (String[])value);
            } else {
                throw new NuxeoException("Unknown claim type: " + value);
            }
            return this;
        }

        @Override
        public String build() {
            try {
                Algorithm algorithm = JWTServiceImpl.this.getAlgorithm();
                if (algorithm == null) {
                    throw new NuxeoException("JWTService secret not configured");
                }
                return this.builder.sign(algorithm);
            }
            catch (JWTCreationException e) {
                throw new NuxeoException((Throwable)e);
            }
        }
    }

    protected static class JWTServiceConfigurationRegistry
    extends SimpleContributionRegistry<JWTServiceConfigurationDescriptor> {
        protected static final String KEY = "";
        protected static final JWTServiceConfigurationDescriptor DEFAULT_CONTRIBUTION = new JWTServiceConfigurationDescriptor();

        protected JWTServiceConfigurationRegistry() {
        }

        public String getContributionId(JWTServiceConfigurationDescriptor contrib) {
            return KEY;
        }

        public boolean isSupportingMerge() {
            return true;
        }

        public JWTServiceConfigurationDescriptor clone(JWTServiceConfigurationDescriptor orig) {
            return new JWTServiceConfigurationDescriptor(orig);
        }

        public void merge(JWTServiceConfigurationDescriptor src, JWTServiceConfigurationDescriptor dst) {
            dst.merge(src);
        }

        public JWTServiceConfigurationDescriptor getContribution() {
            JWTServiceConfigurationDescriptor contribution = (JWTServiceConfigurationDescriptor)this.getContribution(KEY);
            if (contribution == null) {
                contribution = DEFAULT_CONTRIBUTION;
            }
            return contribution;
        }
    }
}

