/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.download;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nuxeo.common.Environment;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.io.download.DownloadHelper;
import org.nuxeo.ecm.core.io.download.DownloadService;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.runtime.api.Framework;

public class DownloadServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    @Deprecated
    public static final String NXBIGFILE = "nxbigfile";

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            this.handleDownload(req, resp);
        }
        catch (IOException ioe) {
            DownloadHelper.handleClientDisconnect((IOException)ioe);
        }
    }

    protected void handleDownload(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String requestURI;
        try {
            requestURI = new URI(req.getRequestURI()).getPath();
        }
        catch (URISyntaxException e) {
            requestURI = req.getRequestURI();
        }
        String context = VirtualHostHelper.getContextPath((ServletRequest)req) + "/";
        if (!requestURI.startsWith(context)) {
            resp.sendError(404, "Invalid URL syntax");
            return;
        }
        String baseUrl = VirtualHostHelper.getBaseURL((ServletRequest)req);
        String path = requestURI.substring(context.length());
        DownloadService downloadService = (DownloadService)Framework.getService(DownloadService.class);
        downloadService.handleDownload(req, resp, baseUrl, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    protected void handleDownloadTemporaryZip(HttpServletRequest req, HttpServletResponse resp, String filePath) throws IOException {
        String[] pathParts = filePath.split("/");
        String tmpFileName = pathParts[0];
        File tmpZip = new File(Environment.getDefault().getTemp(), tmpFileName);
        try {
            Blob zipBlob = Blobs.createBlob((File)tmpZip);
            DownloadService.DownloadContext context = DownloadService.DownloadContext.newBuilder((HttpServletRequest)req, (HttpServletResponse)resp).blob(zipBlob).filename("clipboard.zip").reason("clipboardZip").build();
            ((DownloadService)Framework.getService(DownloadService.class)).downloadBlob(context);
        }
        finally {
            tmpZip.delete();
        }
    }
}

