/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.function.Function;
import net.openhft.chronicle.bytes.BinaryBytesMethodWriterInvocationHandler;
import net.openhft.chronicle.bytes.ByteStringAppender;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesComment;
import net.openhft.chronicle.bytes.BytesMarshallable;
import net.openhft.chronicle.bytes.BytesMethodWriterBuilder;
import net.openhft.chronicle.bytes.BytesPrepender;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.MethodEncoder;
import net.openhft.chronicle.bytes.MethodEncoderLookup;
import net.openhft.chronicle.bytes.MethodWriterBuilder;
import net.openhft.chronicle.bytes.StreamingDataOutput;
import net.openhft.chronicle.bytes.WriteBytesMarshallable;
import net.openhft.chronicle.core.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public interface BytesOut<Underlying>
extends StreamingDataOutput<Bytes<Underlying>>,
ByteStringAppender<Bytes<Underlying>>,
BytesPrepender<Bytes<Underlying>>,
BytesComment<BytesOut<Underlying>> {
    @NotNull
    default public <T> T bytesMethodWriter(@NotNull Class<T> tClass, Class ... additional) {
        Class[] interfaces = (Class[])ObjectUtils.addAll(tClass, (Object[])additional);
        return (T)Proxy.newProxyInstance(tClass.getClassLoader(), interfaces, (InvocationHandler)new BinaryBytesMethodWriterInvocationHandler(MethodEncoderLookup.BY_ANNOTATION, this));
    }

    @Deprecated
    @NotNull
    default public <T> MethodWriterBuilder<T> bytesMethodWriterBuilder(Function<Method, MethodEncoder> methodEncoderFunction, @NotNull Class<T> tClass) {
        return new BytesMethodWriterBuilder<T>(tClass, new BinaryBytesMethodWriterInvocationHandler(methodEncoderFunction, this));
    }

    public void writeMarshallableLength16(WriteBytesMarshallable var1);

    default public void writeObject(Class componentType, Object obj) {
        if (!componentType.isInstance(obj)) {
            throw new IllegalArgumentException("Cannot serialize " + obj.getClass() + " as an " + componentType);
        }
        if (obj instanceof BytesMarshallable) {
            ((BytesMarshallable)obj).writeMarshallable(this);
            return;
        }
        if (obj instanceof Enum) {
            this.writeEnum((Enum)obj);
            return;
        }
        if (obj instanceof BytesStore) {
            BytesStore bs = (BytesStore)obj;
            this.writeStopBit(bs.readRemaining());
            this.write(bs);
            return;
        }
        switch (componentType.getName()) {
            case "java.lang.String": {
                this.writeUtf8((String)obj);
                return;
            }
            case "java.lang.Double": {
                this.writeDouble((Double)obj);
                return;
            }
            case "java.lang.Long": {
                this.writeLong((Long)obj);
                return;
            }
            case "java.lang.Integer": {
                this.writeInt((Integer)obj);
                return;
            }
        }
        throw new UnsupportedOperationException("Not supported " + componentType);
    }
}

