/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.tag;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.platform.tag.AbstractTagService;
import org.nuxeo.ecm.platform.tag.Tag;
import org.nuxeo.ecm.platform.tag.TagService;

public class BridgeTagService
extends AbstractTagService {
    protected final AbstractTagService first;
    protected final AbstractTagService second;

    public BridgeTagService(TagService first, TagService second) {
        this.first = (AbstractTagService)first;
        this.second = (AbstractTagService)second;
    }

    public boolean hasFeature(TagService.Feature feature) {
        switch (feature) {
            case TAGS_BELONG_TO_DOCUMENT: {
                return false;
            }
        }
        throw new UnsupportedOperationException(feature.name());
    }

    public boolean supportsTag(CoreSession session, String docId) {
        return this.first.supportsTag(session, docId) || this.second.supportsTag(session, docId);
    }

    public List<Tag> getTagCloud(CoreSession session, String docId, String username, Boolean normalize) {
        return this.first.getTagCloud(session, docId, username, normalize);
    }

    @Override
    public void doTag(CoreSession session, String docId, String label, String username) {
        this.second.doTag(session, docId, label, username);
    }

    @Override
    public boolean canUntag(CoreSession session, String docId, String label) {
        boolean can1 = !this.first.getTags(session, docId).contains(label) || this.first.canUntag(session, docId, label);
        boolean can2 = !this.second.getTags(session, docId).contains(label) || this.second.canUntag(session, docId, label);
        return can1 && can2;
    }

    @Override
    public void doUntag(CoreSession session, String docId, String label) {
        this.first.doUntag(session, docId, label);
        this.second.doUntag(session, docId, label);
    }

    @Override
    public Set<String> doGetTags(CoreSession session, String docId) {
        HashSet<String> tags = new HashSet<String>();
        tags.addAll(this.first.doGetTags(session, docId));
        tags.addAll(this.second.doGetTags(session, docId));
        return tags;
    }

    @Override
    public void doCopyTags(CoreSession session, String srcDocId, String dstDocId, boolean removeExistingTags) {
        this.first.doCopyTags(session, srcDocId, dstDocId, removeExistingTags);
        this.second.doCopyTags(session, srcDocId, dstDocId, removeExistingTags);
    }

    @Override
    public List<String> doGetTagDocumentIds(CoreSession session, String label) {
        HashSet<String> ids = new HashSet<String>();
        ids.addAll(this.first.doGetTagDocumentIds(session, label));
        ids.addAll(this.second.doGetTagDocumentIds(session, label));
        return new ArrayList<String>(ids);
    }

    @Override
    public Set<String> doGetTagSuggestions(CoreSession session, String label) {
        HashSet<String> tags = new HashSet<String>();
        tags.addAll(this.first.doGetTagSuggestions(session, label));
        tags.addAll(this.second.doGetTagSuggestions(session, label));
        return tags;
    }
}

