/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.auth.oauth;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.oauth.OAuth;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthException;
import net.oauth.OAuthMessage;
import net.oauth.SimpleOAuthValidator;
import net.oauth.server.OAuthServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.URIUtils;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.oauth.consumers.NuxeoOAuthConsumer;
import org.nuxeo.ecm.platform.oauth.consumers.OAuthConsumerRegistry;
import org.nuxeo.ecm.platform.oauth.tokens.OAuthToken;
import org.nuxeo.ecm.platform.oauth.tokens.OAuthTokenStore;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.runtime.api.Framework;

public class NuxeoOAuth1Servlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(NuxeoOAuth1Servlet.class);
    public static final String ENDPOINT_REQUEST_TOKEN = "/request-token";
    public static final String ENDPOINT_AUTHORIZE = "/authorize";
    public static final String ENDPOINT_ACCESS_TOKEN = "/access-token";
    public static final String OAUTH_VERIFIER = "oauth_verifier";
    public static final String OAUTH_CALLBACK_CONFIRMED = "oauth_callback_confirmed";
    public static final String NUXEO_LOGIN_PARAM = "nuxeo_login";
    public static final String DURATION_PARAM = "duration";
    public static final String OAUTH_INFO_SESSION_KEY = "OAUTH-INFO";
    public static final String GRANT_PAGE = "oauthGrant.jsp";
    public static final String LOGIN_PAGE = "login.jsp";
    public static final String APPLICATION_X_WWW_FORM_URLENCODED = "application/x-www-form-urlencoded";

    protected static String urlEncode(String string) {
        try {
            return URLEncoder.encode(string, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pathInfo = request.getPathInfo();
        if (pathInfo == null) {
            response.sendError(404);
        } else if (pathInfo.equals(ENDPOINT_REQUEST_TOKEN)) {
            this.doGetRequestToken(request, response);
        } else if (pathInfo.equals(ENDPOINT_AUTHORIZE)) {
            this.doGetAuthorize(request, response);
        } else if (pathInfo.equals(ENDPOINT_ACCESS_TOKEN)) {
            this.doGetAccessToken(request, response);
        } else {
            response.sendError(404);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pathInfo = request.getPathInfo();
        if (pathInfo == null) {
            response.sendError(404);
        } else if (pathInfo.equals(ENDPOINT_AUTHORIZE)) {
            this.doPostAuthorize(request, response);
        } else {
            response.sendError(404);
        }
    }

    protected void doGetAuthorize(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String token = request.getParameter("oauth_token");
        OAuthTokenStore tokenStore = (OAuthTokenStore)Framework.getService(OAuthTokenStore.class);
        OAuthToken rToken = tokenStore.getRequestToken(token);
        request.getSession(true).setAttribute(OAUTH_INFO_SESSION_KEY, (Object)rToken);
        String redirectUrl = "oauthGrant.jsp?oauth_token=" + NuxeoOAuth1Servlet.urlEncode(token);
        String url = VirtualHostHelper.getBaseURL((ServletRequest)request) + "login.jsp?requestedUrl=" + NuxeoOAuth1Servlet.urlEncode(redirectUrl);
        response.sendRedirect(url);
    }

    protected void doPostAuthorize(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String token = request.getParameter("oauth_token");
        String username = request.getParameter(NUXEO_LOGIN_PARAM);
        String duration = request.getParameter(DURATION_PARAM);
        OAuthTokenStore tokenStore = (OAuthTokenStore)Framework.getService(OAuthTokenStore.class);
        OAuthToken rToken = tokenStore.addVerifierToRequestToken(token, Long.valueOf(duration));
        rToken.setNuxeoLogin(username);
        String callbackUrl = rToken.getCallbackUrl();
        if (callbackUrl == null) {
            OAuthConsumerRegistry consumerRegistry = (OAuthConsumerRegistry)Framework.getService(OAuthConsumerRegistry.class);
            NuxeoOAuthConsumer consumer = consumerRegistry.getConsumer(rToken.getConsumerKey());
            if (consumer == null) {
                int sc = (Integer)OAuth.Problems.TO_HTTP_CODE.get("consumer_key_unknown");
                response.sendError(sc, "Unknown consumer key");
                return;
            }
            callbackUrl = consumer.getCallbackURL();
            if (callbackUrl == null) {
                log.error((Object)("No callback URL configured for consumer: " + rToken.getConsumerKey()));
                response.sendError(500);
                return;
            }
        }
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("oauth_token", rToken.getToken());
        params.put(OAUTH_VERIFIER, rToken.getVerifier());
        String targetUrl = URIUtils.addParametersToURIQuery((String)callbackUrl, params);
        response.sendRedirect(targetUrl);
    }

    protected void doGetRequestToken(HttpServletRequest request, HttpServletResponse response) throws IOException {
        OAuthMessage message = OAuthServlet.getMessage((HttpServletRequest)request, null);
        String consumerKey = message.getConsumerKey();
        OAuthConsumerRegistry consumerRegistry = (OAuthConsumerRegistry)Framework.getService(OAuthConsumerRegistry.class);
        NuxeoOAuthConsumer consumer = consumerRegistry.getConsumer(consumerKey, message.getSignatureMethod());
        if (consumer == null) {
            int sc = (Integer)OAuth.Problems.TO_HTTP_CODE.get("consumer_key_unknown");
            response.sendError(sc, "Unknown consumer key");
            return;
        }
        OAuthAccessor accessor = new OAuthAccessor((OAuthConsumer)consumer);
        SimpleOAuthValidator validator = new SimpleOAuthValidator();
        try {
            validator.validateMessage(message, accessor);
        }
        catch (IOException | URISyntaxException | OAuthException e) {
            int sc = (Integer)OAuth.Problems.TO_HTTP_CODE.get("signature_invalid");
            response.sendError(sc, "Cannot validate signature");
            return;
        }
        String callbackUrl = message.getParameter("oauth_callback");
        OAuthTokenStore tokenStore = (OAuthTokenStore)Framework.getService(OAuthTokenStore.class);
        OAuthToken rToken = tokenStore.createRequestToken(consumerKey, callbackUrl);
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("oauth_token", rToken.getToken());
        params.put("oauth_token_secret", rToken.getTokenSecret());
        params.put(OAUTH_CALLBACK_CONFIRMED, "true");
        String body = URIUtils.getURIQuery(params);
        response.setStatus(200);
        response.setContentType(APPLICATION_X_WWW_FORM_URLENCODED);
        response.getWriter().write(body);
    }

    protected void doGetAccessToken(HttpServletRequest request, HttpServletResponse response) throws IOException {
        OAuthMessage message = OAuthServlet.getMessage((HttpServletRequest)request, null);
        String consumerKey = message.getConsumerKey();
        String token = message.getToken();
        OAuthConsumerRegistry consumerRegistry = (OAuthConsumerRegistry)Framework.getService(OAuthConsumerRegistry.class);
        NuxeoOAuthConsumer consumer = consumerRegistry.getConsumer(consumerKey, message.getSignatureMethod());
        if (consumer == null) {
            int sc = (Integer)OAuth.Problems.TO_HTTP_CODE.get("consumer_key_unknown");
            response.sendError(sc, "Unknown consumer key");
            return;
        }
        OAuthAccessor accessor = new OAuthAccessor((OAuthConsumer)consumer);
        OAuthTokenStore tokenStore = (OAuthTokenStore)Framework.getService(OAuthTokenStore.class);
        OAuthToken rToken = tokenStore.getRequestToken(token);
        accessor.requestToken = rToken.getToken();
        accessor.tokenSecret = rToken.getTokenSecret();
        SimpleOAuthValidator validator = new SimpleOAuthValidator();
        try {
            validator.validateMessage(message, accessor);
        }
        catch (IOException | URISyntaxException | OAuthException e) {
            int errCode = (Integer)OAuth.Problems.TO_HTTP_CODE.get("signature_invalid");
            response.sendError(errCode, "Cannot validate signature");
            return;
        }
        String verifier = message.getParameter(OAUTH_VERIFIER);
        boolean allowByPassVerifier = false;
        if (verifier == null) {
            allowByPassVerifier = consumer.allowBypassVerifier();
        }
        if (!rToken.getVerifier().equals(verifier) && !allowByPassVerifier) {
            response.sendError(401, "Verifier is not correct");
            return;
        }
        OAuthToken aToken = tokenStore.createAccessTokenFromRequestToken(rToken);
        response.setStatus(200);
        response.setContentType(APPLICATION_X_WWW_FORM_URLENCODED);
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("oauth_token", aToken.getToken());
        params.put("oauth_token_secret", aToken.getTokenSecret());
        String body = URIUtils.getURIQuery(params);
        response.getWriter().write(body);
    }
}

