/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.http.readonly.filter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.security.SecurityService;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.runtime.api.Framework;

public class RequestValidator {
    private final Map<String, List<String>> indexTypes;

    public RequestValidator() {
        ElasticSearchAdmin esa = (ElasticSearchAdmin)Framework.getService(ElasticSearchAdmin.class);
        this.indexTypes = new HashMap<String, List<String>>();
        for (String name : esa.getRepositoryNames()) {
            ArrayList<String> types = new ArrayList<String>();
            types.add("doc");
            this.indexTypes.put(esa.getIndexNameForRepository(name), types);
        }
    }

    public void checkValidDocumentId(String documentId) {
        if (documentId == null) {
            throw new IllegalArgumentException("Invalid document id");
        }
    }

    @NotNull
    public String getTypes(String indices, String types) {
        HashSet validTypes = new HashSet();
        for (String index : indices.split(",")) {
            validTypes.addAll(this.indexTypes.get(index));
        }
        if (types == null || "*".equals(types) || "_all".equals(types)) {
            return StringUtils.join(validTypes, (char)',');
        }
        for (String type : types.split(",")) {
            if (validTypes.contains(type)) continue;
            throw new IllegalArgumentException("Invalid index type: " + type);
        }
        return types;
    }

    @NotNull
    public String getIndices(String indices) {
        if (indices == null || "*".equals(indices) || "_all".equals(indices)) {
            return StringUtils.join(this.indexTypes.keySet(), (char)',');
        }
        for (String index : indices.split(",")) {
            if (this.indexTypes.containsKey(index)) continue;
            throw new IllegalArgumentException("Invalid index submitted: " + index);
        }
        return indices;
    }

    public void checkAccess(NuxeoPrincipal principal, String docAcl) {
        try {
            JSONObject docAclJson = new JSONObject(docAcl);
            JSONArray acl = docAclJson.getJSONObject("fields").getJSONArray("ecm:acl");
            String[] principals = SecurityService.getPrincipalsToCheck((NuxeoPrincipal)principal);
            for (int i = 0; i < acl.length(); ++i) {
                for (String name : principals) {
                    if (!name.equals(acl.getString(i))) continue;
                    return;
                }
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        throw new SecurityException("Unauthorized access");
    }
}

