/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.ReferenceMap;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.storage.StateAccessor;
import org.nuxeo.ecm.core.storage.sql.BaseProperty;
import org.nuxeo.ecm.core.storage.sql.CollectionFragment;
import org.nuxeo.ecm.core.storage.sql.CollectionProperty;
import org.nuxeo.ecm.core.storage.sql.Fragment;
import org.nuxeo.ecm.core.storage.sql.FragmentGroup;
import org.nuxeo.ecm.core.storage.sql.FragmentsMap;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.ModelProperty;
import org.nuxeo.ecm.core.storage.sql.PersistenceContext;
import org.nuxeo.ecm.core.storage.sql.RowId;
import org.nuxeo.ecm.core.storage.sql.SimpleFragment;
import org.nuxeo.ecm.core.storage.sql.SimpleProperty;

public class Node
implements StateAccessor {
    private final PersistenceContext context;
    private final Model model;
    protected final SimpleFragment hierFragment;
    protected final FragmentsMap fragments;
    protected String path;
    private final Map<String, BaseProperty> propertyCache;
    private Boolean isVersion;
    private static final String[] NO_MIXINS = new String[0];

    protected Node(PersistenceContext context, FragmentGroup fragmentGroup, String path) {
        this.context = context;
        this.model = context.model;
        this.hierFragment = fragmentGroup.hier;
        this.fragments = fragmentGroup.fragments == null ? new FragmentsMap() : fragmentGroup.fragments;
        this.path = path;
        this.propertyCache = new ReferenceMap(0, 1);
    }

    public Serializable getId() {
        return this.hierFragment.getId();
    }

    public String getName() {
        return this.getHierFragment().getString("name");
    }

    public Long getPos() {
        return (Long)this.getHierFragment().get("pos");
    }

    public String getPrimaryType() {
        return this.hierFragment.getString("primarytype");
    }

    public Serializable getParentId() {
        return this.getHierFragment().get("parentid");
    }

    public String getPath() {
        String p = this.path;
        if (p != null) {
            this.path = null;
        }
        return p;
    }

    protected SimpleFragment getHierFragment() {
        return this.hierFragment;
    }

    public boolean isVersion() {
        if (this.isVersion == null) {
            this.isVersion = (Boolean)this.getSimpleProperty("ecm:isVersion").getValue();
            if (this.isVersion == null) {
                this.isVersion = Boolean.FALSE;
            }
        }
        return this.isVersion;
    }

    public boolean isProxy() {
        String primaryType = this.getPrimaryType();
        if (primaryType == null) {
            throw new NullPointerException(this.toString());
        }
        return primaryType.equals("ecm:proxy");
    }

    public String[] getMixinTypes() {
        String[] value = (String[])this.hierFragment.get("mixintypes");
        return value == null ? NO_MIXINS : (String[])value.clone();
    }

    public Set<String> getAllMixinTypes() {
        LinkedHashSet<String> mixins = new LinkedHashSet<String>(this.model.getDocumentTypeFacets(this.getPrimaryType()));
        mixins.addAll(Arrays.asList(this.getMixinTypes()));
        return mixins;
    }

    public boolean hasMixinType(String mixin) {
        if (this.model.getDocumentTypeFacets(this.getPrimaryType()).contains(mixin)) {
            return true;
        }
        for (String m : this.getMixinTypes()) {
            if (!m.equals(mixin)) continue;
            return true;
        }
        return false;
    }

    protected void clearCache() {
        this.propertyCache.clear();
    }

    public SimpleProperty getSimpleProperty(String name) {
        SimpleProperty property = (SimpleProperty)this.propertyCache.get(name);
        if (property == null) {
            ModelProperty propertyInfo = this.getPropertyInfo(name);
            if (propertyInfo == null) {
                throw new PropertyNotFoundException(name);
            }
            property = this.makeSimpleProperty(name, propertyInfo);
            this.propertyCache.put(name, property);
        }
        return property;
    }

    protected SimpleProperty makeSimpleProperty(String name, ModelProperty propertyInfo) {
        String fragmentName = propertyInfo.fragmentName;
        Fragment fragment = (Fragment)this.fragments.get(fragmentName);
        if (fragment == null) {
            RowId rowId = new RowId(fragmentName, this.getId());
            fragment = this.context.get(rowId, true);
            this.fragments.put(fragmentName, fragment);
        }
        return new SimpleProperty(name, propertyInfo.propertyType, propertyInfo.readonly, (SimpleFragment)fragment, propertyInfo.fragmentKey);
    }

    public CollectionProperty getCollectionProperty(String name) {
        CollectionProperty property = (CollectionProperty)this.propertyCache.get(name);
        if (property == null) {
            ModelProperty propertyInfo = this.getPropertyInfo(name);
            if (propertyInfo == null) {
                throw new PropertyNotFoundException(name);
            }
            property = this.makeCollectionProperty(name, propertyInfo);
            this.propertyCache.put(name, property);
        }
        return property;
    }

    protected CollectionProperty makeCollectionProperty(String name, ModelProperty propertyInfo) {
        String fragmentName = propertyInfo.fragmentName;
        Fragment fragment = (Fragment)this.fragments.get(fragmentName);
        if (fragment == null) {
            RowId rowId = new RowId(fragmentName, this.getId());
            fragment = this.context.get(rowId, true);
        }
        if (fragment instanceof CollectionFragment) {
            return new CollectionProperty(name, propertyInfo.propertyType, propertyInfo.readonly, (CollectionFragment)fragment);
        }
        this.fragments.put(fragmentName, fragment);
        return new CollectionProperty(name, propertyInfo.propertyType, propertyInfo.readonly, (SimpleFragment)fragment, propertyInfo.fragmentKey);
    }

    protected ModelProperty getPropertyInfo(String name) {
        ModelProperty propertyInfo = this.model.getPropertyInfo(this.getPrimaryType(), name);
        if (propertyInfo != null) {
            return propertyInfo;
        }
        for (String mixin : this.getMixinTypes()) {
            propertyInfo = this.model.getMixinPropertyInfo(mixin, name);
            if (propertyInfo == null) continue;
            return propertyInfo;
        }
        if (this.isProxy() && (propertyInfo = this.model.getProxySchemasPropertyInfo(name)) != null) {
            return propertyInfo;
        }
        return null;
    }

    public void setSimpleProperty(String name, Object value) {
        SimpleProperty property = this.getSimpleProperty(name);
        property.setValue(value);
    }

    public void setCollectionProperty(String name, Object[] value) {
        CollectionProperty property = this.getCollectionProperty(name);
        property.setValue(value);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof Node) {
            return this.equals((Node)other);
        }
        return false;
    }

    private boolean equals(Node other) {
        return this.getId() == other.getId();
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(uuid=" + this.getId() + ", name=" + this.getName() + ", primaryType=" + this.getPrimaryType() + ", parentId=" + this.getParentId() + ")";
    }

    public Object getSingle(String name) throws PropertyException {
        return this.getSimpleProperty(name).getValue();
    }

    public Object[] getArray(String name) throws PropertyException {
        return this.getCollectionProperty(name).getValue();
    }

    public void setSingle(String name, Object value) throws PropertyException {
        this.getSimpleProperty(name).setValue(value);
    }

    public void setArray(String name, Object[] value) throws PropertyException {
        this.getCollectionProperty(name).setValue(value);
    }
}

