/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.content.template.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.platform.content.template.service.ACEDescriptor;
import org.nuxeo.ecm.platform.content.template.service.TemplateItemDescriptor;

@XObject(value="factoryBinding")
public class FactoryBindingDescriptor {
    private static final Log log = LogFactory.getLog(FactoryBindingDescriptor.class);
    @XNode(value="@name")
    private String name;
    @XNode(value="@factoryName")
    private String factoryName;
    @XNode(value="@targetType")
    private String targetType;
    @XNode(value="@targetFacet")
    private String targetFacet;
    @XNode(value="@append")
    private Boolean append = Boolean.FALSE;
    @XNodeMap(value="option", key="@name", type=HashMap.class, componentType=String.class)
    private Map<String, String> options;
    @XNodeList(value="template/templateItem", type=ArrayList.class, componentType=TemplateItemDescriptor.class)
    private List<TemplateItemDescriptor> template;
    @XNodeList(value="acl/ace", type=ArrayList.class, componentType=ACEDescriptor.class)
    private List<ACEDescriptor> rootAcl;

    public FactoryBindingDescriptor() {
        this.options = new HashMap<String, String>();
        this.template = new ArrayList<TemplateItemDescriptor>();
        this.rootAcl = new ArrayList<ACEDescriptor>();
    }

    public FactoryBindingDescriptor(FactoryBindingDescriptor toCopy) {
        this.name = toCopy.name;
        this.factoryName = toCopy.factoryName;
        this.targetType = toCopy.targetType;
        this.targetFacet = toCopy.targetFacet;
        this.options = new HashMap<String, String>(toCopy.options);
        this.template = toCopy.template.stream().map(TemplateItemDescriptor::new).collect(Collectors.toList());
        this.rootAcl = toCopy.rootAcl.stream().map(ACEDescriptor::new).collect(Collectors.toList());
    }

    public String getFactoryName() {
        return this.factoryName;
    }

    protected void setFactoryName(String factoryName) {
        this.factoryName = factoryName;
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public String getTargetType() {
        return this.targetType;
    }

    protected void setTargetType(String targetType) {
        this.targetType = targetType;
    }

    public String getTargetFacet() {
        return this.targetFacet;
    }

    protected void setTargetFacet(String targetFacet) {
        this.targetFacet = targetFacet;
    }

    public List<TemplateItemDescriptor> getTemplate() {
        return this.template;
    }

    public List<ACEDescriptor> getRootAcl() {
        return this.rootAcl;
    }

    public Boolean getAppend() {
        return this.append;
    }

    public void setAppend(Boolean append) {
        this.append = append;
    }

    public void merge(FactoryBindingDescriptor src) {
        if (Boolean.TRUE.equals(src.getAppend())) {
            if (log.isInfoEnabled()) {
                log.info((Object)("FactoryBinding " + this.name + " is merging with " + src.getName()));
            }
        } else {
            this.factoryName = src.getFactoryName();
            this.name = src.getName();
            this.targetType = src.getTargetType();
            this.targetFacet = src.getTargetFacet();
            this.append = Boolean.FALSE;
            this.options.clear();
            this.rootAcl.clear();
            this.template.clear();
        }
        this.options.putAll(src.getOptions());
        this.rootAcl.addAll(src.getRootAcl());
        this.template.addAll(src.getTemplate());
    }
}

